<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\SKPTApplication;
use App\Models\Peninjauan;
use Carbon\Carbon;
use DB;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $data['title'] = 'Dashboard SKPT';

        // Ambil data SKPT dengan relasi peninjauan
        $user = auth()->user();
        $skptQuery = SKPTApplication::with(['dataPeninjauan.coordinates', 'dataPeninjauan.dataKecamatan']);
        // Cek role guest menggunakan Spatie Permission
        // Cek role guest tanpa memanggil method yang tidak ada
        if (auth()->user()->hasRole('guest')) {
            $skptQuery->where('created_by', $user->id);
        }
        $data['skptApplications'] = $skptQuery->orderBy('created_at', 'desc')->get();
        // dd($data['skptApplications']);
        // Statistik
        if (auth()->user()->hasRole('guest')) {
            $data['stats'] = [
                'total' => SKPTApplication::where('created_by', $user->id)->count(),
                'belum_selesai' => SKPTApplication::where('created_by', $user->id)->where('status_permohonan', 'BELUM SELESAI')->count(),
                'selesai' => SKPTApplication::where('created_by', $user->id)->where('status_permohonan', 'SELESAI')->count(),
                'dokumen_lengkap' => SKPTApplication::where('created_by', $user->id)->where('status_kelengkapan_dokumen', 'LENGKAP')->count(),
                'dokumen_belum_lengkap' => SKPTApplication::where('created_by', $user->id)->where('status_kelengkapan_dokumen', 'BELUM LENGKAP')->count(),
            ];
        } else {
            $data['stats'] = [
                'total' => SKPTApplication::count(),
                'belum_selesai' => SKPTApplication::where('status_permohonan', 'BELUM SELESAI')->count(),
                'selesai' => SKPTApplication::where('status_permohonan', 'SELESAI')->count(),
                'dokumen_lengkap' => SKPTApplication::where('status_kelengkapan_dokumen', 'LENGKAP')->count(),
                'dokumen_belum_lengkap' => SKPTApplication::where('status_kelengkapan_dokumen', 'BELUM LENGKAP')->count(),
            ];
        }

        // Ambil data untuk map dengan koordinat
        $data['mapData'] = [];
        foreach($data['skptApplications'] as $skpt) {
            if($skpt->dataPeninjauan && $skpt->dataPeninjauan->coordinates->count() > 0) {
                $coordinates = $skpt->dataPeninjauan->getPolygonCoordinates();
                $data['mapData'][] = [
                    'id' => $skpt->id,
                    'no_registrasi' => $skpt->no_registrasi,
                    'nama_pemohon' => $skpt->nama_pemohon,
                    'status' => $skpt->status_permohonan,
                    'luas' => $skpt->luas,
                    'alamat' => $skpt->alamat_tanah ?? '',
                    'kecamatan' => $skpt->dataPeninjauan->dataKecamatan->nama ?? $skpt->dataPeninjauan->kecamatan ?? '',
                    'coordinates' => $coordinates,
                    'color' => $skpt->status_permohonan == 'SELESAI' ? '#10b981' : '#f59e0b'
                ];
            }
        }

        return view('admin.home.index', $data);
    }

    public function dashboard()
    {
        $data['title'] = 'Dashboard';
        return view('admin.dashboard.index', $data);
    }

    // Ajax method untuk filter data
    public function filterSkpt(Request $request)
    {
        $user = auth()->user();
        $query = SKPTApplication::with(['dataPeninjauan.coordinates', 'dataPeninjauan.dataKecamatan']);
        // Jika guest, filter hanya data miliknya
        if (auth()->user()->hasRole('guest')) {
            $query->where('created_by', $user->id);
        }

        // Filter berdasarkan status
        if($request->status && $request->status != 'all') {
            $query->where('status_permohonan', $request->status);
        }

        // Filter berdasarkan tanggal
        if($request->date_from) {
            $query->whereDate('created_at', '>=', $request->date_from);
        }
        if($request->date_to) {
            $query->whereDate('created_at', '<=', $request->date_to);
        }

        // Search
        if($request->search) {
            $query->search($request->search);
        }

        $applications = $query->orderBy('created_at', 'desc')->get();

        // Format data untuk response
        $mapData = [];
        foreach($applications as $skpt) {
            if($skpt->dataPeninjauan && $skpt->dataPeninjauan->coordinates->count() > 0) {
                $coordinates = $skpt->dataPeninjauan->getPolygonCoordinates();
                $mapData[] = [
                    'id' => $skpt->id,
                    'no_registrasi' => $skpt->no_registrasi,
                    'nama_pemohon' => $skpt->nama_pemohon,
                    'status' => $skpt->status_permohonan,
                    'luas' => $skpt->luas,
                    'alamat' => $skpt->alamat_tanah ?? '',
                    'kecamatan' => $skpt->dataPeninjauan->dataKecamatan->nama ?? $skpt->dataPeninjauan->kecamatan ?? '',
                    'coordinates' => $coordinates,
                    'color' => $skpt->status_permohonan == 'SELESAI' ? '#10b981' : '#f59e0b'
                ];
            }
        }

        return response()->json([
            'success' => true,
            'data' => $mapData,
            'count' => $applications->count()
        ]);
    }


}
