<?php

namespace App\Http\Controllers;

use App\Models\SpSipt;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class PenerbitanSpmptController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:penerbitan-skpt.view', ['only' => ['index', 'show', 'preview', 'getVerificationHistory']]);
        $this->middleware('permission:penerbitan-skpt.verify', ['only' => ['verifyDocument', 'updateDocumentStatus']]);
        $this->middleware('permission:penerbitan-skpt.finalize', ['only' => ['finalizeDocument']]);
        $this->middleware('permission:penerbitan-skpt.print', ['only' => ['printSkpt']]);
    }
    public function index(Request $request)
    {
        $query = SpSipt::with(['dataKampung', 'kecamatan', 'coordinates'])
            ->where('status', 'selesai'); // Hanya yang sudah selesai
        // Filter berdasarkan tahun SP-MPT
        if ($request->filled('tahun_spmpt')) {
            $query->whereYear('created_at', $request->tahun_spmpt);
        }
        // Filter berdasarkan pencarian
        if ($request->filled('cari_berdasarkan') && $request->filled('search')) {
            switch ($request->cari_berdasarkan) {
                case 'no_registrasi':
                    $query->where('nomor_surat', 'LIKE', '%' . $request->search . '%');
                    break;
                case 'nama_pemohon':
                    $query->where('pemohon_nama', 'LIKE', '%' . $request->search . '%');
                    break;
            }
        }

        $applications = $query->orderBy('created_at', 'desc')->paginate(10)->withQueryString();
        // Data untuk filter tahun
        $years = SpSipt::where('status', 'selesai')
            ->selectRaw('YEAR(created_at) as year')
            ->distinct()
            ->orderBy('year', 'desc')
            ->pluck('year');

        return view('admin.penerbitan-spmpt.index', compact('applications', 'years'));
    }

    public function show($id)
    {
        $application = SpSipt::with(['dataKampung', 'kecamatan', 'coordinates', 'dokumen'])
            ->where('status', 'selesai')
            ->findOrFail($id);

        // If request is AJAX, return JSON
        if (request()->ajax()) {
            return response()->json([
                'id' => $application->id,
                'nomor_surat' => $application->nomor_surat,
                'pemohon_nama' => $application->pemohon_nama,
                'pemohon_nik' => $application->pemohon_nik,
                'terlapor_nama' => $application->terlapor_nama,
                'status' => $application->status,
                'created_at' => $application->created_at->format('d M Y'),
            ]);
        }

        return view('admin.penerbitan-spmpt.show', compact('application'));
    }

    public function preview($id)
    {
        $spSipt = SpSipt::with(['dataKampung', 'kecamatan', 'coordinates', 'dokumen'])
            ->where('status', 'selesai')
            ->findOrFail($id);

        return view('admin.penerbitan-spmpt.print', compact('spSipt'));
    }

    public function print($id)
    {
        $spSipt = SpSipt::with(['dataKampung', 'kecamatan', 'coordinates', 'dokumen'])
            ->where('status', 'selesai')
            ->findOrFail($id);

        return view('admin.penerbitan-spmpt.print', compact('spSipt'));
    }
}
