<?php

namespace App\Http\Requests;

use App\Models\SKPTAdditionalDocument;
use Illuminate\Foundation\Http\FormRequest;

class AdditionalDocumentUploadRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $maxFileSize = SKPTAdditionalDocument::getMaxFileSize() / 1024; // Convert to KB
        $allowedExtensions = implode(',', SKPTAdditionalDocument::getAllowedExtensions());

        return [
            'document_name' => 'required|string|max:255',
            'document_description' => 'nullable|string|max:1000',
            'file' => [
                'required',
                'file',
                'mimes:' . $allowedExtensions,
                'max:' . $maxFileSize,
            ],
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        $maxFileSizeMB = SKPTAdditionalDocument::getMaxFileSize() / 1024 / 1024;
        $allowedExtensions = implode(', ', SKPTAdditionalDocument::getAllowedExtensions());

        return [
            'document_name.required' => 'Nama dokumen harus diisi.',
            'document_name.max' => 'Nama dokumen maksimal 255 karakter.',
            'document_description.max' => 'Deskripsi dokumen maksimal 1000 karakter.',
            'file.required' => 'File harus dipilih untuk diupload.',
            'file.file' => 'File yang dipilih tidak valid.',
            'file.mimes' => 'File harus berformat: ' . $allowedExtensions,
            'file.max' => 'Ukuran file maksimal ' . $maxFileSizeMB . 'MB.',
        ];
    }

    /**
     * Get custom attributes for validator errors.
     */
    public function attributes(): array
    {
        return [
            'document_name' => 'nama dokumen',
            'document_description' => 'deskripsi dokumen',
            'file' => 'file dokumen',
        ];
    }
}