<?php

namespace App\Http\Requests;

use App\Models\SKPTDocument;
use Illuminate\Foundation\Http\FormRequest;

class DocumentUploadRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $maxFileSize = SKPTDocument::getMaxFileSize() / 1024; // Convert to KB
        $allowedExtensions = implode(',', SKPTDocument::getAllowedExtensions());

        return [
            'file' => [
                'required',
                'file',
                'mimes:' . $allowedExtensions,
                'max:' . $maxFileSize,
            ],
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        $maxFileSizeMB = SKPTDocument::getMaxFileSize() / 1024 / 1024;
        $allowedExtensions = implode(', ', SKPTDocument::getAllowedExtensions());

        return [
            'file.required' => 'File harus dipilih untuk diupload.',
            'file.file' => 'File yang dipilih tidak valid.',
            'file.mimes' => 'File harus berformat: ' . $allowedExtensions,
            'file.max' => 'Ukuran file maksimal ' . $maxFileSizeMB . 'MB.',
        ];
    }

    /**
     * Get custom attributes for validator errors.
     */
    public function attributes(): array
    {
        return [
            'file' => 'file dokumen',
        ];
    }
}