<?php


namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Wildside\Userstamps\Userstamps;
use Illuminate\Database\Eloquent\SoftDeletes;

class BeritaAcara extends Model
{
    use HasFactory;

    protected $table = 'berita_acara';
    
    protected $fillable = [
        'peninjauan_id',
        'berita_acara_type_id',
        'nomor_ba',
        'tanggal_ba',
        'tempat_pelaksanaan',
        'data_spesifik',
        'catatan',
        'status'
    ];

    protected $casts = [
        'tanggal_ba' => 'date',
        'data_spesifik' => 'array'
    ];

    // Relationships
    public function peninjauan(): BelongsTo
    {
        return $this->belongsTo(Peninjauan::class);
    }

    public function beritaAcaraType(): BelongsTo
    {
        return $this->belongsTo(BeritaAcaraType::class);
    }

    public function participants(): HasMany
    {
        return $this->hasMany(BaParticipant::class);
    }

    public function landBoundaries(): HasMany
    {
        return $this->hasMany(LandBoundary::class);
    }

    public function landOwnershipHistory(): HasMany
    {
        return $this->hasMany(LandOwnershipHistory::class);
    }

    // Helper methods
    public function getParticipantsByRole($role)
    {
        return $this->participants()->where('role', $role)->get();
    }
}