<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Wildside\Userstamps\Userstamps;

class CheckIn extends Model
{
    use HasFactory, SoftDeletes, Userstamps;

    protected $table = 'tr_checkin';

    protected $fillable = [
        'booking_id',
        'check_in_time',
        'notes',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'check_in_time' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime'
    ];

    // Relationship dengan Booking
    public function booking()
    {
        return $this->belongsTo(Booking::class, 'booking_id', 'id');
    }

    // Relationship dengan User yang membuat check-in
    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    // Relationship dengan User yang mengupdate check-in
    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    // Accessor untuk format tanggal Indonesia
    public function getCheckInTimeFormattedAttribute()
    {
        return $this->check_in_time ? $this->check_in_time->format('d/m/Y H:i') : null;
    }

    // Scope untuk filter berdasarkan tanggal
    public function scopeToday($query)
    {
        return $query->whereDate('check_in_time', today());
    }

    public function scopeThisMonth($query)
    {
        return $query->whereMonth('check_in_time', now()->month)
                    ->whereYear('check_in_time', now()->year);
    }
}