<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

// 9. Model Coordinate Points
class CoordinatePoint extends Model
{
    use HasFactory;

    protected $table = 'coordinate_points';
    
    protected $fillable = [
        'survey_coordinate_id',
        'point_sequence',
        'point_label',
        'utm_x',
        'utm_y',
        'utm_z',
        'latitude',
        'longitude',
        'elevation',
        'accuracy_horizontal',
        'accuracy_vertical',
        'measurement_method',
        'description',
        'is_boundary_point'
    ];

    protected $casts = [
        'utm_x' => 'decimal:3',
        'utm_y' => 'decimal:3',
        'utm_z' => 'decimal:3',
        'latitude' => 'decimal:8',
        'longitude' => 'decimal:8',
        'elevation' => 'decimal:3',
        'accuracy_horizontal' => 'decimal:3',
        'accuracy_vertical' => 'decimal:3',
        'is_boundary_point' => 'boolean'
    ];

    // Relationships
    public function surveyCoordinate(): BelongsTo
    {
        return $this->belongsTo(SurveyCoordinate::class);
    }

    // Scopes
    public function scopeOrderedBySequence($query)
    {
        return $query->orderBy('point_sequence');
    }

    public function scopeBoundaryPoints($query)
    {
        return $query->where('is_boundary_point', true);
    }

    // Helper methods
    public function getLatLngAttribute()
    {
        return [$this->latitude, $this->longitude];
    }
}