<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use Wildside\Userstamps\Userstamps;
use Illuminate\Database\Eloquent\SoftDeletes;

class MapLayer extends Model
{
    use HasFactory;

    protected $table = 'map_layers';
    
    protected $fillable = [
        'layer_name',
        'layer_type',
        'data_source',
        'layer_url',
        'layer_options',
        'style_options',
        'z_index',
        'is_active',
        'is_visible_default',
        'description'
    ];

    protected $casts = [
        'layer_options' => 'array',
        'style_options' => 'array',
        'is_active' => 'boolean',
        'is_visible_default' => 'boolean'
    ];

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeByType($query, $type)
    {
        return $query->where('layer_type', $type);
    }

    public function scopeOrderedByZIndex($query)
    {
        return $query->orderBy('z_index');
    }
}
