<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Wildside\Userstamps\Userstamps;
use Illuminate\Database\Eloquent\SoftDeletes;

class MsServiceCategory extends Model
{
    use HasFactory, Userstamps, SoftDeletes;
    
    protected $table = 'ms_service_category';
    protected $guarded = [];

    // Relationships
    public function services()
    {
        return $this->hasMany(MsService::class, 'service_category_id');
    }

    // Accessors
    public function getActiveServicesCountAttribute()
    {
        return $this->services()->count();
    }

    // Scopes
    public function scopeWithServiceCount($query)
    {
        return $query->withCount('services');
    }

    public function scopeActive($query)
    {
        return $query->whereHas('services');
    }

    // Methods
    public function hasServices()
    {
        return $this->services()->exists();
    }
}