<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Pengeluaran extends Model
{
    use HasFactory;

    protected $fillable = [
        'tanggal','deskripsi','jumlah_pengeluaran','status','verified_at','verified_by'
    ];

    protected $casts = [
        'tanggal' => 'date',
        'jumlah_pengeluaran' => 'decimal:2',
        'status' => 'boolean',
        'verified_at' => 'datetime',
    ];


    // Accessor untuk format rupiah
    public function getJumlahFormatAttribute()
    {
        return 'Rp ' . number_format($this->jumlah_pengeluaran, 0, ',', '.');
    }

    // Accessor untuk format tanggal Indonesia
    public function getTanggalFormatAttribute()
    {
        return Carbon::parse($this->tanggal)->locale('id')->translatedFormat('d F Y');
    }

    // Scope untuk filter berdasarkan bulan
    public function scopeByMonth($query, $month, $year = null)
    {
        $year = $year ?: date('Y');
        return $query->whereMonth('tanggal', $month)->whereYear('tanggal', $year);
    }

    // Scope untuk filter berdasarkan tahun
    public function scopeByYear($query, $year)
    {
        return $query->whereYear('tanggal', $year);
    }
}