<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;
// 1. Model Peninjauan
class Peninjauan extends Model
{
     use HasFactory, SoftDeletes;

    protected $table = 'peninjauan';
    protected $guarded = [''];
    protected $casts = [
        'ba_tanggal' => 'date',
        'tanggal_ba_kesepakatan' => 'date',
        'bulan_tahun_penelitian' => 'date',
        'imb_tanggal' => 'date',
        'tanggal_pengukuran' => 'date',
        'surat_tugas_tanggal' => 'date',
        'tanggal_permohonan' => 'date',
        'tanggal_pengukuran_koordinat' => 'date',
        'tanggal_pengesahan' => 'date',
        'verified_at' => 'datetime',
        'luas' => 'decimal:2',
        'luas_terukur_kesimpulan' => 'decimal:2',
        'luas_surat_kesimpulan' => 'decimal:2',
        'ukuran_patok' => 'decimal:2',
        'rekomendasi_skpt' => 'boolean',
        'rekomendasi_sertifikat' => 'boolean',
        'rekomendasi_mediasi' => 'boolean',
        'rekomendasi_verifikasi' => 'boolean',
        'rekomendasi_tolak' => 'boolean'
    ];

    // Relationships
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function skpt()
{
    return $this->belongsTo(SKPTApplication::class, 'skpt_id', 'id');
}

public function dataKampung()
{
    return $this->belongsTo(Kampung::class, 'kampung_kelurahan', 'nama_kampung');
}

public function dataKecamatan()
{
    return $this->belongsTo(Kecamatan::class, 'kecamatan', 'id');
}

    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function verifier()
    {
        return $this->belongsTo(User::class, 'verified_by');
    }

    public function peralihan()
    {
        return $this->hasMany(PeninjauanPeralihan::class, 'peninjauan_id')->orderBy('urutan');
    }

    public function coordinates()
    {
        return $this->hasMany(PeninjauanCoordinate::class, 'peninjauan_id')->orderBy('sequence');
    }

    public function coordinatesUtm()
    {
        return $this->hasMany(PeninjauanCoordinateUtm::class, 'peninjauan_id')->orderBy('sequence');
    }

    public function documents()
    {
        return $this->hasMany(PeninjauanDocument::class, 'peninjauan_id');
    }

    public function beritaAcara()
    {
        return $this->hasMany(BeritaAcaraPeninjauan::class, 'peninjauan_id');
    }

    public function lastMapImage()
    {
        return $this->hasOne(PeninjauanDocument::class, 'peninjauan_id')
            ->where('document_type', 'map_image')
            ->latest();
    }

    // Scopes
    public function scopeDraft($query)
    {
        return $query->where('status', 'draft');
    }

    public function scopeSubmitted($query)
    {
        return $query->where('status', 'submitted');
    }

    public function scopeVerified($query)
    {
        return $query->where('status', 'verified');
    }

    public function scopeCompleted($query)
    {
        return $query->where('status', 'completed');
    }

    // Methods
    public function getPolygonCoordinates()
    {
        return $this->coordinates->map(function ($coord) {
            return [
                'lat' => $coord->latitude,
                'lng' => $coord->longitude,
                'sequence' => $coord->sequence
            ];
        });
    }

    public function calculateArea()
    {
        $coordinates = $this->coordinates;

        if ($coordinates->count() < 3) {
            return 0;
        }

        $area = 0;
        $n = $coordinates->count();

        for ($i = 0; $i < $n; $i++) {
            $j = ($i + 1) % $n;
            $area += $coordinates[$i]->latitude * $coordinates[$j]->longitude;
            $area -= $coordinates[$j]->latitude * $coordinates[$i]->longitude;
        }

        $area = abs($area / 2);

        // Convert to square meters (approximate)
        $latCenter = $coordinates->avg('latitude');
        $metersPerDegreeLng = 111319.9 * cos($latCenter * pi() / 180);
        $metersPerDegreeLat = 111319.9;

        return $area * $metersPerDegreeLat * $metersPerDegreeLng;
    }
}
