<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class PeninjauanCoordinate extends Model
{
    use HasFactory;

    protected $table = 'peninjauan_coordinates';

    protected $fillable = [
        'peninjauan_id',
        'point_number',
        'latitude',
        'longitude',
        'sequence'
    ];

    protected $casts = [
        'latitude' => 'decimal:8',
        'longitude' => 'decimal:8',
        'point_number' => 'integer',
        'sequence' => 'integer'
    ];

    // Relationships
    public function peninjauan()
    {
        return $this->belongsTo(Peninjauan::class, 'peninjauan_id');
    }

    // Methods
    public function toArray()
    {
        return [
            'point' => $this->point_number,
            'lat' => $this->latitude,
            'lng' => $this->longitude,
            'sequence' => $this->sequence
        ];
    }
}