<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

// 1. Model Peninjauan
class PeninjauanPeralihan extends Model
{
    use HasFactory;

    protected $table = 'peninjauan_peralihan';

    protected $fillable = [
        'peninjauan_id',
        'urutan',
        'pada_tahun',
        'dikuasai_oleh',
        'dialihkan',
        'luas'
    ];

    protected $casts = [
        'luas' => 'decimal:2',
        'pada_tahun' => 'integer',
        'urutan' => 'integer'
    ];

    // Relationships
    public function peninjauan()
    {
        return $this->belongsTo(Peninjauan::class, 'peninjauan_id');
    }
}