<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Wildside\Userstamps\Userstamps;
use Illuminate\Database\Eloquent\SoftDeletes;
class Resi extends Model
{
    use HasFactory, Userstamps,SoftDeletes;
    
    protected $guarded = [''];
    protected $table = 'resi';
    public static function genCode()
    {
        $tahun = date("Y");
        $bulan = date("m");
        $prefix = "RS".substr($tahun, 2, 2).$bulan;
        $lastCode = self::whereMonth('created_at', $bulan)->whereYear('created_at', $tahun)->orderBy("id","desc")->first();
        // dd($lastCode);
        $lastCode = $lastCode ? substr($lastCode->code, 6, 5) : 0;
        return $prefix.str_pad(($lastCode+1), 5, 0, STR_PAD_LEFT);
    }

    public function regisKlaim(){
        return $this->belongsTo(DataNasabah::class,'id_registrasi_klaim');
    }

}
