<?php
// config/activity-log.php - Configuration file

return [
    /*
    |--------------------------------------------------------------------------
    | Default Settings
    |--------------------------------------------------------------------------
    */
    'enabled' => env('ACTIVITY_LOG_ENABLED', true),
    
    /*
    |--------------------------------------------------------------------------
    | Database Settings
    |--------------------------------------------------------------------------
    */
    'database' => [
        'connection' => env('ACTIVITY_LOG_DB_CONNECTION', null),
        'table_name' => env('ACTIVITY_LOG_TABLE_NAME', 'activity_logs'),
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Auto Clean Up
    |--------------------------------------------------------------------------
    */
    'delete_records_older_than_days' => 90,
    'cleanup_enabled' => true,
    
    /*
    |--------------------------------------------------------------------------
    | Skip Routes
    |--------------------------------------------------------------------------
    */
    'skip_routes' => [
        'activity-logs.*',
        'api/*',
        '_debugbar/*',
        'assets/*',
        'css/*',
        'js/*',
        'images/*',
        'storage/*',
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Skip Methods
    |--------------------------------------------------------------------------
    */
    'skip_methods' => [
        'HEAD',
        'OPTIONS',
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Activity Mapping
    |--------------------------------------------------------------------------
    */
    'activity_mapping' => [
        // Authentication
        'login' => [
            'activity' => 'Login',
            'module' => 'Authentication',
        ],
        'logout' => [
            'activity' => 'Logout', 
            'module' => 'Authentication',
        ],
        
        // SKPT Management
        'skpt.store' => [
            'activity' => 'Create SKPT',
            'module' => 'SKPT',
        ],
        'skpt.update' => [
            'activity' => 'Edit SKPT',
            'module' => 'SKPT',
        ],
        'skpt.destroy' => [
            'activity' => 'Delete SKPT',
            'module' => 'SKPT',
        ],
        'skpt.print' => [
            'activity' => 'Print Document',
            'module' => 'SKPT',
        ],
        
        // Document Management
        'documents.store' => [
            'activity' => 'Upload Document',
            'module' => 'Document Management',
        ],
        'documents.approve' => [
            'activity' => 'Approve Document',
            'module' => 'Approval',
        ],
        
        // User Management
        'users.store' => [
            'activity' => 'Create User',
            'module' => 'User Management',
        ],
        'users.update' => [
            'activity' => 'Update User',
            'module' => 'User Management',
        ],
        'users.destroy' => [
            'activity' => 'Delete User',
            'module' => 'User Management',
        ],
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Status Colors for UI
    |--------------------------------------------------------------------------
    */
    'status_colors' => [
        'Berhasil' => '#10b981',
        'Gagal' => '#ef4444', 
        'Peringatan' => '#f59e0b',
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Activity Icons
    |--------------------------------------------------------------------------
    */
    'activity_icons' => [
        'Login' => '🔐',
        'Logout' => '🚪',
        'Create SKPT' => '📝',
        'Edit SKPT' => '✏️',
        'Delete SKPT' => '🗑️',
        'Delete Data' => '🗑️',
        'Approve Document' => '✅',
        'Upload Document' => '📤',
        'Print Document' => '🖨️',
        'Create User' => '👤',
        'Update User' => '👤',
        'Delete User' => '👤',
        'Failed Login' => '❌',
        'default' => '📋',
    ],
];