<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('skpt_applications', function (Blueprint $table) {
            $table->id();
            
            // Data Pemohon
            $table->string('nik', 20)->unique();
            $table->date('tgl_penerimaan')->nullable();
            $table->date('tgl_permohonan')->nullable();
            $table->string('nama_pemohon')->nullable();
            $table->string('tempat_lahir')->nullable();
            $table->date('tanggal_lahir')->nullable();
            $table->string('no_ktp', 20)->nullable();
            $table->string('email')->nullable()->nullable();
            $table->string('telepon', 15)->nullable()->nullable();
            $table->string('pekerjaan')->nullable();
            
            // Alamat Pemohon (3 input: RT, RW, Kode Pos)
            $table->string('alamat_rt', 3)->nullable();
            $table->string('alamat_rw', 3)->nullable();
            $table->string('alamat_kode_pos', 5)->nullable();
            
            // Letak Tanah
            $table->text('letak_tanah')->nullable();
            
            // Alamat Tanah (3 input: RT, RW, Kode Pos)
            $table->string('tanah_rt', 3)->nullable();
            $table->string('tanah_rw', 3)->nullable();
            $table->string('tanah_kode_pos', 5)->nullable();
            
            // Detail Tanah
            $table->string('dusun')->nullable();
            $table->string('kelurahan_kampung')->nullable();
            $table->enum('peruntukan', ['Perkebunan', 'Pertanian', 'Perumahan', 'Industri', 'Lainnya'])->nullable();
            $table->decimal('luas', 10, 2)->nullable(); // dalam m2
            $table->enum('penanda_tanah', ['Batas Pagar', 'Batas Alam', 'Batas Bangunan', 'Lainnya'])->nullable();
            $table->enum('utara', ['Tanah Kosong', 'Rumah', 'Kebun', 'Jalan', 'Sungai', 'Lainnya'])->nullable();
            $table->enum('timur', ['Tanah Kosong', 'Rumah', 'Kebun', 'Jalan', 'Sungai', 'Lainnya'])->nullable();
            $table->enum('selatan', ['Jalan Kampung', 'Rumah', 'Kebun', 'Tanah Kosong', 'Sungai', 'Lainnya'])->nullable();
            $table->enum('barat', ['Tanah Hasan', 'Rumah', 'Kebun', 'Tanah Kosong', 'Sungai', 'Lainnya'])->nullable();
            
            // Status
            $table->enum('status_kelengkapan_dokumen', ['LENGKAP', 'BELUM LENGKAP'])->default('BELUM LENGKAP')->nullable();
            $table->enum('status_permohonan', ['BELUM SELESAI', 'SELESAI'])->default('BELUM SELESAI')->nullable();
            
            // Timestamps
            $table->timestamps();
            
            // Indexes
            $table->index('nik');
            $table->index('status_permohonan');
            $table->index('status_kelengkapan_dokumen');
            $table->index(['tgl_penerimaan', 'status_permohonan']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('skpt_applications');
    }
};
