<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('skpt_documents', function (Blueprint $table) {
             $table->id();
            $table->foreignId('skpt_application_id')->constrained('skpt_applications')->onDelete('cascade');
            $table->string('document_type'); // Jenis dokumen
            $table->string('document_name'); // Nama file asli
            $table->string('file_path')->nullable(); // Path file
            $table->string('file_size')->nullable(); // Ukuran file
            $table->string('file_extension', 10)->nullable(); // Ekstensi file
            $table->boolean('is_required')->default(true); // Wajib atau opsional
            $table->boolean('is_uploaded')->default(false); // Status upload
            $table->boolean('is_additional')->default(false); // Dokumen tambahan atau tidak
            
            // Status verifikasi untuk setiap dokumen
            $table->enum('verification_status', ['PENDING', 'SUDAH', 'DITOLAK'])->default('PENDING');
            $table->text('verification_notes')->nullable(); // Catatan verifikasi
            $table->timestamp('verified_at')->nullable(); // Waktu verifikasi
            $table->unsignedBigInteger('verified_by')->nullable(); // ID user yang verifikasi
            
            $table->timestamps();
            
            // Index dengan nama yang lebih pendek
            $table->index('skpt_application_id', 'skpt_docs_app_id_idx');
            $table->index('document_type', 'skpt_docs_type_idx');
            $table->index('verification_status', 'skpt_docs_verify_status_idx');
            $table->index('is_required', 'skpt_docs_required_idx');
            $table->index('is_additional', 'skpt_docs_additional_idx');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('skpt_documents');
    }
};
