<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('skpt_additional_documents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('skpt_application_id')->constrained('skpt_applications')->onDelete('cascade');
            
            // Data dokumen tambahan
            $table->string('document_name'); // Nama dokumen yang diinput user
            $table->text('document_description')->nullable(); // Deskripsi dokumen
            $table->string('file_path'); // Path file yang diupload
            $table->string('original_filename'); // Nama file asli
            $table->string('file_size'); // Ukuran file
            $table->string('file_extension', 10); // Ekstensi file
            
            // Status verifikasi
            $table->enum('verification_status', ['PENDING', 'SUDAH', 'DITOLAK'])->default('PENDING');
            $table->text('verification_notes')->nullable(); // Catatan dari verifikator
            $table->timestamp('verified_at')->nullable(); // Waktu verifikasi
            $table->unsignedBigInteger('verified_by')->nullable(); // ID user yang verifikasi
            
            // Status aktif (untuk soft delete)
            $table->boolean('is_active')->default(true);
            
            $table->timestamps();
            
            // Indexes dengan nama yang lebih pendek
            $table->index('skpt_application_id', 'skpt_add_docs_app_id_idx');
            $table->index('verification_status', 'skpt_add_docs_verify_status_idx');
            $table->index('is_active', 'skpt_add_docs_active_idx');
            $table->index(['skpt_application_id', 'verification_status'], 'skpt_add_docs_app_verify_idx');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('skpt_additional_documents');
    }
};