<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('skpt_applications', function (Blueprint $table) {
             $table->string('no_registrasi', 15)->unique()->after('id');
            
            // Tambah index untuk no_registrasi
            $table->index('no_registrasi', 'skpt_apps_no_reg_idx');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('skpt_applications', function (Blueprint $table) {
            $table->dropIndex('skpt_apps_no_reg_idx');
            $table->dropColumn('no_registrasi');
        });
    }
};
