<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('peninjauan', function (Blueprint $table) {
           $table->id();
            $table->string('type_permohonan')->default('SKPT'); // SKPT, Sertifikat, Lainnya
            
            // BA Kesaksian
            $table->string('nomor_ba_kesaksian')->nullable();
            $table->date('ba_tanggal')->nullable();
            
            // Saksi 1
            $table->string('saksi1_nama')->nullable();
            $table->string('saksi1_ttl')->nullable();
            $table->string('saksi1_pekerjaan')->nullable();
            $table->text('saksi1_alamat')->nullable();
            
            // Saksi 2
            $table->string('saksi2_nama')->nullable();
            $table->string('saksi2_ttl')->nullable();
            $table->string('saksi2_pekerjaan')->nullable();
            $table->text('saksi2_alamat')->nullable();
            
            // Data Lokasi (Peralihan)
            $table->string('jalan_gg_blok')->nullable();
            $table->string('rt', 5)->nullable();
            $table->string('rw', 5)->nullable();
            $table->string('kampung_kelurahan')->nullable();
            $table->string('kecamatan')->nullable();
            
            // Batas
            $table->string('batas_utara')->nullable();
            $table->string('batas_timur')->nullable();
            $table->string('batas_selatan')->nullable();
            $table->string('batas_barat')->nullable();
            $table->decimal('luas', 10, 2)->nullable();
            
            // Hak Penguasaan
            $table->string('tanah_negara')->nullable();
            $table->string('sppt')->nullable();
            
            // Data Pemilik
            $table->string('nama_pemilik')->nullable();
            $table->year('dikuasai_sejak')->nullable();
            $table->string('dikuasai_oleh')->nullable();
            
            // BA Kesepakatan Batas
            $table->string('nomor_ba_kesepakatan')->nullable();
            $table->date('tanggal_ba_kesepakatan')->nullable();
            $table->string('diumumkan_di')->nullable();
            $table->string('diumumkan_dan')->nullable();
            $table->string('tanda_batas')->nullable();
            $table->enum('penguasaan_tanah', ['fisik', 'yuridis', 'fisik_yuridis'])->nullable();
            
            // Saksi Batas
            $table->string('saksi_utara_nama')->nullable();
            $table->text('saksi_utara_alamat')->nullable();
            $table->string('saksi_timur_nama')->nullable();
            $table->text('saksi_timur_alamat')->nullable();
            $table->string('saksi_selatan_nama')->nullable();
            $table->text('saksi_selatan_alamat')->nullable();
            $table->string('saksi_barat_nama')->nullable();
            $table->text('saksi_barat_alamat')->nullable();
            $table->string('saksi_rt_nama')->nullable();
            $table->text('saksi_rt_alamat')->nullable();
            $table->string('saksi_kur_nama')->nullable();
            $table->text('saksi_kur_alamat')->nullable();
            $table->string('juru_ukur_nama')->nullable();
            $table->text('juru_ukur_alamat')->nullable();
            
            // BA Penelitian
            $table->string('nomor_ba_penelitian')->nullable();
            $table->date('bulan_tahun_penelitian')->nullable();
            $table->string('penguasaan_tanah_detail')->nullable();
            $table->enum('riwayat_perolehan', ['beli', 'waris', 'hibah', 'tukar', 'garap', 'lainnya'])->nullable();
            $table->text('data_yuridis')->nullable();
            $table->text('data_pendukung')->nullable();
            
            // IMB dan SPPT
            $table->date('imb_tanggal')->nullable();
            $table->string('no_imb')->nullable();
            $table->year('sppt_pbb_tahun')->nullable();
            
            // BA Pengukuran
            $table->string('nomor_ba_pengukuran')->nullable();
            $table->date('tanggal_pengukuran')->nullable();
            $table->string('surat_tugas_nomor')->nullable();
            $table->date('surat_tugas_tanggal')->nullable();
            $table->string('petugas_ukur')->nullable();
            $table->string('nomor_ba_persetujuan')->nullable();
            $table->date('tanggal_permohonan')->nullable();
            $table->decimal('ukuran_patok', 5, 2)->nullable();
            $table->string('sistem_koordinat')->default('UTM');
            $table->string('cm_x')->nullable();
            $table->date('tanggal_pengukuran_koordinat')->nullable();
            
            // Kesimpulan
            $table->enum('status_penguasaan_kesimpulan', ['fisik', 'yuridis', 'fisik_yuridis', 'sengketa', 'tidak_jelas'])->nullable();
            $table->decimal('luas_terukur_kesimpulan', 10, 2)->nullable();
            $table->decimal('luas_surat_kesimpulan', 10, 2)->nullable();
            $table->text('kesimpulan_status')->nullable();
            
            // Rekomendasi
            $table->boolean('rekomendasi_skpt')->default(false);
            $table->boolean('rekomendasi_sertifikat')->default(false);
            $table->boolean('rekomendasi_mediasi')->default(false);
            $table->boolean('rekomendasi_verifikasi')->default(false);
            $table->boolean('rekomendasi_tolak')->default(false);
            $table->text('catatan_rekomendasi')->nullable();
            
            // Data Petugas
            $table->string('petugas1_nama')->nullable();
            $table->string('petugas1_nip')->nullable();
            $table->string('petugas1_jabatan')->nullable();
            $table->string('petugas2_nama')->nullable();
            $table->string('petugas2_nip')->nullable();
            $table->string('petugas2_jabatan')->nullable();
            
            // Pengesahan
            $table->string('tempat_pengesahan')->nullable();
            $table->date('tanggal_pengesahan')->nullable();
            $table->string('mengetahui_nama')->nullable();
            $table->string('mengetahui_nip')->nullable();
            $table->string('mengetahui_jabatan')->nullable();
            
            // Status
            $table->enum('status', ['draft', 'submitted', 'verified', 'completed', 'rejected'])->default('draft');
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('verified_by')->nullable();
            $table->timestamp('verified_at')->nullable();
            $table->text('verification_notes')->nullable();
            
            $table->timestamps();
            $table->softDeletes();
            
            // Indexes
            $table->index('nomor_ba_kesaksian');
            $table->index('status');
            $table->index('created_by');
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('peninjauan');
    }
};
