<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('kecamatan', function (Blueprint $table) {
            $table->id();
            $table->string('kode_kecamatan')->unique(); // Kode Kecamatan
            $table->string('nama_kecamatan'); // Nama Kecamatan
            $table->string('alamat_kantor_kecamatan'); // Alamat Lengkap Kantor Kecamatan
            $table->string('kode_pos'); // Kode Pos
            $table->string('nama_camat'); // Nama Camat
            $table->string('nip')->nullable(); // NIP (bisa null jika belum diisi)
            $table->string('golongan')->nullable(); // Golongan
            $table->string('pangkat')->nullable(); // Pangkat
            $table->float('luas_wilayah', 8, 2)->default(0.00); // Luas Wilayah (km²)
            $table->integer('jumlah_desa')->default(0); // Jumlah Desa
            $table->enum('status', ['Aktif', 'Nonaktif'])->default('Aktif'); // Status
            $table->string('warna')->default('#000000'); // Warna
            $table->json('geojson')->nullable(); // GeoJSON (file opsional)
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('kecamatan');
    }
};
