<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('rtrw', function (Blueprint $table) {
            $table->unsignedBigInteger('kampung_id')->nullable()->after('nama_rtrw');
            $table->unsignedBigInteger('kecamatan_id')->nullable()->after('kampung_id');
            $table->foreign('kampung_id')->references('id')->on('kampung')->onDelete('cascade');
            $table->foreign('kecamatan_id')->references('id')->on('kecamatan')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('rtrw', function (Blueprint $table) {
            $table->dropForeign(['kampung_id']);
            $table->dropForeign(['kecamatan_id']);
            $table->dropColumn(['kampung_id', 'kecamatan_id']);
        });
    }
};
