<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sp_sipt', function (Blueprint $table) {
            $table->string('ketua_rt')->nullable()->after('nomor_surat');
            $table->string('nama_rt')->nullable()->after('ketua_rt');
            $table->unsignedBigInteger('kampung_id')->nullable()->after('nama_rt');
            $table->string('lokasi_tanah_rt')->nullable()->after('kampung_id');
            $table->string('kampung')->nullable()->after('lokasi_tanah_rt');
            $table->unsignedBigInteger('kecamatan_id')->nullable()->after('kampung');
            $table->string('nomor_tanggal_surat_penguasaan_tanah')->nullable()->after('kecamatan_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sp_sipt', function (Blueprint $table) {
            $table->dropColumn([
                'ketua_rt',
                'nama_rt',
                'kampung_id',
                'lokasi_tanah_rt',
                'kampung',
                'kecamatan_id',
                'nomor_tanggal_surat_penguasaan_tanah',
            ]);
        });
    }
};
