<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::table('sp_sipt', function (Blueprint $table) {
            $table->string('peruntukan_bidang_tanah')->nullable()->after('polygon_bounds');
            $table->decimal('uang_ganti_kerugian', 20, 2)->nullable()->after('peruntukan_bidang_tanah');
           
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sp_sipt', function (Blueprint $table) {
            $table->dropColumn([
                'peruntukan_bidang_tanah',
                'uang_ganti_kerugian',
              
            ]);
        });
    }
};
