<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Jalankan migrasi perubahan enum status.
     */
    public function up(): void
    {
        // Mapping data lama -> baru
        DB::statement("UPDATE sp_sipt SET status = 'belum_selesai' WHERE status IN ('submitted','in_review')");
        DB::statement("UPDATE sp_sipt SET status = 'selesai' WHERE status IN ('approved','rejected')");

        // Ubah definisi kolom enum
        DB::statement("ALTER TABLE sp_sipt MODIFY COLUMN status
            ENUM('draft', 'belum selesai', 'selesai')
            NOT NULL DEFAULT 'draft' COMMENT 'Status pengajuan'");
    }

    /**
     * Rollback migrasi (balik ke enum lama).
     */
    public function down(): void
    {
        // Mapping data baru -> lama (default ke 'draft' kalau tidak cocok)
        DB::statement("UPDATE sp_sipt SET status = 'submitted' WHERE status = 'belum selesai'");
        DB::statement("UPDATE sp_sipt SET status = 'approved' WHERE status = 'selesai'");

        // Balik ke enum lama
        DB::statement("ALTER TABLE sp_sipt MODIFY COLUMN status
            ENUM('draft', 'submitted', 'in_review', 'approved', 'rejected')
            NOT NULL DEFAULT 'draft' COMMENT 'Status pengajuan'");
    }
};
