<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('berita_acara_peninjauan', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('peninjauan_id');
            $table->string('nomor_berita_acara')->nullable();
            $table->string('type')->nullable();
            $table->enum('status_verifikasi', ['sesuai', 'tidak sesuai'])->nullable();
            $table->unsignedBigInteger('verifikator_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('berita_acara_peninjauan');
    }
};
