<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('utm_coordinates', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('peninjauan_id');
            $table->integer('point_number');
            $table->decimal('easting', 12, 2);
            $table->decimal('northing', 12, 2);
            $table->integer('sequence')->default(0);
            $table->timestamps();

            $table->foreign('peninjauan_id')->references('id')->on('peninjauan')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('utm_coordinates');
    }
};
