<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('sp_sipt_coordinates', function (Blueprint $table) {
            $table->decimal('easting', 12, 2)->nullable()->after('longitude');
            $table->decimal('northing', 12, 2)->nullable()->after('easting');
            $table->string('utm_zone', 10)->nullable()->after('northing');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('sp_sipt_coordinates', function (Blueprint $table) {
            $table->dropColumn(['easting', 'northing', 'utm_zone']);
        });
    }
};
