<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;

class RoleAssignmentSeeder extends Seeder
{
    public function run()
    {
        // Create roles based on existing database
        $roles = [
            [
                'name' => 'superadmin',
                'display_name' => 'Super Administrator',
                'description' => 'Full system access with all permissions',
                'is_active' => true
            ],
            [
                'name' => 'supervisor',
                'display_name' => 'Supervisor',
                'description' => 'Kepala Dinas',
                'is_active' => true
            ],
            [
                'name' => 'staff',
                'display_name' => 'Staff',
                'description' => 'Front desk staff handling data',
                'is_active' => true
            ],
            [
                'name' => 'administrator',
                'display_name' => 'Admin',
                'description' => 'Administrative staff with access to master data and basic operations',
                'is_active' => true
            ],
            [
                'name' => 'guest',
                'display_name' => 'Guest',
                'description' => '',
                'is_active' => true
            ]
        ];

        // Create roles
        foreach ($roles as $role) {
            Role::create($role);
        }

        // Define role permissions based on your existing database
        $rolePermissions = [
            'superadmin' => [
                // All permissions - SuperAdmin has full access
                'view_dashboard', 'view_reports', 'view_revenue_reports', 'print_reports',
                'view_users', 'create_users', 'edit_users', 'delete_users', 'manage_roles',
               
                'system_settings', 'clear_cache',
                'view_skpt', 'create_skpt', 'edit_skpt', 'delete_skpt', 'verify_skpt_documents', 'approve_skpt',
                'view_peninjauan', 'create_peninjauan', 'edit_peninjauan', 'delete_peninjauan', 'verify_peninjauan',
                'view_gis', 'manage_kecamatan', 'manage_kampung', 'manage_rtrw', 'upload_geojson',
                'view_activity_logs', 'export_activity_logs', 'clear_activity_logs'
            ],
            
            'manager' => [
                // Manager permissions based on existing database
                'view_dashboard', 'view_reports', 'view_revenue_reports', 'print_reports',
                'view_users', 'create_users', 'edit_users',
                'view_guests', 'create_guests', 'edit_guests', 'delete_guests',
                'view_bookings', 'create_bookings', 'edit_bookings', 'cancel_bookings',
                'view_checkins', 'process_checkins', 'view_checkouts', 'process_checkouts',
                'view_rooms', 'view_room_types',
                'view_services', 'view_service_categories', 'view_booking_services',
                'view_housekeeping', 'create_housekeeping', 'assign_housekeeping',
                'view_invoices', 'create_invoices', 'mark_invoice_paid', 'print_invoices', 'download_invoices', 'view_pengeluaran',
                'view_calendar', 'check_availability',
                'view_skpt', 'create_skpt', 'edit_skpt', 'verify_skpt_documents', 'approve_skpt',
                'view_peninjauan', 'create_peninjauan', 'edit_peninjauan', 'verify_peninjauan',
                'view_gis', 'manage_kecamatan', 'manage_kampung', 'manage_rtrw',
                'view_activity_logs', 'export_activity_logs'
            ],
            
            'resepsionis' => [
                // Receptionist permissions
                'view_dashboard',
                'view_guests', 'create_guests', 'edit_guests',
                'view_bookings', 'create_bookings', 'edit_bookings',
                'view_checkins', 'process_checkins', 'quick_checkin',
                'view_checkouts', 'process_checkouts', 'quick_checkout',
                'view_rooms', 'view_room_types',
                'view_services', 'view_booking_services', 'create_booking_services',
                'view_invoices', 'create_invoices', 'print_invoices',
                'view_calendar', 'check_availability',
                'view_skpt', 'create_skpt'
            ],
            
            'housekeeping' => [
                // Housekeeping staff permissions
                'view_dashboard',
                'view_housekeeping', 'edit_housekeeping', 'update_housekeeping_status', 'view_housekeeping_notifications',
                'view_rooms'
            ],
            
            'admin' => [
                // Admin permissions
                'view_dashboard',
                'view_guests', 'create_guests', 'edit_guests',
                'view_bookings', 'create_bookings', 'edit_bookings',
                'view_rooms', 'create_rooms', 'edit_rooms', 'view_room_types', 'manage_room_types',
                'view_services', 'create_services', 'edit_services', 'view_service_categories', 'manage_service_categories',
                'view_booking_services', 'create_booking_services',
                'view_housekeeping', 'create_housekeeping',
                'view_invoices',
                'view_calendar', 'check_availability',
                'view_skpt', 'create_skpt', 'edit_skpt',
                'view_peninjauan', 'create_peninjauan', 'edit_peninjauan',
                'view_gis', 'manage_kecamatan', 'manage_kampung', 'manage_rtrw', 'upload_geojson'
            ]
        ];

        // Assign permissions to roles
        foreach ($rolePermissions as $roleName => $permissions) {
            $role = Role::where('name', $roleName)->first();
            if ($role) {
                foreach ($permissions as $permissionName) {
                    $permission = Permission::where('name', $permissionName)->first();
                    if ($permission) {
                        $role->givePermissionTo($permission);
                    }
                }
                echo "Permissions assigned to role: {$roleName}\n";
            }
        }

        // Assign roles to existing users based on your database
        $userRoleAssignments = [
            1 => 'superadmin',  // superadmin user
            6 => 'housekeeping', // housekeeping user
            7 => 'manager'      // manager_hotel user
        ];

        foreach ($userRoleAssignments as $userId => $roleName) {
            $user = User::find($userId);
            $role = Role::where('name', $roleName)->first();
            
            if ($user && $role) {
                $user->assignRole($role);
                $user->update(['primary_role_id' => $role->id]);
                echo "Role {$roleName} assigned to user: {$user->name}\n";
            }
        }

        echo "Role assignments completed successfully!\n";
    }
}