<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\SKPTApplication;
use App\Models\SKPTDocument;

class SKPTDocumentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Template dokumen wajib dan opsional berdasarkan gambar
       $documentTypes = [
            // Dokumen Wajib
            [
                'document_type' => 'photo_copy_ktp',
                'document_name' => 'Photo Copy KTP',
                'is_required' => true,
                'is_additional' => false,
            ],
            [
                'document_type' => 'photo_copy_kk',
                'document_name' => 'Photo Copy KK (Kartu Keluarga)',
                'is_required' => true,
                'is_additional' => false,
            ],
            [
                'document_type' => 'photo_copy_ktp_saksi_batas',
                'document_name' => 'Photo Copy KTP Saksi Batas',
                'is_required' => true,
                'is_additional' => false,
            ],
            [
                'document_type' => 'surat_pengantar_rt',
                'document_name' => 'Surat Pengantar dari RT',
                'is_required' => true,
                'is_additional' => false,
            ],
            [
                'document_type' => 'surat_pengantar_kepala_kampung',
                'document_name' => 'Surat Pengantar dari Kepala Kampung',
                'is_required' => true,
                'is_additional' => false,
            ],
            [
                'document_type' => 'copy_surat_riwayat',
                'document_name' => 'Copy Surat Riwayat Penguasaan Fisik Bidang Tanah',
                'is_required' => true,
                'is_additional' => false,
            ],

            // Dokumen Opsional
            [
                'document_type' => 'surat_keterangan',
                'document_name' => 'Surat Keterangan Kematian/Pembagian Waris',
                'is_required' => false,
                'is_additional' => false,
            ],
            [
                'document_type' => 'sppt_pbb',
                'document_name' => 'SPPT PBB',
                'is_required' => false,
                'is_additional' => false,
            ],
            [
                'document_type' => 'surat_permohonan',
                'document_name' => 'Surat Permohonan SKPT (sudah ditandatangani)',
                'is_required' => false,
                'is_additional' => false,
            ],
            [
                'document_type' => 'foto_bukti_1',
                'document_name' => 'Foto copy bukti yuridis penguasaan tanah negara hal-1',
                'is_required' => false,
                'is_additional' => true,
            ],
            [
                'document_type' => 'foto_bukti_2',
                'document_name' => 'Foto copy bukti yuridis penguasaan tanah negara hal-2',
                'is_required' => false,
                'is_additional' => true,
            ],
        ];


        // Seed dokumen untuk aplikasi SKPT yang ada
        $applications = SKPTApplication::all();
        
        foreach ($applications as $application) {
            foreach ($documentTypes as $docType) {
                SKPTDocument::create([
                    'skpt_application_id' => $application->id,
                    'document_type' => $docType['document_type'],
                    'document_name' => $docType['document_name'],
                    'is_required' => $docType['is_required'],
                    'is_additional' => $docType['is_additional'],
                    'verification_status' => 'PENDING',
                    'is_uploaded' => false,
                ]);
            }
        }

        $this->command->info('Document templates seeded for all SKPT applications.');
    }

    /**
     * Method untuk membuat template dokumen untuk aplikasi baru
     * 
     * @param int $applicationId
     * @return void
     */
    public static function createDocumentTemplatesForApplication($applicationId)
    {
        $documentTypes = [
            // Dokumen Wajib
            [
                'document_type' => 'photo_copy_ktp',
                'document_name' => 'Photo Copy KTP',
                'is_required' => true,
                'is_additional' => false,
            ],
            [
                'document_type' => 'photo_copy_kk',
                'document_name' => 'Photo Copy KK (Kartu Keluarga)',
                'is_required' => true,
                'is_additional' => false,
            ],
            [
                'document_type' => 'photo_copy_ktp_saksi_batas',
                'document_name' => 'Photo Copy KTP Saksi Batas',
                'is_required' => true,
                'is_additional' => false,
            ],
            [
                'document_type' => 'surat_pengantar_rt',
                'document_name' => 'Surat Pengantar dari RT',
                'is_required' => true,
                'is_additional' => false,
            ],
            [
                'document_type' => 'surat_pengantar_kepala_kampung',
                'document_name' => 'Surat Pengantar dari Kepala Kampung',
                'is_required' => true,
                'is_additional' => false,
            ],
            [
                'document_type' => 'copy_surat_riwayat',
                'document_name' => 'Copy Surat Riwayat Penguasaan Fisik Bidang Tanah',
                'is_required' => true,
                'is_additional' => false,
            ],

            // Dokumen Opsional
            [
                'document_type' => 'surat_keterangan',
                'document_name' => 'Surat Keterangan Kematian/Pembagian Waris',
                'is_required' => false,
                'is_additional' => false,
            ],
            [
                'document_type' => 'sppt_pbb',
                'document_name' => 'SPPT PBB',
                'is_required' => false,
                'is_additional' => false,
            ],
            [
                'document_type' => 'surat_permohonan',
                'document_name' => 'Surat Permohonan SKPT (sudah ditandatangani)',
                'is_required' => false,
                'is_additional' => false,
            ],
            [
                'document_type' => 'foto_bukti_1',
                'document_name' => 'Foto copy bukti yuridis penguasaan tanah negara hal-1',
                'is_required' => false,
                'is_additional' => true,
            ],
            [
                'document_type' => 'foto_bukti_2',
                'document_name' => 'Foto copy bukti yuridis penguasaan tanah negara hal-2',
                'is_required' => false,
                'is_additional' => true,
            ],
        ];


        foreach ($documentTypes as $docType) {
            SKPTDocument::create([
                'skpt_application_id' => $applicationId,
                'document_type' => $docType['document_type'],
                'document_name' => $docType['document_name'],
                'is_required' => $docType['is_required'],
                'is_additional' => $docType['is_additional'],
                'verification_status' => 'PENDING',
                'is_uploaded' => false,
            ]);
        }
    }
}