<style>
/* Active sidebar item styling */
.sidebar .nav-item.active .nav-link {
    color: #fff !important;
    background-color: rgba(255, 255, 255, 0.1);
    border-radius: 0.35rem;
}

.sidebar .nav-item.active .nav-link i {
    color: #fff !important;
}

/* Active collapse item styling */
.sidebar .collapse-item.active {
    color: #5a5c69 !important;
    background-color: #f8f9fc;
    border-radius: 0.25rem;
    font-weight: 600;
}

/* Sidebar card styling */
.sidebar-card {
    margin: 1rem;
}

.sidebar-card .card {
    background: rgba(255, 255, 255, 0.1);
    border: none;
}

.sidebar-card .card-body {
    padding: 1rem 0.75rem;
}

.sidebar-card .card-title {
    color: rgba(255, 255, 255, 0.9);
    font-size: 0.9rem;
}

.sidebar-card .card-text {
    color: rgba(255, 255, 255, 0.7);
    font-size: 0.75rem;
}

/* Collapse header styling */
.collapse-header {
    color: #858796;
    font-size: 0.75rem;
    font-weight: 800;
    text-transform: uppercase;
    letter-spacing: 0.05rem;
    margin-bottom: 0.5rem;
    margin-top: 0.5rem;
}

/* Icon spacing in collapse items */
.collapse-item i {
    width: 1rem;
    margin-right: 0.5rem;
    text-align: center;
}

/* Hover effects */
.sidebar .nav-item .nav-link:hover {
    color: #fff !important;
}

.sidebar .collapse-item:hover {
    background-color: #eaecf4;
    color: #5a5c69 !important;
}

/* Brand logo styling */
.sidebar-brand-logo {
    width: 40px;
    height: 40px;
    transition: transform 0.3s ease-in-out;
    border-radius: 8px;
    overflow: hidden;
    background: rgba(255, 255, 255, 0.9);
    padding: 2px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.sidebar-brand-logo img {
    width: 100%;
    height: 100%;
    object-fit: contain;
    border-radius: 6px;
}

.sidebar-brand:hover .sidebar-brand-logo {
    transform: rotate(-5deg) scale(1.1);
}

/* Fallback icon styling */
.sidebar-brand-icon {
    transition: transform 0.3s ease-in-out;
    display: none;
}

.sidebar-brand:hover .sidebar-brand-icon {
    transform: rotate(-15deg) scale(1.1);
}

/* Brand text styling */
.sidebar-brand-text {
    font-weight: 700;
    font-size: 1.1rem;
    letter-spacing: 0.5px;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .sidebar-card {
        display: none !important;
    }
    
    .sidebar-brand-logo {
        width: 35px;
        height: 35px;
    }
    
    .sidebar-brand-text {
        font-size: 1rem;
    }
}

/* Pulse animation for active menu items */
@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.02); }
    100% { transform: scale(1); }
}

.nav-item.pulse {
    animation: pulse 0.3s ease-in-out;
}
</style>

<ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">

    <!-- Sidebar - Brand -->
    <a class="sidebar-brand d-flex align-items-center justify-content-center" href="{{ route('home') }}">
        <div class="sidebar-brand-logo">
            <img src="/images/Logo.jpg" alt="Melati Hotel Logo" onerror="this.style.display='none'; this.parentElement.nextElementSibling.style.display='block';">
        </div>
        <div class="sidebar-brand-icon rotate-n-15" style="display: none;">
            <i class="fas fa-hotel"></i>
        </div>
        <div class="sidebar-brand-text mx-3">MELATI HOTEL
            <sup></sup></div>
    </a>

    <!-- Divider -->
    <hr class="sidebar-divider my-0">

    <!-- Nav Item - Dashboard -->
    @permission('view_dashboard')
    <li class="nav-item {{ request()->routeIs(['home', 'dashboard']) ? 'active' : '' }}">
        <a class="nav-link" href="{{ route('home') }}">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            <span>Dashboard</span></a>
    </li>
    @endpermission
   
    <!-- Divider -->
    <hr class="sidebar-divider">

    <!-- Heading -->
    <div class="sidebar-heading">
        Menu Hotel
    </div>

    <!-- Front Office Menu (Resepsionis, Manager, Superadmin) -->
    @frontoffice
    <!-- Booking Management -->
    @permission('view_bookings')
    <li class="nav-item {{ request()->routeIs(['bookings.*', 'calendar.*', 'checkins.*', 'checkouts.*']) ? 'active' : '' }}">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseBooking"
            aria-expanded="{{ request()->routeIs(['bookings.*', 'calendar.*', 'checkins.*', 'checkouts.*']) ? 'true' : 'false' }}" 
            aria-controls="collapseBooking">
           <i class="fas fa-calendar-check"></i>
            <span>Front Office</span>
        </a>
        <div id="collapseBooking" class="collapse {{ request()->routeIs(['bookings.*', 'calendar.*', 'checkins.*', 'checkouts.*']) ? 'show' : '' }}" 
            aria-labelledby="headingBooking" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Booking & Reservasi:</h6>
                <a class="collapse-item {{ request()->routeIs('bookings.*') ? 'active' : '' }}" href="{{route('bookings.index')}}">
                    <i class="fas fa-book"></i> Daftar Booking
                </a>
                @permission('view_calendar')
                <a class="collapse-item {{ request()->routeIs('calendar.*') ? 'active' : '' }}" href="{{route('calendar.index')}}">
                    <i class="fas fa-calendar-alt"></i> Kalender
                </a>
                @endpermission
                
                <div class="collapse-divider"></div>
                <h6 class="collapse-header">Check-in & Check-out:</h6>
                @permission('view_checkins')
                <a class="collapse-item {{ request()->routeIs('checkins.*') ? 'active' : '' }}" href="{{route('checkins.index')}}">
                    <i class="fas fa-sign-in-alt"></i> Check-in
                </a>
                @endpermission
                @permission('view_checkouts')
                <a class="collapse-item {{ request()->routeIs('checkouts.*') ? 'active' : '' }}" href="{{route('checkouts.index')}}">
                    <i class="fas fa-sign-out-alt"></i> Check-out
                </a>
                @endpermission
            </div>
        </div>
    </li>
    @endpermission

    <!-- Guest Management -->
    @permission('view_guests')
    <li class="nav-item {{ request()->routeIs('guests.*') ? 'active' : '' }}">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseGuests"
            aria-expanded="{{ request()->routeIs('guests.*') ? 'true' : 'false' }}" aria-controls="collapseGuests">
            <i class="fas fa-users"></i>
            <span>Manajemen Tamu</span>
        </a>
        <div id="collapseGuests" class="collapse {{ request()->routeIs('guests.*') ? 'show' : '' }}" 
            aria-labelledby="headingGuests" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <a class="collapse-item {{ request()->routeIs('guests.index') ? 'active' : '' }}" href="{{route('guests.index')}}">
                    <i class="fas fa-user-friends"></i> Daftar Tamu
                </a>
                {{-- <a class="collapse-item" href="#">
                    <i class="fas fa-history"></i> Riwayat Tamu
                </a> --}}
            </div>
        </div>
    </li>
    @endpermission
    @endfrontoffice

    <!-- Service Management (Admin, Manager, Superadmin, Resepsionis) -->
    @anypermission('view_services', 'view_service_categories', 'view_booking_services')
    <li class="nav-item {{ request()->routeIs(['services.*', 'service-categories.*', 'booking-services.*']) ? 'active' : '' }}">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseServices"
            aria-expanded="{{ request()->routeIs(['services.*', 'service-categories.*', 'booking-services.*']) ? 'true' : 'false' }}" 
            aria-controls="collapseServices">
            <i class="fas fa-fw fa-concierge-bell"></i>
            <span>Layanan Hotel</span>
        </a>
        <div id="collapseServices" class="collapse {{ request()->routeIs(['services.*', 'service-categories.*', 'booking-services.*']) ? 'show' : '' }}" 
            aria-labelledby="headingServices" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                @anypermission('view_service_categories', 'view_services')
                <h6 class="collapse-header">Manajemen Layanan:</h6>
                @permission('view_service_categories')
                <a class="collapse-item {{ request()->routeIs('service-categories.*') ? 'active' : '' }}" 
                href="{{ route('service-categories.index') }}">
                    <i class="fas fa-list"></i> Kategori Layanan
                </a>
                @endpermission
                @permission('view_services')
                <a class="collapse-item {{ request()->routeIs('services.*') ? 'active' : '' }}" 
                href="{{ route('services.index') }}">
                    <i class="fas fa-concierge-bell"></i> Daftar Layanan
                </a>
                @endpermission
                @endanypermission
                
                @permission('view_booking_services')
                <div class="collapse-divider"></div>
                <h6 class="collapse-header">Service Bookings:</h6>
                <a class="collapse-item {{ request()->routeIs('booking-services.*') ? 'active' : '' }}" 
                href="{{ route('booking-services.index') }}">
                    <i class="fas fa-clipboard-list"></i> Service Bookings
                </a>
                @endpermission
            </div>
        </div>
    </li>
    @endanypermission

    <!-- Housekeeping Menu (All roles can view, but different access levels) -->
    @permission('view_housekeeping')
    <li class="nav-item {{ request()->routeIs('housekeeping.*') ? 'active' : '' }}">
        <a class="nav-link" href="{{route('housekeeping.index')}}">
            <i class="fas fa-broom"></i>
            <span>
               Housekeeping
            </span>
        </a>
    </li>
    @endpermission

    <!-- Master Data (Admin, Manager, Superadmin) -->
    @administrative
    @anypermission('view_rooms', 'view_room_types')
    <li class="nav-item {{ request()->routeIs(['ms-type-rooms.*', 'ms-rooms.*']) ? 'active' : '' }}">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseMasterData"
            aria-expanded="{{ request()->routeIs(['ms-type-rooms.*', 'ms-rooms.*']) ? 'true' : 'false' }}" 
            aria-controls="collapseMasterData">
            <i class="fas fa-server"></i>
            <span>Master Data</span>
        </a>
        <div id="collapseMasterData" class="collapse {{ request()->routeIs(['ms-type-rooms.*', 'ms-rooms.*']) ? 'show' : '' }}" 
            aria-labelledby="headingMasterData" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                @permission('view_room_types')
                <a class="collapse-item {{ request()->routeIs('ms-type-rooms.*') ? 'active' : '' }}" href="{{route('ms-type-rooms.index')}}">
                    <i class="fas fa-bed"></i> Tipe Kamar
                </a>
                @endpermission
                @permission('view_rooms')
                <a class="collapse-item {{ request()->routeIs('ms-rooms.*') ? 'active' : '' }}" href="{{route('ms-rooms.index')}}">
                    <i class="fas fa-door-open"></i> Kamar
                </a>
                @endpermission
            </div>
        </div>
    </li>
    @endanypermission
    @endadministrative

    <!-- Financial & Invoices (Manager, Superadmin, Resepsionis for invoices) -->
    @anypermission('view_invoices', 'view_revenue_reports')
    <li class="nav-item {{ request()->routeIs(['invoices.*', 'reports.revenue.*','pengeluaran.*']) ? 'active' : '' }}">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseFinance"
            aria-expanded="{{ request()->routeIs(['invoices.*', 'reports.revenue.*']) ? 'true' : 'false' }}" 
            aria-controls="collapseFinance">
           <i class="fas fa-file-invoice-dollar"></i>
            <span>Keuangan & Invoices</span>
        </a>
        <div id="collapseFinance" class="collapse {{ request()->routeIs(['invoices.*', 'reports.revenue.*','pengeluaran.*']) ? 'show' : '' }}" 
            aria-labelledby="headingFinance" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                @permission('view_invoices')
                <a class="collapse-item {{ request()->routeIs('invoices.*') ? 'active' : '' }}" href="{{route('invoices.index')}}">
                    <i class="fas fa-file-invoice"></i> Invoices
                </a>
                @endpermission
                @permission('view_revenue_reports')
                <a class="collapse-item {{ request()->routeIs('reports.revenue.*') ? 'active' : '' }}" href="{{ route('reports.revenue.index') }}">
                    <i class="fas fa-chart-line"></i> Laporan Pendapatan
                </a>
                @endpermission
                @permission('view_pengeluaran')
                <a class="collapse-item {{ request()->routeIs('pengeluaran.*') ? 'active' : '' }}" href="{{ route('pengeluaran.index') }}">
                    <i class="fas fa-money-bill-wave"></i> Pengeluaran Hotel
                </a>
                @endpermission
            </div>
        </div>
    </li>
    @endanypermission

    <!-- User & Role Management (Superadmin, Manager) -->
    @management
    <hr class="sidebar-divider">
    <div class="sidebar-heading">
        Administrasi
    </div>

    @anypermission('view_users', 'manage_roles')
    <li class="nav-item {{ request()->routeIs(['user.*', 'roles.*']) ? 'active' : '' }}">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseUserMgmt"
            aria-expanded="{{ request()->routeIs(['user.*', 'roles.*']) ? 'true' : 'false' }}" 
            aria-controls="collapseUserMgmt">
            <i class="fas fa-users-cog"></i>
            <span>Manajemen User</span>
        </a>
        <div id="collapseUserMgmt" class="collapse {{ request()->routeIs(['user.*', 'roles.*']) ? 'show' : '' }}" 
            aria-labelledby="headingUserMgmt" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                @permission('view_users')
                <a class="collapse-item {{ request()->routeIs('user.*') ? 'active' : '' }}" href="{{route('user.index')}}">
                    <i class="fas fa-users"></i> Daftar User
                </a>
                @endpermission
                @permission('manage_roles')
                <a class="collapse-item {{ request()->routeIs('roles.*') ? 'active' : '' }}" href="{{route('roles.index')}}">
                    <i class="fas fa-user-tag"></i> Roles & Permissions
                </a>
                @endpermission
            </div>
        </div>
    </li>
    @endanypermission

    <!-- System Settings (Superadmin only) -->
    {{-- @superadmin
    <li class="nav-item {{ request()->routeIs('system.*') ? 'active' : '' }}">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseSystem"
            aria-expanded="{{ request()->routeIs('system.*') ? 'true' : 'false' }}" 
            aria-controls="collapseSystem">
            <i class="fas fa-cogs"></i>
            <span>Pengaturan Sistem</span>
        </a>
        <div id="collapseSystem" class="collapse {{ request()->routeIs('system.*') ? 'show' : '' }}" 
            aria-labelledby="headingSystem" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <a class="collapse-item" href="#">
                    <i class="fas fa-database"></i> Backup Database
                </a>
                <a class="collapse-item" href="#">
                    <i class="fas fa-envelope"></i> Email Settings
                </a>
                <a class="collapse-item" href="#">
                    <i class="fas fa-globe"></i> General Settings
                </a>
                @permission('clear_cache')
                <a class="collapse-item" href="/clear-cache">
                    <i class="fas fa-sync"></i> Clear Cache
                </a>
                @endpermission
            </div>
        </div>
    </li>
    @endsuperadmin --}}
    @endmanagement

    <!-- User Profile -->
    <hr class="sidebar-divider d-none d-md-block">
    <div class="sidebar-heading">
        Akun
    </div>

    <li class="nav-item {{ request()->routeIs('user.profile') ? 'active' : '' }}">
        <a class="nav-link" href="{{ route('user.profile', auth()->user()) }}">
            <i class="fas fa-user-circle"></i>
            <span>Profil Saya</span>
        </a>
    </li>

    <!-- Logout -->
    <li class="nav-item">
        <a class="nav-link" href="#" data-toggle="modal" data-target="#logoutModal">
            <i class="fas fa-sign-out-alt"></i>
            <span>Logout</span>
        </a>
    </li>
    
    <!-- Divider -->
    <hr class="sidebar-divider d-none d-md-block">

    <!-- Sidebar Toggler -->
    <div class="text-center d-none d-md-inline">
        <button class="rounded-circle border-0" id="sidebarToggle"></button>
    </div>

    <!-- User Info Card (Optional) -->
    <div class="sidebar-card d-none d-lg-flex">
        <div class="card shadow mb-4">
            <div class="card-body text-center">
                <div class="user-avatar mb-2">
                    @if(auth()->user()->isSuperAdmin())
                        <div class="bg-danger rounded-circle d-flex align-items-center justify-content-center mx-auto" style="width: 40px; height: 40px;">
                            <i class="fas fa-crown text-white"></i>
                        </div>
                    @elseif(auth()->user()->isManager())
                        <div class="bg-warning rounded-circle d-flex align-items-center justify-content-center mx-auto" style="width: 40px; height: 40px;">
                            <i class="fas fa-user-tie text-white"></i>
                        </div>
                    @elseif(auth()->user()->isResepsionis())
                        <div class="bg-info rounded-circle d-flex align-items-center justify-content-center mx-auto" style="width: 40px; height: 40px;">
                            <i class="fas fa-concierge-bell text-white"></i>
                        </div>
                    @elseif(auth()->user()->isHousekeeping())
                        <div class="bg-success rounded-circle d-flex align-items-center justify-content-center mx-auto" style="width: 40px; height: 40px;">
                            <i class="fas fa-broom text-white"></i>
                        </div>
                    @else
                        <div class="bg-secondary rounded-circle d-flex align-items-center justify-content-center mx-auto" style="width: 40px; height: 40px;">
                            <i class="fas fa-user text-white"></i>
                        </div>
                    @endif
                </div>
                <h6 class="card-title text-dark mb-1">{{ auth()->user()->name }}</h6>
                <p class="card-text text-muted small mb-0">{{ auth()->user()->getPrimaryRoleDisplayName() }}</p>
            </div>
        </div>
    </div>

</ul>

<script>
$(document).ready(function() {
    // Auto-collapse other menus when one is opened
    $('.sidebar .nav-link[data-toggle="collapse"]').on('click', function() {
        const target = $(this).attr('data-target');
        $('.sidebar .collapse').not(target).collapse('hide');
    });

    // Smooth scrolling for sidebar links
    $('.sidebar .nav-link').on('click', function(e) {
        if ($(this).attr('href') !== '#' && !$(this).attr('data-toggle')) {
            // Add subtle animation
            $(this).closest('.nav-item').addClass('pulse');
            setTimeout(() => {
                $(this).closest('.nav-item').removeClass('pulse');
            }, 300);
        }
    });

    // Update active states based on current route
    const currentPath = window.location.pathname;
    
    // Remove all active classes first
    $('.sidebar .nav-item').removeClass('active');
    $('.sidebar .collapse-item').removeClass('active');
    
    // Add active class to matching routes
    $('.sidebar .collapse-item').each(function() {
        const href = $(this).attr('href');
        if (href && currentPath.includes(href.split('/').pop())) {
            $(this).addClass('active');
            $(this).closest('.collapse').addClass('show');
            $(this).closest('.nav-item').addClass('active');
        }
    });
});
</script>