@extends('admin-layouts.master')
<style>
.service-card {
    border: 2px solid #e3e6f0;
    transition: all 0.3s ease;
    cursor: pointer;
}

.service-card:hover {
    border-color: #4e73df;
    box-shadow: 0 0 15px rgba(78, 115, 223, 0.2);
}

.service-card.selected {
    border-color: #4e73df;
    background-color: #f8f9fc;
}

.quantity-input {
    border-top: 1px solid #e3e6f0;
    padding-top: 10px;
}

.nav-tabs .nav-link {
    border: 1px solid transparent;
    border-top-left-radius: 0.35rem;
    border-top-right-radius: 0.35rem;
}

.nav-tabs .nav-link.active {
    color: #4e73df;
    background-color: #fff;
    border-color: #dee2e6 #dee2e6 #fff;
}
</style>
@section('content')
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Tambah Booking Service</h1>
        <a href="{{ route('booking-services.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
            <i class="fas fa-arrow-left fa-sm text-white-50"></i> Kembali
        </a>
    </div>

    <!-- Form Card -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Form Booking Service</h6>
                </div>
                <div class="card-body">
                    <form id="bookingServiceForm" action="{{ route('booking-services.store') }}" method="POST">
                        @csrf
                        
                        <!-- Booking Selection -->
                        <div class="form-group">
                            <label for="booking_id">Pilih Booking <span class="text-danger">*</span></label>
                            <select class="form-control" id="booking_id" name="booking_id" required>
                                <option value="">Pilih Booking...</option>
                                @foreach($activeBookings as $activeBooking)
                                <option value="{{ $activeBooking->id }}" 
                                        {{ (request('booking_id') == $activeBooking->id || (isset($booking) && $booking->id == $activeBooking->id)) ? 'selected' : '' }}>
                                    #{{ $activeBooking->id }} - {{ $activeBooking->guest->name }} 
                                    (Check-in: {{ $activeBooking->check_in_date_formatted }})
                                </option>
                                @endforeach
                            </select>
                            @error('booking_id')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Service Date -->
                        <div class="form-group">
                            <label for="service_date">Tanggal Layanan <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="service_date" name="service_date" 
                                   value="{{ old('service_date', date('Y-m-d')) }}" required>
                            @error('service_date')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Services Section -->
                        <div class="form-group">
                            <label>Pilih Layanan <span class="text-danger">*</span></label>
                            <div class="card">
                                <div class="card-body">
                                    <!-- Service Categories Tabs -->
                                    <ul class="nav nav-tabs" id="serviceTabs" role="tablist">
                                        @foreach($services as $category => $categoryServices)
                                        <li class="nav-item" role="presentation">
                                            <a class="nav-link {{ $loop->first ? 'active' : '' }}" 
                                               id="{{ Str::slug($category) }}-tab" 
                                               data-toggle="tab" 
                                               href="#{{ Str::slug($category) }}" 
                                               role="tab">
                                                {{ $category }}
                                            </a>
                                        </li>
                                        @endforeach
                                    </ul>

                                    <!-- Service Categories Content -->
                                    <div class="tab-content mt-3" id="serviceTabsContent">
                                        @foreach($services as $category => $categoryServices)
                                        <div class="tab-pane fade {{ $loop->first ? 'show active' : '' }}" 
                                             id="{{ Str::slug($category) }}" 
                                             role="tabpanel">
                                            <div class="row">
                                                @foreach($categoryServices as $service)
                                                <div class="col-md-6 mb-3">
                                                    <div class="card service-card h-100" data-service-id="{{ $service->id }}">
                                                        <div class="card-body">
                                                            <div class="form-check">
                                                                <input class="form-check-input service-checkbox" 
                                                                       type="checkbox" 
                                                                       value="{{ $service->id }}" 
                                                                       id="service_{{ $service->id }}">
                                                                <label class="form-check-label w-100" for="service_{{ $service->id }}">
                                                                    <div class="d-flex justify-content-between align-items-start">
                                                                        <div>
                                                                            <h6 class="mb-1">{{ $service->name }}</h6>
                                                                            <p class="text-muted small mb-2">{{ $service->description }}</p>
                                                                            <strong class="text-success">Rp {{ number_format($service->harga, 0, ',', '.') }}</strong>
                                                                        </div>
                                                                    </div>
                                                                </label>
                                                            </div>
                                                            
                                                            <!-- Quantity Input (hidden by default) -->
                                                            <div class="quantity-input mt-2" style="display: none;">
                                                                <label class="small">Quantity:</label>
                                                                <div class="input-group input-group-sm">
                                                                    <div class="input-group-prepend">
                                                                        <button class="btn btn-outline-secondary qty-minus" type="button">-</button>
                                                                    </div>
                                                                    <input type="number" 
                                                                           class="form-control text-center quantity-field" 
                                                                           value="1" 
                                                                           min="1" 
                                                                           max="100"
                                                                           name="services[{{ $service->id }}][quantity]">
                                                                    <input type="hidden" 
                                                                           name="services[{{ $service->id }}][service_id]" 
                                                                           value="{{ $service->id }}">
                                                                    <div class="input-group-append">
                                                                        <button class="btn btn-outline-secondary qty-plus" type="button">+</button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            @error('services')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Notes -->
                        <div class="form-group">
                            <label for="notes">Catatan</label>
                            <textarea class="form-control" id="notes" name="notes" rows="3" 
                                      placeholder="Catatan tambahan untuk layanan...">{{ old('notes') }}</textarea>
                            @error('notes')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Submit Button -->
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Simpan Booking Service
                            </button>
                            <a href="{{ route('booking-services.index') }}" class="btn btn-secondary ml-2">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Summary Card -->
        <div class="col-lg-4">
            <div class="card shadow mb-4" id="summaryCard" style="display: none;">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Ringkasan Layanan</h6>
                </div>
                <div class="card-body">
                    <div id="selectedServices">
                        <!-- Selected services will be displayed here -->
                    </div>
                    <hr>
                    <div class="d-flex justify-content-between">
                        <strong>Total:</strong>
                        <strong class="text-success" id="totalAmount">Rp 0</strong>
                    </div>
                </div>
            </div>

            <!-- Booking Info Card -->
            @if(isset($booking))
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">Info Booking</h6>
                </div>
                <div class="card-body">
                    <table class="table table-borderless table-sm">
                        <tr>
                            <td><strong>ID:</strong></td>
                            <td>#{{ $booking->id }}</td>
                        </tr>
                        <tr>
                            <td><strong>Tamu:</strong></td>
                            <td>{{ $booking->guest->name }}</td>
                        </tr>
                        <tr>
                            <td><strong>Check-in:</strong></td>
                            <td>{{ $booking->check_in_date_formatted }}</td>
                        </tr>
                        <tr>
                            <td><strong>Status:</strong></td>
                            <td><span class="badge badge-success">{{ ucfirst($booking->status) }}</span></td>
                        </tr>
                    </table>
                </div>
            </div>
            @endif
        </div>
    </div>

</div>

@push('styles')

@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ho+j7jyWK8fNQe+A12Hb8AhRq26LrZ/JpcUGGOn+Y7RsweNrtN/tE3MoK7ZeZDyx" crossorigin="anonymous"></script>

<script>
$(document).ready(function() {
    // Service selection handling
    $('.service-checkbox').on('change', function() {
        const serviceCard = $(this).closest('.service-card');
        const quantityInput = serviceCard.find('.quantity-input');
        const serviceId = $(this).val();
        
        if ($(this).is(':checked')) {
            serviceCard.addClass('selected');
            quantityInput.show();
            
            // Enable the hidden inputs
            quantityInput.find('input').prop('disabled', false);
        } else {
            serviceCard.removeClass('selected');
            quantityInput.hide();
            
            // Disable the hidden inputs
            quantityInput.find('input').prop('disabled', true);
        }
        
        updateSummary();
    });
    
    // Quantity controls
    $('.qty-plus').on('click', function() {
        const input = $(this).closest('.input-group').find('.quantity-field');
        const currentVal = parseInt(input.val()) || 1;
        const maxVal = parseInt(input.attr('max')) || 100;
        
        if (currentVal < maxVal) {
            input.val(currentVal + 1);
            updateSummary();
        }
    });
    
    $('.qty-minus').on('click', function() {
        const input = $(this).closest('.input-group').find('.quantity-field');
        const currentVal = parseInt(input.val()) || 1;
        const minVal = parseInt(input.attr('min')) || 1;
        
        if (currentVal > minVal) {
            input.val(currentVal - 1);
            updateSummary();
        }
    });
    
    // Quantity input change
    $('.quantity-field').on('change', function() {
        const value = parseInt($(this).val()) || 1;
        const min = parseInt($(this).attr('min')) || 1;
        const max = parseInt($(this).attr('max')) || 100;
        
        if (value < min) $(this).val(min);
        if (value > max) $(this).val(max);
        
        updateSummary();
    });
    
    // Form submission
    $('#bookingServiceForm').on('submit', function(e) {
        e.preventDefault();
        
        // Check if at least one service is selected
        const selectedServices = $('.service-checkbox:checked').length;
        if (selectedServices === 0) {
            Swal.fire({
                icon: 'warning',
                title: 'Peringatan',
                text: 'Silakan pilih minimal satu layanan'
            });
            return;
        }
        
        const formData = new FormData(this);
        const submitBtn = $(this).find('button[type="submit"]');
        const originalText = submitBtn.html();
        
        // Show loading
        submitBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Menyimpan...');
        
        // Clear previous errors
        $('.form-control').removeClass('is-invalid');
        $('.invalid-feedback').remove();
        
        // Prepare services data
        const servicesData = [];
        $('.service-checkbox:checked').each(function() {
            const serviceId = $(this).val();
            const quantity = $(this).closest('.service-card').find('.quantity-field').val();
            servicesData.push({
                service_id: serviceId,
                quantity: quantity
            });
        });
        
        // Remove disabled inputs and rebuild services data
        $('input[name^="services"]').remove();
        servicesData.forEach((service, index) => {
            $('<input>').attr({
                type: 'hidden',
                name: `services[${index}][service_id]`,
                value: service.service_id
            }).appendTo('#bookingServiceForm');
            
            $('<input>').attr({
                type: 'hidden',
                name: `services[${index}][quantity]`,
                value: service.quantity
            }).appendTo('#bookingServiceForm');
        });
        
        $.ajax({
            url: $(this).attr('action'),
            method: 'POST',
            data: new FormData(this),
            processData: false,
            contentType: false,
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'Accept': 'application/json' // Ini penting
            },
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Berhasil!',
                        text: response.message,
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        if (response.redirect_url) {
                            window.location.href = response.redirect_url;
                        } else {
                            window.location.href = '{{ route("booking-services.index") }}';
                        }
                    });
                }
            },
            error: function(xhr) {
                if (xhr.status === 422) {
                    const errors = xhr.responseJSON.errors;
                    Object.keys(errors).forEach(function(key) {
                        const field = $(`#${key}, [name="${key}"]`);
                        if (field.length > 0) {
                            field.addClass('is-invalid');
                            field.after(`<div class="invalid-feedback">${errors[key][0]}</div>`);
                        }
                    });
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'Validasi Error!',
                        text: xhr.responseJSON.message || 'Silakan periksa form Anda.'
                    });
                } else {
                    const message = xhr.responseJSON?.message || 'Terjadi kesalahan saat menyimpan data.';
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: message
                    });
                }
            },
            complete: function() {
                submitBtn.prop('disabled', false).html(originalText);
            }
        });
    });
});

function updateSummary() {
    const selectedServices = [];
    let totalAmount = 0;
    
    $('.service-checkbox:checked').each(function() {
        const serviceCard = $(this).closest('.service-card');
        const serviceName = serviceCard.find('h6').text();
        const priceText = serviceCard.find('.text-success').text();
        const price = parseFloat(priceText.replace(/[^\d]/g, ''));
        const quantity = parseInt(serviceCard.find('.quantity-field').val()) || 1;
        const subtotal = price * quantity;
        
        selectedServices.push({
            name: serviceName,
            price: price,
            quantity: quantity,
            subtotal: subtotal
        });
        
        totalAmount += subtotal;
    });
    
    if (selectedServices.length > 0) {
        let html = '';
        selectedServices.forEach(service => {
            html += `
                <div class="d-flex justify-content-between mb-2">
                    <div>
                        <strong>${service.name}</strong><br>
                        <small class="text-muted">${service.quantity} x Rp ${service.price.toLocaleString('id-ID')}</small>
                    </div>
                    <div class="text-right">
                        <strong>Rp ${service.subtotal.toLocaleString('id-ID')}</strong>
                    </div>
                </div>
            `;
        });
        
        $('#selectedServices').html(html);
        $('#totalAmount').text('Rp ' + totalAmount.toLocaleString('id-ID'));
        $('#summaryCard').show();
    } else {
        $('#summaryCard').hide();
    }
}
</script>

@endpush

@endsection