@extends('admin-layouts.master')

@section('content')
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Booking Services</h1>
        <a href="{{ route('booking-services.create') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
            <i class="fas fa-plus fa-sm text-white-50"></i> Tambah Layanan
        </a>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Layanan
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $stats['total_services'] }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-concierge-bell fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Layanan Hari Ini
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $stats['today_services'] }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar-day fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Revenue Total
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                Rp {{ number_format($stats['total_revenue'], 0, ',', '.') }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Revenue Bulan Ini
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                Rp {{ number_format($stats['monthly_revenue'], 0, ',', '.') }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter & Pencarian</h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('booking-services.index') }}" id="filterForm">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Booking:</label>
                            <select class="form-control" name="booking_id" id="bookingFilter">
                                <option value="">Semua Booking</option>
                                @foreach($activeBookings as $booking)
                                <option value="{{ $booking->id }}" {{ request('booking_id') == $booking->id ? 'selected' : '' }}>
                                    #{{ $booking->id }} - {{ $booking->guest->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Layanan:</label>
                            <select class="form-control" name="service_id" id="serviceFilter">
                                <option value="">Semua Layanan</option>
                                @foreach($services as $service)
                                <option value="{{ $service->id }}" {{ request('service_id') == $service->id ? 'selected' : '' }}>
                                    {{ $service->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Dari Tanggal:</label>
                            <input type="date" class="form-control" name="start_date" value="{{ request('start_date') }}">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Sampai Tanggal:</label>
                            <input type="date" class="form-control" name="end_date" value="{{ request('end_date') }}">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div class="d-flex">
                                <button type="submit" class="btn btn-primary mr-2">
                                    <i class="fas fa-search"></i> Filter
                                </button>
                                <a href="{{ route('booking-services.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> Reset
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Services Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Data Booking Services</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Booking</th>
                            <th>Tamu</th>
                            <th>Layanan</th>
                            <th>Qty</th>
                            <th>Harga</th>
                            <th>Total</th>
                            <th>Tanggal</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    
                    <tbody>
                        @forelse ($bookingServices as $bookingService)
                        <tr>
                            <td>#{{ $bookingService->id }}</td>
                            <td>
                                <strong>#{{ $bookingService->booking->id }}</strong><br>
                                <small class="text-muted">{{ $bookingService->booking->check_in_date_formatted }}</small>
                            </td>
                            <td>
                                <strong>{{ $bookingService->booking->guest->name }}</strong><br>
                                <small class="text-muted">{{ $bookingService->booking->guest->phone ?? 'No phone' }}</small>
                            </td>
                            <td>
                                <strong>{{ $bookingService->service->name }}</strong><br>
                                <small class="text-muted">
                                    <span class="badge badge-secondary">{{ $bookingService->service->category->name      }}</span>
                                </small>
                            </td>
                            <td>
                                <span class="badge badge-primary">{{ $bookingService->quantity }}</span>
                            </td>
                            <td>{{ $bookingService->formatted_unit_price }}</td>
                            <td>
                                <strong class="text-success">{{ $bookingService->formatted_total_amount }}</strong>
                            </td>
                            <td>{{ $bookingService->service_date_formatted }}</td>
                            <td>
                                <div class="btn-group" role="group">
                                    <button class="btn btn-info btn-sm" onclick="viewService({{ $bookingService->id }})" title="Lihat Detail">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                    <button class="btn btn-danger btn-sm" onclick="deleteService({{ $bookingService->id }})" title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="9" class="text-center py-4">
                                <i class="fas fa-concierge-bell fa-3x text-gray-400 mb-3"></i>
                                <p class="text-gray-500">Tidak ada data booking services ditemukan</p>
                                <a href="{{ route('booking-services.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Tambah Layanan Baru
                                </a>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            @if($bookingServices->hasPages())
            <div class="d-flex justify-content-center mt-4">
                {{ $bookingServices->appends(request()->query())->links() }}
            </div>
            @endif
        </div>
    </div>

</div>

<!-- Modal untuk Detail Service -->
<div class="modal fade" id="serviceDetailModal" tabindex="-1" role="dialog" aria-labelledby="serviceDetailModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="serviceDetailModalLabel">Detail Booking Service</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="serviceDetailContent">
                <!-- Content will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ho+j7jyWK8fNQe+A12Hb8AhRq26LrZ/JpcUGGOn+Y7RsweNrtN/tE3MoK7ZeZDyx" crossorigin="anonymous"></script>

<script>
// View service details
function viewService(id) {
    $('#serviceDetailContent').html(`
        <div class="text-center py-4">
            <i class="fas fa-spinner fa-spin fa-2x text-primary"></i>
            <p class="mt-2">Memuat detail layanan...</p>
        </div>
    `);
    $('#serviceDetailModal').modal('show');
    
    $.ajax({
        url: `{{ url('booking-services') }}/${id}`,
        method: 'GET',
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        },
        success: function(response) {
            if (response.success) {
                const service = response.data;
                const content = `
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Informasi Booking:</h6>
                            <table class="table table-borderless table-sm">
                                <tr><td><strong>ID Booking:</strong></td><td>#${service.booking.id}</td></tr>
                                <tr><td><strong>Tamu:</strong></td><td>${service.booking.guest.name}</td></tr>
                                <tr><td><strong>Telepon:</strong></td><td>${service.booking.guest.phone || 'N/A'}</td></tr>
                                <tr><td><strong>Check-in:</strong></td><td>${service.booking.check_in_date}</td></tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h6>Informasi Layanan:</h6>
                            <table class="table table-borderless table-sm">
                                <tr><td><strong>Layanan:</strong></td><td>${service.service.name}</td></tr>
                                <tr><td><strong>Kategori:</strong></td><td>
                                    <span class="badge badge-secondary">${service.service.category}</span>
                                </td></tr>
                                <tr><td><strong>Tanggal:</strong></td><td>${service.service_date}</td></tr>
                                <tr><td><strong>Dibuat:</strong></td><td>${service.created_at}</td></tr>
                            </table>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <h6>Detail Biaya:</h6>
                    <div class="row">
                        <div class="col-md-6 offset-md-3">
                            <table class="table table-borderless">
                                <tr>
                                    <td><strong>Quantity:</strong></td>
                                    <td class="text-right">${service.quantity}</td>
                                </tr>
                                <tr>
                                    <td><strong>Harga/Unit:</strong></td>
                                    <td class="text-right">Rp ${service.unit_price.toLocaleString('id-ID')}</td>
                                </tr>
                                <tr>
                                    <td><strong>Subtotal:</strong></td>
                                    <td class="text-right">Rp ${service.subtotal.toLocaleString('id-ID')}</td>
                                </tr>
                                <tr>
                                    <td><strong>PPN (${service.ppn_rate}%):</strong></td>
                                    <td class="text-right">Rp ${service.ppn_amount.toLocaleString('id-ID')}</td>
                                </tr>
                                <tr class="table-success">
                                    <td><strong>Total:</strong></td>
                                    <td class="text-right"><strong>Rp ${service.total_amount.toLocaleString('id-ID')}</strong></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    
                    ${service.notes ? `
                    <hr>
                    <h6>Catatan:</h6>
                    <p class="text-muted">${service.notes}</p>
                    ` : ''}
                `;
                
                $('#serviceDetailContent').html(content);
            } else {
                $('#serviceDetailContent').html(`
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i>
                        Data layanan tidak ditemukan
                    </div>
                `);
            }
        },
        error: function(xhr) {
            $('#serviceDetailContent').html(`
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-triangle"></i>
                    Gagal memuat detail layanan
                </div>
            `);
        }
    });
}

// Delete service
function deleteService(id) {
    Swal.fire({
        title: 'Konfirmasi Hapus',
        text: 'Apakah Anda yakin ingin menghapus layanan ini?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Ya, Hapus!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `{{ url('booking-services') }}/${id}`,
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                            location.reload();
                        });
                    }
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Gagal!',
                        text: xhr.responseJSON?.message || 'Gagal menghapus layanan'
                    });
                }
            });
        }
    });
}

// Handle success messages from server
@if(session('success'))
    Swal.fire({
        title: 'Berhasil!',
        text: '{{ session("success") }}',
        icon: 'success',
        timer: 3000,
        showConfirmButton: false
    });
@endif

@if(session('error'))
    Swal.fire({
        title: 'Error!',
        text: '{{ session("error") }}',
        icon: 'error'
    });
@endif
</script>

@endpush

@endsection