@extends('admin-layouts.master')

@section('content')
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Detail Booking Service #{{ $bookingService->id }}</h1>
        <div>
            <a href="{{ route('booking-services.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm mr-2">
                <i class="fas fa-arrow-left fa-sm text-white-50"></i> Kembali
            </a>
            <button class="btn btn-sm btn-danger" onclick="deleteService({{ $bookingService->id }})">
                <i class="fas fa-trash fa-sm text-white-50"></i> Hapus
            </button>
        </div>
    </div>

    <div class="row">
        <!-- Main Content -->
        <div class="col-lg-8">
            <!-- Service Details -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Layanan</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>ID Service:</strong></td>
                                    <td>#{{ $bookingService->id }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Nama Layanan:</strong></td>
                                    <td>{{ $bookingService->service->name }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Kategori:</strong></td>
                                    <td>
                                        <span class="badge badge-{{ $bookingService->service->category_color }}">
                                            {{ $bookingService->service->category->name }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Deskripsi:</strong></td>
                                    <td>{{ $bookingService->service->description ?? 'Tidak ada deskripsi' }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Tanggal Layanan:</strong></td>
                                    <td>{{ $bookingService->service_date_formatted }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Quantity:</strong></td>
                                    <td><span class="badge badge-primary">{{ $bookingService->quantity }}</span></td>
                                </tr>
                                <tr>
                                    <td><strong>Harga/Unit:</strong></td>
                                    <td>{{ $bookingService->formatted_unit_price }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Dibuat:</strong></td>
                                    <td>{{ $bookingService->created_at->format('d/m/Y H:i') }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    @if($bookingService->notes)
                    <hr>
                    <div class="row">
                        <div class="col-12">
                            <h6><strong>Catatan:</strong></h6>
                            <p class="text-muted">{{ $bookingService->notes }}</p>
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Booking Information -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">Informasi Booking</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>ID Booking:</strong></td>
                                    <td>
                                        <a href="{{ route('bookings.show', $bookingService->booking->id) }}" class="text-primary">
                                            #{{ $bookingService->booking->id }}
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Nama Tamu:</strong></td>
                                    <td>{{ $bookingService->booking->guest->name }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Telepon:</strong></td>
                                    <td>{{ $bookingService->booking->guest->phone ?? 'Tidak ada' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Email:</strong></td>
                                    <td>{{ $bookingService->booking->guest->email ?? 'Tidak ada' }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Check-in:</strong></td>
                                    <td>{{ $bookingService->booking->check_in_date_formatted }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Check-out:</strong></td>
                                    <td>{{ $bookingService->booking->check_out_date_formatted }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Status:</strong></td>
                                    <td>
                                        @if($bookingService->booking->status == 'checked_in')
                                            <span class="badge badge-success">Checked In</span>
                                        @elseif($bookingService->booking->status == 'checked_out')
                                            <span class="badge badge-info">Checked Out</span>
                                        @else
                                            <span class="badge badge-primary">{{ ucfirst($bookingService->booking->status) }}</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Total Kamar:</strong></td>
                                    <td>{{ $bookingService->booking->formatted_total_amount }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Price Breakdown -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-success">Rincian Biaya</h6>
                </div>
                <div class="card-body">
                    <table class="table table-borderless">
                        <tr>
                            <td><strong>Quantity:</strong></td>
                            <td class="text-right">{{ $bookingService->quantity }}</td>
                        </tr>
                        <tr>
                            <td><strong>Harga/Unit:</strong></td>
                            <td class="text-right">{{ $bookingService->formatted_unit_price }}</td>
                        </tr>
                        <tr class="border-top">
                            <td><strong>Subtotal:</strong></td>
                            <td class="text-right">{{ $bookingService->formatted_subtotal }}</td>
                        </tr>
                        <tr>
                            <td><strong>PPN ({{ $bookingService->ppn_rate }}%):</strong></td>
                            <td class="text-right">{{ $bookingService->formatted_ppn_amount }}</td>
                        </tr>
                        <tr class="border-top table-success">
                            <td><strong>Total:</strong></td>
                            <td class="text-right"><strong>{{ $bookingService->formatted_total_amount }}</strong></td>
                        </tr>
                    </table>
                </div>
            </div>

            <!-- Actions -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-warning">Aksi</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('booking-services.create', ['booking_id' => $bookingService->booking->id]) }}" 
                           class="btn btn-primary btn-block mb-2">
                            <i class="fas fa-plus"></i> Tambah Layanan Lain
                        </a>
                        
                        <a href="{{ route('booking-services.index', ['booking_id' => $bookingService->booking->id]) }}" 
                           class="btn btn-info btn-block mb-2">
                            <i class="fas fa-list"></i> Lihat Semua Layanan
                        </a>
                        
                        <button class="btn btn-success btn-block mb-2" onclick="printReceipt()">
                            <i class="fas fa-print"></i> Cetak Kwitansi
                        </button>
                        
                        <button class="btn btn-danger btn-block" onclick="deleteService({{ $bookingService->id }})">
                            <i class="fas fa-trash"></i> Hapus Layanan
                        </button>
                    </div>
                </div>
            </div>

            <!-- Service Image (if available) -->
            @if($bookingService->service->image)
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-secondary">Gambar Layanan</h6>
                </div>
                <div class="card-body text-center">
                    <img src="{{ $bookingService->service->image_url }}" 
                         alt="{{ $bookingService->service->name }}" 
                         class="img-fluid rounded">
                </div>
            </div>
            @endif
        </div>
    </div>

</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
function deleteService(id) {
    Swal.fire({
        title: 'Konfirmasi Hapus',
        text: 'Apakah Anda yakin ingin menghapus layanan ini?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Ya, Hapus!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `{{ url('booking-services') }}/${id}`,
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = '{{ route("booking-services.index") }}';
                        });
                    }
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Gagal!',
                        text: xhr.responseJSON?.message || 'Gagal menghapus layanan'
                    });
                }
            });
        }
    });
}

function printReceipt() {
    // Implement print functionality
    window.print();
}

// Handle success messages from server
@if(session('success'))
    Swal.fire({
        title: 'Berhasil!',
        text: '{{ session("success") }}',
        icon: 'success',
        timer: 3000,
        showConfirmButton: false
    });
@endif

@if(session('error'))
    Swal.fire({
        title: 'Error!',
        text: '{{ session("error") }}',
        icon: 'error'
    });
@endif
</script>

@endpush

@endsection