@extends('admin-layouts.master')

@section('title', 'Booking Details')

@section('content')
<style>
.card {
    border-radius: 10px;
}

.card-header {
    border-top-left-radius: 10px;
    border-top-right-radius: 10px;
}

.btn {
    border-radius: 8px;
}

.badge-pill {
    font-size: 0.85rem;
}

.alert {
    border-radius: 8px;
}

.sticky-top {
    position: -webkit-sticky;
    position: sticky;
}

/* Booking Type Badges */
.booking-type-badge {
    font-size: 0.9rem;
    padding: 0.4rem 0.8rem;
    border-radius: 15px;
}

.booking-type-daily {
    background: linear-gradient(45deg, #28a745, #20c997);
    color: white;
}

.booking-type-hourly {
    background: linear-gradient(45deg, #ffc107, #fd7e14);
    color: white;
}

.booking-type-per-person {
    background: linear-gradient(45deg, #17a2b8, #007bff);
    color: white;
}

.duration-info {
    background: #f8f9fa;
    border: 1px solid #dee2e6;
    border-radius: 8px;
    padding: 0.75rem;
    margin: 0.5rem 0;
}

.duration-icon {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    color: white;
    margin-right: 0.75rem;
}

.duration-daily { background: #28a745; }
.duration-hourly { background: #ffc107; color: #212529; }
.duration-per-person { background: #17a2b8; }

/* Print Summary Styles */
.print-summary {
    display: none;
    max-width: 400px;
    margin: 0 auto;
    background: white;
    font-family: Arial, sans-serif;
}

.print-summary .summary-header {
    background: #f8f9fa;
    padding: 20px;
    border: 2px solid #000;
    border-bottom: 1px solid #000;
    text-align: center;
}

.print-summary .summary-header h2 {
    font-size: 18px;
    font-weight: 600;
    color: #000;
    margin: 0;
}

.print-summary .summary-content {
    padding: 20px;
    border-left: 2px solid #000;
    border-right: 2px solid #000;
}

.print-summary .guest-info {
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid #000;
}

.print-summary .guest-name {
    font-size: 16px;
    font-weight: 600;
    color: #000;
    margin-bottom: 5px;
}

.print-summary .room-info {
    font-size: 14px;
    color: #000;
    background: #f0f0f0;
    padding: 5px 10px;
    border: 1px solid #000;
    display: inline-block;
    border-radius: 4px;
}

.print-summary .booking-type-info {
    font-size: 12px;
    color: #000;
    background: #e9ecef;
    padding: 3px 8px;
    border-radius: 3px;
    margin-top: 5px;
    display: inline-block;
}

.print-summary .date-section {
    margin-bottom: 20px;
}

.print-summary .date-item {
    display: flex;
    align-items: center;
    margin-bottom: 15px;
    gap: 15px;
}

.print-summary .date-icon {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    color: #000;
    font-size: 12px;
    border: 2px solid #000;
    background: white;
}

.print-summary .date-text .date-label {
    font-size: 12px;
    color: #000;
    margin-bottom: 2px;
}

.print-summary .date-text .date-value {
    font-size: 14px;
    font-weight: 600;
    color: #000;
}

.print-summary .total-section {
    background: #f0f0f0;
    padding: 15px;
    border: 1px solid #000;
    border-radius: 4px;
    margin-bottom: 15px;
    text-align: center;
}

.print-summary .total-label {
    font-size: 14px;
    color: #000;
    margin-bottom: 5px;
}

.print-summary .total-amount {
    font-size: 24px;
    font-weight: 700;
    color: #000;
}

.print-summary .booking-date {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 10px 0;
    border-top: 1px solid #000;
    font-size: 12px;
}

.print-summary .booking-date-label {
    color: #000;
}

.print-summary .booking-date-value {
    color: #000;
    font-weight: 500;
}

.print-summary .summary-footer {
    text-align: center;
    padding: 15px;
    background: #f0f0f0;
    font-size: 10px;
    color: #000;
    border: 2px solid #000;
    border-top: 1px solid #000;
}

@media print {
    .no-print {
        display: none !important;
    }
    
    body * {
        visibility: hidden;
    }
    
    .print-summary, .print-summary * {
        visibility: visible;
    }
    
    .print-summary {
        position: absolute;
        left: 0;
        top: 0;
        display: block !important;
        width: 100% !important;
        max-width: 100% !important;
    }
    
    @page {
        margin: 0.5in;
        size: A4;
    }
    
    body {
        background: white !important;
    }
}
</style>

<!-- Print Summary (Hidden) -->
<div class="print-summary" id="printSummary">
    <div class="summary-header">
        <h2>Booking Summary</h2>
    </div>
    
    <div class="summary-content">
        <!-- Guest & Room Info -->
        <div class="guest-info">
            <div class="guest-name">{{ $booking->guest->name ?? 'N/A' }}</div>
            <div class="room-info">
                @foreach($booking->bookingDetails as $detail)
                    Room {{ $detail->room->room_number ?? 'N/A' }} - {{ $detail->room->typeRoom->name ?? 'Unknown' }}
                    @if(!$loop->last), @endif
                @endforeach
            </div>
            <div class="booking-type-info">
                {{ $booking->booking_type_display ?? 'Unknown' }} - {{ $booking->duration_display ?? 'N/A' }}
            </div>
        </div>
        
        <!-- Check-in/Check-out Dates -->
        <div class="date-section">
            <div class="date-item">
                <div class="date-icon">IN</div>
                <div class="date-text">
                    <div class="date-label">
                        @if($booking->booking_type === 'hourly')
                            Check-in Time
                        @else
                            Check-in Date
                        @endif
                    </div>
                    <div class="date-value">
                        @if($booking->booking_type === 'hourly')
                            {{ $booking->check_in_date_time_formatted ?? 'N/A' }}
                        @else
                            {{ $booking->check_in_date_formatted ?? 'N/A' }}
                        @endif
                    </div>
                </div>
            </div>
            
            <div class="date-item">
                <div class="date-icon">OUT</div>
                <div class="date-text">
                    <div class="date-label">
                        @if($booking->booking_type === 'hourly')
                            Check-out Time
                        @else
                            Check-out Date
                        @endif
                    </div>
                    <div class="date-value">
                        @if($booking->booking_type === 'hourly')
                            {{ \Carbon\Carbon::parse($booking->check_in_date)->addHours($booking->duration_hours ?? 1)->format('d/m/Y H:i') }}
                        @else
                            {{ $booking->check_out_date_formatted ?? 'N/A' }}
                        @endif
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Total Amount -->
        <div class="total-section">
            <div class="total-label">Total Amount</div>
            <div class="total-amount">Rp {{ number_format($booking->total_amount ?? 0, 0, ',', '.') }}</div>
        </div>
        
        <!-- Booking Date -->
        <div class="booking-date">
            <span class="booking-date-label">Booking Date</span>
            <span class="booking-date-value">{{ $booking->created_at->format('d/m/Y H:i') }}</span>
        </div>
    </div>
    
    <div class="summary-footer">
        Thank you for choosing our hotel<br>
        Booking ID: #{{ $booking->id }} | Generated: {{ now()->format('d/m/Y H:i') }}
    </div>
</div>

<div class="bg-light min-vh-100 py-4">
    <div class="container">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h1 class="h2 font-weight-bold text-dark mb-2">Booking Details</h1>
                        <p class="text-muted mb-0">Booking ID: #{{ $booking->id }}</p>
                    </div>
                    <div class="d-flex align-items-center">
                        <!-- Booking Type Badge -->
                        <span class="booking-type-badge mr-3 booking-type-{{ $booking->booking_type ?? 'daily' }}">
                            {{ $booking->booking_type_display ?? 'Unknown' }}
                        </span>
                        
                        <!-- Status Badge -->
                        <span class="badge badge-pill mr-3 px-3 py-2
                            @switch($booking->status)
                                @case('booked')
                                    badge-primary
                                    @break
                                @case('checked_in')
                                    badge-success
                                    @break
                                @case('checked_out')
                                    badge-info
                                    @break
                                @case('cancelled')
                                    badge-danger
                                    @break
                                @default
                                    badge-secondary
                            @endswitch">
                            {{ ucfirst($booking->status) }}
                        </span>
                        
                        <!-- Back Button -->
                        <a href="{{ route('bookings.index') }}" class="btn btn-outline-secondary btn-sm">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back to Bookings
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Main Content -->
            <div class="col-lg-8 mb-4">
                <!-- Guest Information -->
                <div class="card shadow-sm border-0 mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-user text-muted mr-2"></i>
                            Guest Information
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="small font-weight-medium text-muted d-block">Name</label>
                                <p class="mb-0 font-weight-medium">{{ $booking->guest->name ?? 'N/A' }}</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="small font-weight-medium text-muted d-block">Phone</label>
                                <p class="mb-0">{{ $booking->guest->phone ?? 'N/A' }}</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="small font-weight-medium text-muted d-block">Email</label>
                                <p class="mb-0">{{ $booking->guest->email ?? 'N/A' }}</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="small font-weight-medium text-muted d-block">ID Number</label>
                                <p class="mb-0">{{ $booking->guest->identity_number ?? 'N/A' }}</p>
                            </div>
                            @if($booking->booking_type === 'per_person' && $booking->guest_count)
                            <div class="col-md-12 mb-3">
                                <label class="small font-weight-medium text-muted d-block">Number of Guests</label>
                                <p class="mb-0 font-weight-medium">{{ $booking->guest_count }} person(s)</p>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Booking Duration Info -->
                <div class="card shadow-sm border-0 mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-clock text-muted mr-2"></i>
                            Booking Duration
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="duration-info">
                            <div class="d-flex align-items-center">
                                <div class="duration-icon duration-{{ $booking->booking_type ?? 'daily' }}">
                                    @switch($booking->booking_type)
                                        @case('hourly')
                                            <i class="fas fa-clock"></i>
                                            @break
                                        @case('per_person')
                                            <i class="fas fa-users"></i>
                                            @break
                                        @default
                                            <i class="fas fa-calendar-day"></i>
                                    @endswitch
                                </div>
                                <div>
                                    <h6 class="mb-1 font-weight-bold">{{ $booking->booking_type_display ?? 'Unknown' }}</h6>
                                    <p class="mb-0 text-muted">{{ $booking->duration_display ?? 'N/A' }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-6">
                                <label class="small font-weight-medium text-muted d-block">
                                    @if($booking->booking_type === 'hourly')
                                        Check-in Time
                                    @else
                                        Check-in Date
                                    @endif
                                </label>
                                <p class="mb-0 font-weight-medium">
                                    @if($booking->booking_type === 'hourly')
                                        {{ $booking->check_in_date_time_formatted ?? $booking->check_in_date_formatted ?? 'N/A' }}
                                    @else
                                        {{ $booking->check_in_date_formatted ?? 'N/A' }}
                                    @endif
                                </p>
                            </div>
                            <div class="col-md-6">
                                <label class="small font-weight-medium text-muted d-block">
                                    @if($booking->booking_type === 'hourly')
                                        Check-out Time
                                    @else
                                        Check-out Date
                                    @endif
                                </label>
                                <p class="mb-0 font-weight-medium">
                                    @if($booking->booking_type === 'hourly')
                                        {{ \Carbon\Carbon::parse($booking->check_in_date)->addHours($booking->duration_hours ?? 1)->format('d/m/Y H:i') }}
                                    @else
                                        {{ $booking->check_out_date_formatted ?? 'N/A' }}
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Room Details -->
                <div class="card shadow-sm border-0 mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-bed text-muted mr-2"></i>
                            Room Details
                        </h5>
                    </div>
                    <div class="card-body">
                        @foreach($booking->bookingDetails as $detail)
                        <div class="border rounded p-3 mb-3 bg-light">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <div>
                                    <h6 class="font-weight-bold mb-1">Room {{ $detail->room->room_number ?? 'N/A' }}</h6>
                                    <small class="text-muted">{{ $detail->room->typeRoom->name ?? 'Unknown Type' }}</small>
                                </div>
                                <div class="text-right">
                                    <small class="text-muted d-block">{{ $detail->booking_type_display ?? 'Unknown' }}</small>
                                    <strong class="text-dark">
                                        @switch($detail->booking_type)
                                            @case('hourly')
                                                Rp {{ number_format($detail->base_price ?? 0, 0, ',', '.') }}/hour
                                                @break
                                            @case('per_person')
                                                Rp {{ number_format($detail->base_price ?? 0, 0, ',', '.') }}/person
                                                @break
                                            @default
                                                Rp {{ number_format($detail->base_price ?? 0, 0, ',', '.') }}/night
                                        @endswitch
                                    </strong>
                                </div>
                            </div>

                            <!-- Calculation Details -->
                            <div class="alert alert-light border mb-3">
                                <small class="text-muted d-block mb-1">Calculation:</small>
                                <strong>{{ $detail->calculation_display ?? 'N/A' }}</strong>
                            </div>
                            
                            <div class="border-top pt-3">
                                <div class="d-flex justify-content-between small mb-1">
                                    <span class="text-muted">Subtotal</span>
                                    <span>Rp {{ number_format($detail->total_price ?? 0, 0, ',', '.') }}</span>
                                </div>
                                @if($detail->ppn_amount > 0)
                                <div class="d-flex justify-content-between small mb-1">
                                    <span class="text-muted">PPN ({{ $detail->ppn_rate * 100 ?? 11 }}%)</span>
                                    <span>Rp {{ number_format($detail->ppn_amount ?? 0, 0, ',', '.') }}</span>
                                </div>
                                @endif
                                <div class="d-flex justify-content-between font-weight-bold border-top pt-2 mt-2">
                                    <span>Total</span>
                                    <span>Rp {{ number_format($detail->grand_total ?? 0, 0, ',', '.') }}</span>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>

                <!-- Check-in/Check-out Information -->
                @if($booking->checkIn || $booking->checkOut)
                <div class="card shadow-sm border-0 mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-door-open text-muted mr-2"></i>
                            Check-in/Check-out Details
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @if($booking->checkIn)
                            <div class="col-md-6 mb-3">
                                <div class="alert alert-success border-0 h-100 mb-0">
                                    <h6 class="alert-heading font-weight-bold">
                                        <i class="fas fa-sign-in-alt mr-1"></i>
                                        Check-in
                                    </h6>
                                    <p class="mb-1 small">Time: {{ $booking->checkIn->check_in_time_formatted ?? 'N/A' }}</p>
                                    @if($booking->checkIn->notes)
                                    <p class="mb-0 small">Notes: {{ $booking->checkIn->notes }}</p>
                                    @endif
                                </div>
                            </div>
                            @endif
                            
                            @if($booking->checkOut)
                            <div class="col-md-6 mb-3">
                                <div class="alert alert-info border-0 h-100 mb-0">
                                    <h6 class="alert-heading font-weight-bold">
                                        <i class="fas fa-sign-out-alt mr-1"></i>
                                        Check-out
                                    </h6>
                                    <p class="mb-1 small">Time: {{ $booking->checkOut->check_out_time_formatted ?? 'N/A' }}</p>
                                    @if($booking->checkOut->notes)
                                    <p class="mb-0 small">Notes: {{ $booking->checkOut->notes }}</p>
                                    @endif
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
                @endif
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <div class="sticky-top" style="top: 20px;">
                    <!-- Booking Summary -->
                    <div class="card shadow border-0">
                        <div class="card-header bg-white border-bottom">
                            <h5 class="card-title mb-0">
                                <i class="fas fa-file-invoice text-muted mr-2"></i>
                                Booking Summary
                            </h5>
                        </div>
                        <div class="card-body">
                            <!-- Booking Type & Duration -->
                            <div class="mb-4">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="bg-{{ $booking->booking_type === 'hourly' ? 'warning' : ($booking->booking_type === 'per_person' ? 'info' : 'success') }} rounded-circle p-2 mr-3" style="width: 40px; height: 40px;">
                                        <i class="fas fa-{{ $booking->booking_type === 'hourly' ? 'clock' : ($booking->booking_type === 'per_person' ? 'users' : 'calendar-day') }} text-white small d-flex align-items-center justify-content-center h-100"></i>
                                    </div>
                                    <div>
                                        <small class="text-muted font-weight-medium d-block">Booking Type</small>
                                        <strong class="text-dark">{{ $booking->booking_type_display ?? 'Unknown' }}</strong>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center mb-3">
                                    <div class="bg-primary rounded-circle p-2 mr-3" style="width: 40px; height: 40px;">
                                        <i class="fas fa-hourglass-half text-white small d-flex align-items-center justify-content-center h-100"></i>
                                    </div>
                                    <div>
                                        <small class="text-muted font-weight-medium d-block">Duration</small>
                                        <strong class="text-dark">{{ $booking->duration_display ?? 'N/A' }}</strong>
                                    </div>
                                </div>
                            </div>

                            <!-- Dates -->
                            <div class="mb-4">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="bg-success rounded-circle p-2 mr-3" style="width: 40px; height: 40px;">
                                        <i class="fas fa-calendar-plus text-white small d-flex align-items-center justify-content-center h-100"></i>
                                    </div>
                                    <div>
                                        <small class="text-muted font-weight-medium d-block">
                                            @if($booking->booking_type === 'hourly')
                                                Check-in Time
                                            @else
                                                Check-in Date
                                            @endif
                                        </small>
                                        <strong class="text-dark">
                                            @if($booking->booking_type === 'hourly')
                                                {{ $booking->check_in_date_time_formatted ?? $booking->check_in_date_formatted ?? 'N/A' }}
                                            @else
                                                {{ $booking->check_in_date_formatted ?? 'N/A' }}
                                            @endif
                                        </strong>
                                    </div>
                                </div>
                                
                                <div class="d-flex align-items-center mb-3">
                                    <div class="bg-danger rounded-circle p-2 mr-3" style="width: 40px; height: 40px;">
                                        <i class="fas fa-calendar-minus text-white small d-flex align-items-center justify-content-center h-100"></i>
                                    </div>
                                    <div>
                                        <small class="text-muted font-weight-medium d-block">
                                            @if($booking->booking_type === 'hourly')
                                                Check-out Time
                                            @else
                                                Check-out Date
                                            @endif
                                        </small>
                                        <strong class="text-dark">
                                            @if($booking->booking_type === 'hourly')
                                                {{ \Carbon\Carbon::parse($booking->check_in_date)->addHours($booking->duration_hours ?? 1)->format('d/m/Y H:i') }}
                                            @else
                                                {{ $booking->check_out_date_formatted ?? 'N/A' }}
                                            @endif
                                        </strong>
                                    </div>
                                </div>
                            </div>

                            <!-- Total Amount -->
                            <div class="border-top pt-3 mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="h6 font-weight-bold mb-0">Total Amount</span>
                                    <span class="h4 font-weight-bold text-primary mb-0">Rp {{ number_format($booking->total_amount ?? 0, 0, ',', '.') }}</span>
                                </div>
                            </div>

                            <!-- Booking Date -->
                            <div class="border-top pt-3 mb-3">
                                <div class="d-flex justify-content-between align-items-center small">
                                    <span class="text-muted">Booking Date</span>
                                    <span class="text-dark">{{ $booking->created_at->format('d/m/Y H:i') }}</span>
                                </div>
                            </div>

                            <!-- Actions -->
                            <div class="border-top pt-3">
                                @if($booking->status === 'booked' && $booking->canCheckIn())
                                <button type="button" class="btn btn-success btn-block mb-2" onclick="quickCheckIn({{ $booking->id }})">
                                    <i class="fas fa-sign-in-alt mr-1"></i>
                                    Check-in Guest
                                </button>
                                @endif

                                @if($booking->status === 'checked_in' && $booking->canCheckOut())
                                <button type="button" class="btn btn-primary btn-block mb-2" onclick="checkOutBooking({{ $booking->id }})" >
                                    <i class="fas fa-sign-out-alt mr-1"></i>
                                    Check-out Guest
                                </button>
                                @endif

                                <button type="button" onclick="printBookingSummary()" class="btn btn-outline-secondary btn-block mb-2 no-print">
                                    <i class="fas fa-print mr-1"></i>
                                    Print Summary
                                </button>

                                @if($booking->canBeCancelled())
                                <button type="button" class="btn btn-outline-danger btn-block no-print cancel-btn" data-id="{{ $booking->id }}">
                                    <i class="fas fa-times mr-1"></i>
                                    Cancel Booking
                                </button>
                                @endif

                                {{-- @if(in_array($booking->status, ['booked', 'checked_in']) && Route::has('bookings.edit'))
                                <a href="{{ route('bookings.edit', $booking->id) }}" class="btn btn-outline-warning btn-block no-print">
                                    <i class="fas fa-edit mr-1"></i>
                                    Edit Booking
                                </a>
                                @endif --}}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Cancel Modal -->
<div class="modal fade" id="cancelModal" tabindex="-1" role="dialog" aria-labelledby="cancelModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="cancelModalLabel">Cancel Booking</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to cancel this booking? This action cannot be undone.</p>
                <div class="form-group">
                    <label for="cancelReason">Cancellation Reason (Optional)</label>
                    <textarea class="form-control" id="cancelReason" rows="3" placeholder="Enter reason for cancellation..."></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-danger" id="confirmCancelBtn">
                    <i class="fas fa-times mr-1"></i>
                    Confirm Cancel
                </button>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ho+j7jyWK8fNQe+A12Hb8AhRq26LrZ/JpcUGGOn+Y7RsweNrtN/tE3MoK7ZeZDyx" crossorigin="anonymous"></script>
<script>
// Print Booking Summary Function
function printBookingSummary() {
    window.print();
}

// Function untuk quick check-in booking
function quickCheckIn(id) {
    Swal.fire({
        title: 'Konfirmasi Check-in',
        text: 'Apakah Anda yakin ingin melakukan check-in untuk booking ini?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, Check-in!',
        cancelButtonText: 'Batal',
        showLoaderOnConfirm: true,
        allowOutsideClick: () => !Swal.isLoading(),
        preConfirm: () => {
            return $.ajax({
                url: `/api/bookings/${id}/quick-checkin`,
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    'Accept': 'application/json'
                }
            }).catch(error => {
                Swal.showValidationMessage(`Request failed: ${error.responseJSON?.message || error.statusText}`);
            });
        }
    }).then((result) => {
        if (result.isConfirmed && result.value) {
            const response = result.value;
            if (response.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil!',
                    text: response.message,
                    timer: 2000,
                    showConfirmButton: false
                }).then(() => {
                    location.reload();
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Gagal!',
                    text: response.message || 'Gagal melakukan check-in'
                });
            }
        }
    });
}

// Function untuk check-out booking
function checkOutBooking(id) {
    Swal.fire({
        title: 'Konfirmasi Check-out',
        text: 'Apakah Anda yakin ingin melakukan check-out untuk booking ini?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#ffc107',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, Check-out!',
        cancelButtonText: 'Batal',
        showLoaderOnConfirm: true,
        allowOutsideClick: () => !Swal.isLoading(),
        preConfirm: () => {
            return $.ajax({
                url: `/api/bookings/${id}/quick-checkout`,
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    'Accept': 'application/json'
                }
            }).catch(error => {
                Swal.showValidationMessage(`Request failed: ${error.responseJSON?.message || error.statusText}`);
            });
        }
    }).then((result) => {
        if (result.isConfirmed && result.value) {
            const response = result.value;
            if (response.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil!',
                    text: response.message,
                    timer: 2000,
                    showConfirmButton: false
                }).then(() => {
                    location.reload();
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Gagal!',
                    text: response.message || 'Gagal melakukan check-out'
                });
            }
        }
    });
}

$(document).ready(function() {
    let bookingId = null;

    // Saat tombol cancel di sidebar ditekan
    $(document).on('click', '.cancel-btn', function() {
        bookingId = $(this).data('id');
        $('#cancelModal').modal('show');
    });

    // Saat tombol Confirm Cancel di modal ditekan
    $('#confirmCancelBtn').click(function() {
        const reason = $('#cancelReason').val();

        if (!bookingId) {
            console.error('Booking ID tidak ditemukan');
            return;
        }

        // Disable button dan show loading
        $(this).prop('disabled', true).html('<i class="fas fa-spinner fa-spin mr-1"></i> Processing...');

        $.ajax({
            url: `/api/bookings/${bookingId}/cancel`,
            type: 'POST',
            data: {
                cancel_description: reason,
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                $('#cancelModal').modal('hide');
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Berhasil!',
                        text: response.message
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Gagal Membatalkan',
                        text: response.message
                    });
                }
            },
            error: function(xhr) {
                $('#cancelModal').modal('hide');
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: xhr.responseJSON?.message || 'Terjadi kesalahan saat membatalkan booking.'
                });
            },
            complete: function() {
                // Reset button
                $('#confirmCancelBtn').prop('disabled', false).html('<i class="fas fa-times mr-1"></i> Confirm Cancel');
            }
        });
    });

    // Reset modal saat ditutup
    $('#cancelModal').on('hidden.bs.modal', function () {
        $('#cancelReason').val('');
        bookingId = null;
        $('#confirmCancelBtn').prop('disabled', false).html('<i class="fas fa-times mr-1"></i> Confirm Cancel');
    });
});
</script>
@endpush
@endsection