<div class="day-detail-container">
    <!-- Room Information -->
    <div class="detail-section">
        <div class="section-header">
            <h6 class="section-title">
                <i class="fas fa-bed text-primary me-2"></i>
                Informasi Kamar
            </h6>
        </div>
        <div class="section-content">
            <div class="row">
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Nomor Kamar</label>
                        <div class="info-value room-number">{{ $room->room_number }}</div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Tipe Kamar</label>
                        <div class="info-value room-type">{{ $room->typeRoom->name ?? 'Unknown' }}</div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Status Kamar</label>
                        <div class="info-value room-status">
                            <span class="badge bg-{{ $room->status == 'available' ? 'success' : ($room->status == 'occupied' ? 'danger' : 'warning') }}">
                                {{ ucfirst($room->status ?? 'available') }}
                            </span>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Tanggal</label>
                        <div class="info-value selected-date">
                            @php
                                $displayDate = null;
                                if (isset($date)) {
                                    $displayDate = $date->format('d F Y');
                                } elseif (isset($selectedDate)) {
                                    $displayDate = \Carbon\Carbon::parse($selectedDate)->format('d F Y');
                                } elseif (request()->has('date')) {
                                    $displayDate = \Carbon\Carbon::parse(request('date'))->format('d F Y');
                                } else {
                                    $displayDate = \Carbon\Carbon::now()->format('d F Y');
                                }
                            @endphp
                            {{ $displayDate }}
                        </div>
                    </div>
                </div>
                @if($room->typeRoom)
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Kapasitas</label>
                        <div class="info-value">{{ $room->max_capacity_adult ?? 2 }} Dewasa</div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Harga per Malam</label>
                        <div class="info-value text-success">Rp {{ number_format($room->typeRoom->harga_per_malam ?? 0, 0, ',', '.') }}</div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>

    @if(isset($booking) && $booking)
    <!-- Booking Information -->
    <div class="detail-section">
        <div class="section-header">
            <h6 class="section-title">
                <i class="fas fa-calendar-check text-success me-2"></i>
                Informasi Booking
            </h6>
        </div>
        <div class="section-content">
            <div class="row">
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Booking ID</label>
                        <div class="info-value booking-id">#{{ $booking->id }}</div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Status Booking</label>
                        <div class="info-value">
                            @switch($booking->status)
                                @case('booked')
                                    <span class="badge bg-primary">Booked</span>
                                    @break
                                @case('checked_in')
                                    <span class="badge bg-success">Checked In</span>
                                    @break
                                @case('checked_out')
                                    <span class="badge bg-info">Checked Out</span>
                                    @break
                                @case('cancelled')
                                    <span class="badge bg-danger">Cancelled</span>
                                    @break
                                @default
                                    <span class="badge bg-secondary">{{ ucfirst($booking->status) }}</span>
                            @endswitch
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Check-in</label>
                        <div class="info-value">{{ \Carbon\Carbon::parse($booking->check_in_date)->format('d M Y') }}</div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Check-out</label>
                        <div class="info-value">{{ \Carbon\Carbon::parse($booking->check_out_date)->format('d M Y') }}</div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Lama Menginap</label>
                        <div class="info-value">
                            {{ \Carbon\Carbon::parse($booking->check_in_date)->diffInDays(\Carbon\Carbon::parse($booking->check_out_date)) }} malam
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Dibuat</label>
                        <div class="info-value">{{ $booking->created_at->format('d M Y H:i') }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Guest Information -->
    @if($booking->guest)
    <div class="detail-section">
        <div class="section-header">
            <h6 class="section-title">
                <i class="fas fa-user text-info me-2"></i>
                Informasi Tamu
            </h6>
        </div>
        <div class="section-content">
            <div class="row">
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Nama Tamu</label>
                        <div class="info-value guest-name">{{ $booking->guest->name }}</div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-item">
                        <label>No. Telepon</label>
                        <div class="info-value guest-phone">{{ $booking->guest->phone ?? '-' }}</div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Email</label>
                        <div class="info-value guest-email">{{ $booking->guest->email ?? '-' }}</div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Identitas</label>
                        <div class="info-value guest-identity">
                            {{ $booking->guest->identity_type ?? 'KTP' }}: {{ $booking->guest->identity_number ?? '-' }}
                        </div>
                    </div>
                </div>
                @if($booking->guest->address)
                <div class="col-12">
                    <div class="info-item">
                        <label>Alamat</label>
                        <div class="info-value">{{ $booking->guest->address }}</div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
    @endif

    <!-- Invoice Information -->
    @if(isset($booking->invoice) && $booking->invoice)
    <div class="detail-section">
        <div class="section-header">
            <h6 class="section-title">
                <i class="fas fa-receipt text-warning me-2"></i>
                Informasi Invoice
            </h6>
        </div>
        <div class="section-content">
            <div class="row">
                <div class="col-md-6">
                    <div class="info-item">
                        <label>No. Invoice</label>
                        <div class="info-value">{{ $booking->invoice->invoice_number }}</div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Status Pembayaran</label>
                        <div class="info-value">
                            @switch($booking->invoice->status)
                                @case('paid')
                                    <span class="badge bg-success">Lunas</span>
                                    @break
                                @case('pending')
                                    <span class="badge bg-warning">Pending</span>
                                    @break
                                @case('cancelled')
                                    <span class="badge bg-danger">Dibatalkan</span>
                                    @break
                                @case('overdue')
                                    <span class="badge bg-dark">Jatuh Tempo</span>
                                    @break
                                @default
                                    <span class="badge bg-secondary">{{ ucfirst($booking->invoice->status) }}</span>
                            @endswitch
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Total Biaya</label>
                        <div class="info-value text-success">Rp {{ number_format($booking->invoice->grand_total, 0, ',', '.') }}</div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-item">
                        <label>Tanggal Invoice</label>
                        <div class="info-value">{{ \Carbon\Carbon::parse($booking->invoice->invoice_date)->format('d M Y') }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    @else
    <!-- Available Actions (if no booking) -->
    <div class="detail-section">
        <div class="section-header">
            <h6 class="section-title">
                <i class="fas fa-plus-circle text-success me-2"></i>
                Status Ketersediaan
            </h6>
        </div>
        <div class="section-content">
            @php
                $selectedDate = null;
                if (isset($date)) {
                    $selectedDate = $date;
                } elseif (isset($selectedDate)) {
                    $selectedDate = \Carbon\Carbon::parse($selectedDate);
                } elseif (request()->has('date')) {
                    $selectedDate = \Carbon\Carbon::parse(request('date'));
                } else {
                    $selectedDate = \Carbon\Carbon::now();
                }
            @endphp
            
            @if($room->status == 'available')
                <div class="alert alert-success">
                    <i class="fas fa-check-circle me-2"></i>
                    Kamar tersedia untuk tanggal <strong>{{ $selectedDate->format('d F Y') }}</strong>. 
                    Anda dapat membuat booking baru untuk kamar ini.
                </div>
                
                <div class="availability-info">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="info-item">
                                <label>Harga per Malam</label>
                                <div class="info-value text-success">
                                    Rp {{ number_format($room->typeRoom->harga_per_malam ?? 0, 0, ',', '.') }}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="info-item">
                                <label>Kapasitas</label>
                                <div class="info-value">
                                    {{ $room->max_capacity_adult ?? 2 }} Dewasa
                                    @if($room->max_capacity_child)
                                        , {{ $room->max_capacity_child }} Anak
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @elseif($room->status == 'maintenance')
                <div class="alert alert-danger">
                    <i class="fas fa-wrench me-2"></i>
                    Kamar sedang dalam kondisi <strong>maintenance</strong> dan tidak tersedia untuk booking.
                </div>
            @elseif($room->status == 'cleaning')
                <div class="alert alert-warning">
                    <i class="fas fa-broom me-2"></i>
                    Kamar sedang dalam proses <strong>cleaning</strong>. Silakan cek kembali nanti.
                </div>
            @else
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    Status kamar: <strong>{{ ucfirst($room->status) }}</strong>
                </div>
            @endif
        </div>
    </div>
    @endif
</div>

<style>
.day-detail-container {
    padding: 0;
}

.detail-section {
    border-bottom: 1px solid #e9ecef;
}

.detail-section:last-child {
    border-bottom: none;
}

.section-header {
    background-color: #f8f9fa;
    padding: 1rem 1.5rem;
    border-bottom: 1px solid #e9ecef;
}

.section-title {
    margin: 0;
    font-weight: 600;
    color: #495057;
    font-size: 1rem;
}

.section-content {
    padding: 1.5rem;
}

.info-item {
    margin-bottom: 1rem;
}

.info-item label {
    display: block;
    font-size: 0.875rem;
    font-weight: 500;
    color: #6c757d;
    margin-bottom: 0.25rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.info-value {
    font-weight: 600;
    color: #495057;
    font-size: 1rem;
}

.info-value.room-number {
    color: #007bff;
    font-size: 1.25rem;
}

.info-value.booking-id {
    color: #28a745;
    font-family: 'Courier New', monospace;
}

.availability-info {
    margin-top: 1rem;
    padding: 1rem;
    background-color: #f8f9fa;
    border-radius: 8px;
}

.alert {
    border: none;
    border-radius: 8px;
    padding: 1rem;
}
</style>