@extends('admin-layouts.master')

@section('title', 'Daftar Check-in')

@section('content')
<div class="container-fluid py-4" style="background-color: #f8f9fa; min-height: 100vh;">
    <!-- Header Section -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <h2 class="mb-1 font-weight-bold text-dark">Daftar Check-in</h2>
                    <p class="text-muted mb-0">Kelola dan pantau check-in tamu hotel</p>
                </div>
                <div class="col-md-6">
                    <div class="d-flex justify-content-md-end align-items-center">
                        <!-- Search Form -->
                        <form method="GET" action="{{ route('checkins.index') }}" class="mr-3" style="max-width: 300px;">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text bg-white border-right-0">
                                        <i class="fas fa-search text-muted"></i>
                                    </span>
                                </div>
                                <input type="text" 
                                       name="search" 
                                       class="form-control border-left-0" 
                                       placeholder="Cari nama, phone, booking ID..." 
                                       value="{{ request('search') }}"
                                       id="searchInput">
                                @if(request('search'))
                                    <div class="input-group-append">
                                        <a href="{{ route('checkins.index', \Illuminate\Support\Arr::except(request()->query(), ['search'])) }}
" 
                                           class="btn btn-outline-secondary border-left-0">
                                            <i class="fas fa-times"></i>
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </form>

                        <!-- Filter Dropdown -->
                        {{-- <div class="dropdown mr-3">
                            <button class="btn btn-outline-secondary dropdown-toggle" type="button" id="filterDropdown" data-toggle="dropdown">
                                <i class="fas fa-filter mr-1"></i>
                                Filter
                                @if(request('status') || request('date'))
                                    <span class="badge badge-primary badge-sm ml-1">{{ collect([request('status'), request('date')])->filter()->count() }}</span>
                                @endif
                            </button>
                            <div class="dropdown-menu dropdown-menu-right">
                                <h6 class="dropdown-header">Status</h6>
                                <a class="dropdown-item {{ !request('status') ? 'active' : '' }}" 
                                   href="{{ route('checkins.index', array_merge(request()->except('status'), request('search') ? ['search' => request('search')] : [])) }}">
                                    <i class="fas fa-list mr-2"></i>Semua Status
                                </a>
                                <a class="dropdown-item {{ request('status') === 'checked_in' ? 'active' : '' }}" 
                                   href="{{ route('checkins.index', array_merge(request()->all(), ['status' => 'checked_in'])) }}">
                                    <i class="fas fa-check-circle text-success mr-2"></i>Active
                                </a>
                                <a class="dropdown-item {{ request('status') === 'checked_out' ? 'active' : '' }}" 
                                   href="{{ route('checkins.index', array_merge(request()->all(), ['status' => 'checked_out'])) }}">
                                    <i class="fas fa-sign-out-alt text-secondary mr-2"></i>Checked Out
                                </a>
                                <div class="dropdown-divider"></div>
                                <h6 class="dropdown-header">Tanggal</h6>
                                <a class="dropdown-item {{ request('date') === 'today' ? 'active' : '' }}" 
                                   href="{{ route('checkins.index', array_merge(request()->all(), ['date' => 'today'])) }}">
                                    <i class="fas fa-calendar-day text-primary mr-2"></i>Hari Ini
                                </a>
                                <a class="dropdown-item {{ request('date') === 'week' ? 'active' : '' }}" 
                                   href="{{ route('checkins.index', array_merge(request()->all(), ['date' => 'week'])) }}">
                                    <i class="fas fa-calendar-week text-info mr-2"></i>Minggu Ini
                                </a>
                                <a class="dropdown-item {{ request('date') === 'month' ? 'active' : '' }}" 
                                   href="{{ route('checkins.index', array_merge(request()->all(), ['date' => 'month'])) }}">
                                    <i class="fas fa-calendar-alt text-warning mr-2"></i>Bulan Ini
                                </a>
                            </div>
                        </div> --}}

                        <a href="{{ route('checkins.create') }}" class="btn btn-primary d-flex align-items-center">
                            <i class="fas fa-plus mr-2"></i>
                            Check-in Baru
                        </a>
                    </div>
                </div>
            </div>

            <!-- Active Filters Display -->
            @if(request('search') || request('status') || request('date'))
                <div class="row mt-3">
                    <div class="col-12">
                        <div class="d-flex align-items-center flex-wrap">
                            <span class="text-muted mr-2 small">Filter aktif:</span>
                            
                            @if(request('search'))
                                <span class="badge badge-primary mr-2 mb-1">
                                    <i class="fas fa-search mr-1"></i>
                                    "{{ request('search') }}"
                                    <a href="{{ route('checkins.index', \Illuminate\Support\Arr::except(request()->query(), ['search'])) }}
" class="text-white ml-1">
                                        <i class="fas fa-times"></i>
                                    </a>
                                </span>
                            @endif

                            @if(request('status'))
                                <span class="badge badge-success mr-2 mb-1">
                                    <i class="fas fa-tag mr-1"></i>
                                    {{ ucfirst(str_replace('_', ' ', request('status'))) }}
                                    <a href="{{ route('checkins.index', \Illuminate\Support\Arr::except(request()->query(), ['status'])) }}
" class="text-white ml-1">
                                        <i class="fas fa-times"></i>
                                    </a>
                                </span>
                            @endif

                            @if(request('date'))
                                <span class="badge badge-info mr-2 mb-1">
                                    <i class="fas fa-calendar mr-1"></i>
                                    {{ ucfirst(request('date')) }}
                                    <a href="{{ route('checkins.index', \Illuminate\Support\Arr::except(request()->query(), ['date'])) }}
" class="text-white ml-1">
                                        <i class="fas fa-times"></i>
                                    </a>
                                </span>
                            @endif

                            <a href="{{ route('checkins.index') }}" class="btn btn-sm btn-outline-secondary mb-1">
                                <i class="fas fa-times mr-1"></i>Reset Filter
                            </a>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Alert Messages -->
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show d-flex align-items-center" role="alert">
            <i class="fas fa-check-circle mr-3"></i>
            <span>{{ session('success') }}</span>
            <button type="button" class="close" data-dismiss="alert">
                <span>&times;</span>
            </button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show d-flex align-items-center" role="alert">
            <i class="fas fa-exclamation-circle mr-3"></i>
            <span>{{ session('error') }}</span>
            <button type="button" class="close" data-dismiss="alert">
                <span>&times;</span>
            </button>
        </div>
    @endif

    <!-- Search Results Info -->
    @if(request('search') || request('status') || request('date'))
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body py-3">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <i class="fas fa-info-circle text-primary mr-2"></i>
                        <span class="text-dark">
                            Menampilkan {{ $checkIns->count() }} dari {{ $checkIns->total() }} hasil
                            @if(request('search'))
                                untuk pencarian "<strong>{{ request('search') }}</strong>"
                            @endif
                        </span>
                    </div>
                    @if($checkIns->count() > 0)
                        <small class="text-muted">
                            Halaman {{ $checkIns->currentPage() }} dari {{ $checkIns->lastPage() }}
                        </small>
                    @endif
                </div>
            </div>
        </div>
    @endif

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <div class="text-muted small font-weight-medium">Check-in Hari Ini</div>
                            <div class="h4 font-weight-bold mb-0">{{ $todayCheckins ?? 0 }}</div>
                        </div>
                        <div class="bg-primary rounded p-3">
                            <i class="fas fa-sign-in-alt fa-lg text-white"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <div class="text-muted small font-weight-medium">Tamu Aktif</div>
                            <div class="h4 font-weight-bold mb-0">{{ $activeGuests ?? 0 }}</div>
                        </div>
                        <div class="bg-success rounded p-3">
                            <i class="fas fa-users fa-lg text-white"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <div class="text-muted small font-weight-medium">Kamar Terisi</div>
                            <div class="h4 font-weight-bold mb-0">{{ $occupiedRooms ?? 0 }}</div>
                        </div>
                        <div class="bg-info rounded p-3">
                            <i class="fas fa-bed fa-lg text-white"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <div class="text-muted small font-weight-medium">Rata-rata Check-in</div>
                            <div class="h4 font-weight-bold mb-0">{{ $mostFrequentHourFormatted ?? '14:30' }}</div>
                        </div>
                        <div class="bg-warning rounded p-3">
                            <i class="fas fa-clock fa-lg text-white"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Check-in Table -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom">
            <div class="d-flex align-items-center justify-content-between">
                <h5 class="mb-0 font-weight-semibold">Riwayat Check-in</h5>
                
                <!-- Sort Options -->
                <div class="dropdown">
                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-toggle="dropdown">
                        <i class="fas fa-sort mr-1"></i>
                        @if(request('sort') === 'guest_name')
                            Nama Tamu
                        @elseif(request('sort') === 'check_in_time')
                            Waktu Check-in
                        @elseif(request('sort') === 'booking_id')
                            ID Booking
                        @else
                            Terbaru
                        @endif
                    </button>
                    <div class="dropdown-menu dropdown-menu-right">
                        <a class="dropdown-item {{ !request('sort') ? 'active' : '' }}" 
                           href="{{ route('checkins.index', array_merge(request()->except(['sort', 'direction']), [])) }}">
                            <i class="fas fa-clock mr-2"></i>Terbaru
                        </a>
                        <a class="dropdown-item {{ request('sort') === 'guest_name' ? 'active' : '' }}" 
                           href="{{ route('checkins.index', array_merge(request()->all(), ['sort' => 'guest_name', 'direction' => 'asc'])) }}">
                            <i class="fas fa-user mr-2"></i>Nama Tamu
                        </a>
                        <a class="dropdown-item {{ request('sort') === 'check_in_time' ? 'active' : '' }}" 
                           href="{{ route('checkins.index', array_merge(request()->all(), ['sort' => 'check_in_time', 'direction' => 'desc'])) }}">
                            <i class="fas fa-calendar mr-2"></i>Waktu Check-in
                        </a>
                        <a class="dropdown-item {{ request('sort') === 'booking_id' ? 'active' : '' }}" 
                           href="{{ route('checkins.index', array_merge(request()->all(), ['sort' => 'booking_id', 'direction' => 'desc'])) }}">
                            <i class="fas fa-hashtag mr-2"></i>ID Booking
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        @if($checkIns->count() > 0)
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th class="border-0 font-weight-semibold text-muted small">BOOKING INFO</th>
                                <th class="border-0 font-weight-semibold text-muted small">TAMU</th>
                                <th class="border-0 font-weight-semibold text-muted small">KAMAR</th>
                                <th class="border-0 font-weight-semibold text-muted small">WAKTU CHECK-IN</th>
                                <th class="border-0 font-weight-semibold text-muted small">STATUS</th>
                                {{-- <th class="border-0 font-weight-semibold text-muted small text-right">AKSI</th> --}}
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($checkIns as $checkIn)
                                <tr class="checkin-row" data-checkin-id="{{ $checkIn->id }}">
                                    <td class="align-middle">
                                        <div>
                                            <div class="font-weight-semibold text-dark">#{{ $checkIn->booking->id }}</div>
                                            <small class="text-muted">
                                                {{ \Carbon\Carbon::parse($checkIn->booking->check_in_date)->format('d M Y') }} - 
                                                {{ \Carbon\Carbon::parse($checkIn->booking->check_out_date)->format('d M Y') }}
                                            </small>
                                        </div>
                                    </td>
                                    <td class="align-middle">
                                        <div class="d-flex align-items-center">
                                            <div class="avatar avatar-sm bg-primary text-white rounded-circle d-flex align-items-center justify-content-center mr-3" style="width: 40px; height: 40px;">
                                                <span class="font-weight-bold small">{{ substr($checkIn->booking->guest->name, 0, 2) }}</span>
                                            </div>
                                            <div>
                                                <div class="font-weight-semibold text-dark">{{ $checkIn->booking->guest->name }}</div>
                                                <small class="text-muted">{{ $checkIn->booking->guest->phone ?? 'No phone' }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="align-middle">
                                        <div>
                                            @foreach($checkIn->booking->bookingDetails as $detail)
                                                <span class="badge badge-primary mb-1 d-inline-block">
                                                    {{ $detail->room->room_number }} - {{ $detail->room->typeRoom->name ?? 'N/A' }}
                                                </span>
                                            @endforeach
                                        </div>
                                    </td>
                                    <td class="align-middle">
                                        <div>
                                            <div class="text-dark">{{ \Carbon\Carbon::parse($checkIn->check_in_time)->format('d M Y') }}</div>
                                            <small class="text-muted">{{ \Carbon\Carbon::parse($checkIn->check_in_time)->format('H:i') }}</small>
                                        </div>
                                    </td>
                                    <td class="align-middle">
                                        @if($checkIn->booking->status === 'checked_in')
                                            <span class="badge badge-success d-flex align-items-center" style="width: fit-content;">
                                                <span class="badge-dot bg-white mr-1"></span>
                                                Active
                                            </span>
                                        @elseif($checkIn->booking->status === 'checked_out')
                                            <span class="badge badge-secondary d-flex align-items-center" style="width: fit-content;">
                                                <span class="badge-dot bg-white mr-1"></span>
                                                Checked Out
                                            </span>
                                        @else
                                            <span class="badge badge-danger d-flex align-items-center" style="width: fit-content;">
                                                <span class="badge-dot bg-white mr-1"></span>
                                                {{ ucfirst($checkIn->booking->status) }}
                                            </span>
                                        @endif
                                    </td>
                                    {{-- <td class="align-middle text-right">
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('checkins.show', $checkIn) }}" 
                                               class="btn btn-sm btn-outline-primary"
                                               data-toggle="tooltip" 
                                               title="Lihat Detail">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('checkins.edit', $checkIn) }}" 
                                               class="btn btn-sm btn-outline-warning"
                                               data-toggle="tooltip" 
                                               title="Edit Check-in">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        </div>
                                    </td> --}}
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Enhanced Pagination -->
            @if($checkIns->hasPages())
                <div class="card-footer bg-white border-top">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <small class="text-muted">
                                Menampilkan {{ $checkIns->firstItem() }} sampai {{ $checkIns->lastItem() }} dari {{ $checkIns->total() }} check-in
                            </small>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex justify-content-md-end">
                                {{ $checkIns->appends(request()->query())->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        @else
            <div class="card-body text-center py-5">
                <div class="mb-4">
                    @if(request('search') || request('status') || request('date'))
                        <i class="fas fa-search fa-3x text-muted"></i>
                    @else
                        <i class="fas fa-clipboard-list fa-3x text-muted"></i>
                    @endif
                </div>
                <h5 class="text-muted font-weight-semibold">
                    @if(request('search') || request('status') || request('date'))
                        Tidak ada hasil ditemukan
                    @else
                        Belum ada check-in
                    @endif
                </h5>
                <p class="text-muted mb-4">
                    @if(request('search') || request('status') || request('date'))
                        Coba ubah kata kunci pencarian atau filter yang digunakan.
                    @else
                        Mulai dengan melakukan check-in tamu baru.
                    @endif
                </p>
                @if(request('search') || request('status') || request('date'))
                    <a href="{{ route('checkins.index') }}" class="btn btn-outline-primary mr-2">
                        <i class="fas fa-times mr-2"></i>
                        Reset Filter
                    </a>
                @endif
                <a href="{{ route('checkins.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus mr-2"></i>
                    Check-in Baru
                </a>
            </div>
        @endif
    </div>
</div>

<style>
.badge-dot {
    width: 6px;
    height: 6px;
    border-radius: 50%;
    display: inline-block;
}

.avatar {
    font-size: 0.75rem;
}

.card {
    transition: all 0.3s ease;
}

.card:hover {
    transform: translateY(-2px);
}

.table td {
    border-top: 1px solid #f1f3f4;
    padding: 1rem 0.75rem;
}

.table thead th {
    border-bottom: 2px solid #f1f3f4;
    font-size: 0.75rem;
    letter-spacing: 0.05em;
    padding: 1rem 0.75rem;
}

.btn-group .btn {
    border-radius: 0.375rem;
    margin-right: 0.25rem;
}

.btn-group .btn:last-child {
    margin-right: 0;
}

.input-group-text {
    border-color: #e9ecef;
}

.form-control:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}

.dropdown-item.active {
    background-color: #007bff;
    color: white;
}

.dropdown-item:hover {
    background-color: #f8f9fa;
}

.badge {
    font-size: 0.75rem;
}

/* Row hover effect */
.table-hover tbody tr:hover {
    background-color: rgba(0, 123, 255, 0.05);
}

/* Responsive improvements */
@media (max-width: 768px) {
    .d-flex.justify-content-md-end {
        flex-direction: column;
        align-items: stretch;
    }
    
    .input-group {
        margin-bottom: 1rem;
        max-width: 100% !important;
    }
    
    .dropdown {
        margin-bottom: 1rem;
    }
    
    .btn-group {
        flex-direction: column;
    }
    
    .btn-group .btn {
        margin-right: 0;
        margin-bottom: 0.25rem;
        border-radius: 0.375rem !important;
    }
    
    .btn-group .btn:last-child {
        margin-bottom: 0;
    }
    
    .table-responsive {
        font-size: 0.875rem;
    }
}

/* Animation for status badges */
.badge {
    transition: all 0.2s ease;
}

.badge:hover {
    transform: scale(1.05);
}

/* Improved pagination */
.pagination {
    margin-bottom: 0;
}

.page-link {
    border-radius: 0.375rem;
    margin: 0 0.125rem;
    border: 1px solid #dee2e6;
}

.page-link:hover {
    background-color: #e9ecef;
    border-color: #adb5bd;
}

.page-item.active .page-link {
    background-color: #007bff;
    border-color: #007bff;
}

/* Filter badges animation */
.badge {
    animation: fadeInUp 0.3s ease;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Enhanced button styles */
.btn {
    font-weight: 500;
    letter-spacing: 0.025em;
}

.btn-sm {
    font-size: 0.8rem;
    padding: 0.375rem 0.75rem;
}

/* Focus styles */
.btn:focus,
.form-control:focus,
.dropdown-toggle:focus {
    outline: none;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}

/* Custom alert styles */
.alert {
    border: none;
    border-radius: 0.5rem;
    font-weight: 500;
}

.alert-success {
    background-color: #d1ecf1;
    color: #0c5460;
}

.alert-danger {
    background-color: #f8d7da;
    color: #721c24;
}

/* Badge counter in filter button */
.badge-sm {
    font-size: 0.6rem;
    padding: 0.2rem 0.4rem;
}
</style>
@push('scripts')
    

<script>
$(document).ready(function() {
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();

    // Auto submit search form with delay
    let searchTimeout;
    $('#searchInput').on('input', function() {
        clearTimeout(searchTimeout);
        const searchValue = $(this).val();
        
        searchTimeout = setTimeout(function() {
            if (searchValue.length >= 3 || searchValue.length === 0) {
                $('#searchInput').closest('form').submit();
            }
        }, 800);
    });

    // Highlight search terms
    const searchTerm = '{{ request("search") }}';
    if (searchTerm && searchTerm.length >= 3) {
        highlightSearchTerms(searchTerm);
    }

    function highlightSearchTerms(term) {
        const searchRegex = new RegExp(`(${escapeRegExp(term)})`, 'gi');
        
        $('.checkin-row').each(function() {
            const row = $(this);
            
            // Only highlight in specific columns (not action buttons)
            row.find('td:lt(5)').each(function() {
                const cell = $(this);
                const originalHtml = cell.html();
                
                // Skip if cell contains HTML elements we want to preserve
                if (cell.find('.badge, .avatar').length === 0) {
                    const highlightedHtml = originalHtml.replace(searchRegex, '<mark class="bg-warning">$1</mark>');
                    cell.html(highlightedHtml);
                }
            });
        });
    }

    function escapeRegExp(string) {
        return string.replace(/[.*+?^${}()|[\]\\]/g, '\\                        <a class="dropdown-item {{ request('sort') === 'booking_id' ? 'active' : '' }}" 
                           href="{{ route('checkins.index', array_merge(request()->all(), ['sort');
    }

    // Add search input loading indicator
    const style = $(`
        <style>
            mark.bg-warning {
                background-color: #fff3cd !important;
                padding: 0.1rem 0.2rem;
                border-radius: 0.2rem;
            }
        </style>
    `);
    $('head').append(style);
});
</script>
@endpush
@endsection