@extends('layouts.app')

@section('title', 'Detail Check-in #' . $checkIn->id)

@section('content')
<div class="container-fluid py-4" style="background-color: #f8f9fa; min-height: 100vh;">
    <!-- Header Section -->
    @dd($checkIn)
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="d-flex align-items-center">
                        <a href="{{ route('checkins.index') }}" 
                           class="btn btn-light border mr-3 d-flex align-items-center justify-content-center" 
                           style="width: 40px; height: 40px;">
                            <i class="fas fa-arrow-left"></i>
                        </a>
                        <div>
                            <h2 class="mb-1 font-weight-bold text-dark">Detail Check-in</h2>
                            <p class="text-muted mb-0">Booking #{{ $checkIn->booking->id }}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="d-flex justify-content-md-end align-items-center">
                        @if($checkIn->booking->status === 'checked_in')
                            <span class="badge badge-success badge-lg mr-3 d-flex align-items-center">
                                <span class="badge-dot bg-white mr-2"></span>
                                Tamu Aktif
                            </span>
                        @elseif($checkIn->booking->status === 'checked_out')
                            <span class="badge badge-secondary badge-lg mr-3 d-flex align-items-center">
                                <span class="badge-dot bg-white mr-2"></span>
                                Sudah Check-out
                            </span>
                        @endif
                        <a href="{{ route('checkins.edit', $checkIn) }}" 
                           class="btn btn-primary d-flex align-items-center">
                            <i class="fas fa-edit mr-2"></i>
                            Edit
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Alert Messages -->
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show d-flex align-items-center" role="alert">
            <i class="fas fa-check-circle mr-3"></i>
            <span>{{ session('success') }}</span>
            <button type="button" class="close" data-dismiss="alert">
                <span>&times;</span>
            </button>
        </div>
    @endif

    <!-- Main Content -->
    <div class="row">
        <!-- Left Column - Main Info -->
        <div class="col-lg-8">
            <!-- Guest Information -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex align-items-center">
                        <div class="bg-primary rounded p-2 mr-3">
                            <i class="fas fa-user fa-lg text-white"></i>
                        </div>
                        <h5 class="mb-0 font-weight-semibold">Informasi Tamu</h5>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-4">
                                <label class="text-muted small font-weight-medium d-block mb-1">Nama Lengkap</label>
                                <p class="text-dark font-weight-semibold h6 mb-0">{{ $checkIn->booking->guest->name }}</p>
                            </div>
                            <div class="mb-4">
                                <label class="text-muted small font-weight-medium d-block mb-1">Nomor Identitas</label>
                                <p class="text-dark mb-0">{{ $checkIn->booking->guest->identity_number ?? '-' }}</p>
                            </div>
                            <div class="mb-4">
                                <label class="text-muted small font-weight-medium d-block mb-1">Email</label>
                                <p class="text-dark mb-0">{{ $checkIn->booking->guest->email ?? '-' }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-4">
                                <label class="text-muted small font-weight-medium d-block mb-1">Nomor Telepon</label>
                                <p class="text-dark mb-0">{{ $checkIn->booking->guest->phone ?? '-' }}</p>
                            </div>
                            <div class="mb-4">
                                <label class="text-muted small font-weight-medium d-block mb-1">Tipe Identitas</label>
                                <p class="text-dark mb-0">{{ $checkIn->booking->guest->identity_type ?? '-' }}</p>
                            </div>
                            <div class="mb-4">
                                <label class="text-muted small font-weight-medium d-block mb-1">Alamat</label>
                                <p class="text-dark mb-0">{{ $checkIn->booking->guest->address ?? '-' }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Room Information -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex align-items-center">
                        <div class="bg-info rounded p-2 mr-3">
                            <i class="fas fa-bed fa-lg text-white"></i>
                        </div>
                        <h5 class="mb-0 font-weight-semibold">Informasi Kamar</h5>
                    </div>
                </div>
                <div class="card-body">
                    @foreach($checkIn->booking->bookingDetails as $detail)
                        <div class="border border-light rounded p-4 mb-3">
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label class="text-muted small font-weight-medium d-block mb-1">Nomor Kamar</label>
                                    <span class="badge badge-primary badge-lg">{{ $detail->room->room_number }}</span>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="text-muted small font-weight-medium d-block mb-1">Tipe Kamar</label>
                                    <p class="text-dark font-weight-semibold mb-0">{{ $detail->room->typeRoom->name ?? 'N/A' }}</p>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="text-muted small font-weight-medium d-block mb-1">Jumlah Malam</label>
                                    <p class="text-dark mb-0">{{ $detail->nights }} malam</p>
                                </div>
                            </div>
                            <hr class="my-3">
                            <div class="row">
                                <div class="col-md-3 col-6 mb-2">
                                    <small class="text-muted d-block">Harga Kamar</small>
                                    <span class="font-weight-semibold text-dark">Rp {{ number_format($detail->room_price, 0, ',', '.') }}</span>
                                </div>
                                <div class="col-md-3 col-6 mb-2">
                                    <small class="text-muted d-block">PPN ({{ $detail->ppn_rate * 100 }}%)</small>
                                    <span class="font-weight-semibold text-dark">Rp {{ number_format($detail->ppn_amount, 0, ',', '.') }}</span>
                                </div>
                                <div class="col-md-3 col-6 mb-2">
                                    <small class="text-muted d-block">Total</small>
                                    <span class="font-weight-semibold text-dark">Rp {{ number_format($detail->grand_total, 0, ',', '.') }}</span>
                                </div>
                                <div class="col-md-3 col-6 mb-2">
                                    <small class="text-muted d-block">Status Kamar</small>
                                    <span class="font-weight-semibold {{ $detail->room->status === 'occupied' ? 'text-danger' : 'text-success' }}">
                                        {{ ucfirst($detail->room->status) }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Notes Section -->
            @if($checkIn->notes)
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <div class="d-flex align-items-center">
                            <div class="bg-warning rounded p-2 mr-3">
                                <i class="fas fa-sticky-note fa-lg text-white"></i>
                            </div>
                            <h5 class="mb-0 font-weight-semibold">Catatan Check-in</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <p class="text-dark mb-0">{{ $checkIn->notes }}</p>
                    </div>
                </div>
            @endif
        </div>

        <!-- Right Column - Summary -->
        <div class="col-lg-4">
            <!-- Check-in Summary -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 font-weight-semibold">Ringkasan Check-in</h5>
                </div>
                <div class="card-body">
                    <div class="mb-4">
                        <label class="text-muted small font-weight-medium d-block mb-1">Waktu Check-in</label>
                        <div class="d-flex align-items-center">
                            <i class="fas fa-calendar-alt text-primary mr-2"></i>
                            <div>
                                <p class="text-dark font-weight-semibold mb-0">
                                    {{ \Carbon\Carbon::parse($checkIn->check_in_time)->format('d F Y') }}
                                </p>
                                <small class="text-muted">{{ \Carbon\Carbon::parse($checkIn->check_in_time)->format('H:i') }} WIB</small>
                            </div>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="text-muted small font-weight-medium d-block mb-1">Periode Menginap</label>
                        <div class="d-flex align-items-center">
                            <i class="fas fa-moon text-primary mr-2"></i>
                            <div>
                                <p class="text-dark font-weight-semibold mb-0">
                                    {{ \Carbon\Carbon::parse($checkIn->booking->check_in_date)->format('d M') }} - 
                                    {{ \Carbon\Carbon::parse($checkIn->booking->check_out_date)->format('d M Y') }}
                                </p>
                                <small class="text-muted">
                                    {{ \Carbon\Carbon::parse($checkIn->booking->check_in_date)->diffInDays(\Carbon\Carbon::parse($checkIn->booking->check_out_date)) }} malam
                                </small>
                            </div>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="text-muted small font-weight-medium d-block mb-1">Status Booking</label>
                        <div class="d-flex align-items-center">
                            <i class="fas fa-info-circle text-primary mr-2"></i>
                            @if($checkIn->booking->status === 'checked_in')
                                <span class="badge badge-success">Checked In</span>
                            @elseif($checkIn->booking->status === 'checked_out')
                                <span class="badge badge-secondary">Checked Out</span>
                            @else
                                <span class="badge badge-warning">{{ ucfirst($checkIn->booking->status) }}</span>
                            @endif
                        </div>
                    </div>

                    @if($checkIn->createdBy)
                        <div class="mb-4">
                            <label class="text-muted small font-weight-medium d-block mb-1">Dibuat Oleh</label>
                            <div class="d-flex align-items-center">
                                <i class="fas fa-user-tie text-primary mr-2"></i>
                                <div>
                                    <p class="text-dark font-weight-semibold mb-0">{{ $checkIn->createdBy->name }}</p>
                                    <small class="text-muted">{{ \Carbon\Carbon::parse($checkIn->created_at)->format('d M Y H:i') }}</small>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 font-weight-semibold">Aksi Cepat</h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('checkins.edit', $checkIn) }}" class="btn btn-outline-primary btn-block mb-2">
                            <i class="fas fa-edit mr-2"></i>
                            Edit Check-in
                        </a>
                        
                        @if($checkIn->booking->status === 'checked_in')
                            <button type="button" class="btn btn-outline-success btn-block mb-2" data-toggle="modal" data-target="#checkoutModal">
                                <i class="fas fa-sign-out-alt mr-2"></i>
                                Proses Check-out
                            </button>
                        @endif

                        <a href="{{ route('bookings.show', $checkIn->booking->id) }}" class="btn btn-outline-info btn-block mb-2">
                            <i class="fas fa-eye mr-2"></i>
                            Lihat Booking
                        </a>

                        <button type="button" class="btn btn-outline-warning btn-block mb-2" onclick="window.print()">
                            <i class="fas fa-print mr-2"></i>
                            Cetak Detail
                        </button>

                        <a href="{{ route('checkins.index') }}" class="btn btn-outline-secondary btn-block">
                            <i class="fas fa-list mr-2"></i>
                            Kembali ke Daftar
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Check-out Modal -->
<div class="modal fade" id="checkoutModal" tabindex="-1" role="dialog" aria-labelledby="checkoutModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="checkoutModalLabel">Konfirmasi Check-out</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin melakukan check-out untuk tamu <strong>{{ $checkIn->booking->guest->name }}</strong>?</p>
                <p class="text-muted small">Aksi ini akan mengubah status booking menjadi "checked out" dan menandai kamar sebagai tersedia untuk dibersihkan.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                <form action="{{ route('checkouts.store') }}" method="POST" class="d-inline">
                    @csrf
                    <input type="hidden" name="booking_id" value="{{ $checkIn->booking->id }}">
                    <button type="submit" class="btn btn-success">Ya, Check-out</button>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.badge-dot {
    width: 6px;
    height: 6px;
    border-radius: 50%;
    display: inline-block;
}

.badge-lg {
    padding: 0.5rem 0.75rem;
    font-size: 0.875rem;
}

.card {
    transition: all 0.3s ease;
}

.card:hover {
    transform: translateY(-2px);
}

.d-grid .btn {
    border-radius: 0.375rem;
}

.bg-light {
    background-color: #f8f9fa !important;
}

.border-light {
    border-color: #f1f3f4 !important;
}

.text-dark {
    color: #212529 !important;
}

.font-weight-semibold {
    font-weight: 600 !important;
}

.btn:focus {
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}

.btn-outline-primary:hover {
    color: #fff;
    background-color: #007bff;
    border-color: #007bff;
}

.btn-outline-success:hover {
    color: #fff;
    background-color: #28a745;
    border-color: #28a745;
}

.btn-outline-info:hover {
    color: #fff;
    background-color: #17a2b8;
    border-color: #17a2b8;
}

.btn-outline-warning:hover {
    color: #fff;
    background-color: #ffc107;
    border-color: #ffc107;
}

.card-header {
    padding: 1rem 1.5rem;
}

.card-body {
    padding: 1.5rem;
}

@media (max-width: 768px) {
    .d-grid .btn {
        margin-bottom: 0.5rem;
    }
    
    .badge-lg {
        padding: 0.375rem 0.5rem;
        font-size: 0.75rem;
    }
}

</style>
@endsection