{{-- File: resources/views/guests/create.blade.php --}}

@extends('admin-layouts.master')

@section('content')
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">


    </div>

    <div class="row justify-content-center">
        <div class="col-lg-8">
            <!-- Form Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-user-plus"></i> Form Tambah Tamu Baru
                    </h6>
                </div>
                <div class="card-body">
                    <form id="guestForm" method="POST" action="{{ route('guests.store') }}">
                        @csrf

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">Nama Lengkap <span class="text-danger">*</span></label>
                                    <input type="text"
                                           class="form-control @error('name') is-invalid @enderror"
                                           id="name"
                                           name="name"
                                           value="{{ old('name') }}"
                                           required
                                           placeholder="Masukkan nama lengkap">
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="identity_number">No. Identitas (KTP/Passport)</label>
                                    <input type="text"
                                           class="form-control @error('identity_number') is-invalid @enderror"
                                           id="identity_number"
                                           name="identity_number"
                                           value="{{ old('identity_number') }}"
                                           placeholder="Contoh: 3201234567890001">
                                    @error('identity_number')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">Opsional - untuk identifikasi tamu</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="gender">Jenis Kelamin</label>
                                    <select class="form-control @error('gender') is-invalid @enderror"
                                            id="gender"
                                            name="gender">
                                        <option value="">Pilih jenis kelamin</option>
                                        <option value="L" {{ old('gender') == 'L' ? 'selected' : '' }}>Laki-laki</option>
                                        <option value="P" {{ old('gender') == 'P' ? 'selected' : '' }}>Perempuan</option>
                                    </select>
                                    @error('gender')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="birth_date">Tanggal Lahir</label>
                                    <input type="date"
                                           class="form-control @error('birth_date') is-invalid @enderror"
                                           id="birth_date"
                                           name="birth_date"
                                           value="{{ old('birth_date') }}"
                                           max="{{ date('Y-m-d') }}">
                                    @error('birth_date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">Format: DD/MM/YYYY</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="phone">No. Telepon</label>
                                    <input type="text"
                                           class="form-control @error('phone') is-invalid @enderror"
                                           id="phone"
                                           name="phone"
                                           value="{{ old('phone') }}"
                                           placeholder="Contoh: 08123456789">
                                    @error('phone')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email">Email</label>
                                    <input type="email"
                                           class="form-control @error('email') is-invalid @enderror"
                                           id="email"
                                           name="email"
                                           value="{{ old('email') }}"
                                           placeholder="contoh@email.com">
                                    @error('email')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="address">Alamat</label>
                            <textarea class="form-control @error('address') is-invalid @enderror"
                                      id="address"
                                      name="address"
                                      rows="3"
                                      placeholder="Masukkan alamat lengkap...">{{ old('address') }}</textarea>
                            @error('address')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <hr>

                        <div class="form-group mb-0">
                            <div class="d-flex justify-content-between">
                                <a href="{{ route('guests.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> Batal
                                </a>

                                <div>
                                    <button type="submit" class="btn btn-primary mr-2" id="saveBtn">
                                        <i class="fas fa-save"></i> Simpan
                                    </button>

                                    <button type="submit" class="btn btn-success" id="saveAndBookBtn" name="action" value="save_and_book">
                                        <i class="fas fa-calendar-plus"></i> Simpan & Buat Booking
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Info Card -->
            <div class="card border-left-info shadow mb-4">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                <i class="fas fa-info-circle"></i> Informasi
                            </div>
                            <div class="text-info">
                                <ul class="mb-0">
                                    <li>Field yang bertanda <span class="text-danger">*</span> wajib diisi</li>
                                    <li>Nomor telepon dan email akan digunakan untuk komunikasi</li>
                                    <li>Data identitas membantu proses check-in yang lebih cepat</li>
                                    <li>Jenis kelamin dan tanggal lahir membantu identifikasi tamu</li>
                                    <li>Setelah menyimpan, Anda dapat langsung membuat booking untuk tamu ini</li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-plus fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
$(document).ready(function() {
    // Format phone number input
    $('#phone').on('input', function() {
        let value = $(this).val();
        // Allow only numbers, +, -, and spaces
        value = value.replace(/[^\d+\-\s]/g, '');
        $(this).val(value);
    });

    // Format identity number input
    $('#identity_number').on('input', function() {
        let value = $(this).val();
        // Allow only alphanumeric characters
        value = value.replace(/[^a-zA-Z0-9]/g, '');
        $(this).val(value);
    });

    // Birth date validation - tidak boleh tanggal masa depan
    $('#birth_date').on('change', function() {
        const selectedDate = new Date($(this).val());
        const today = new Date();
        today.setHours(0, 0, 0, 0);

        if (selectedDate > today) {
            Swal.fire({
                icon: 'warning',
                title: 'Peringatan!',
                text: 'Tanggal lahir tidak boleh di masa depan.',
                timer: 3000
            });
            $(this).val('');
        }
    });

    // Handle form submission
   $('#guestForm').on('submit', function(e) {
    e.preventDefault();

    const formData = new FormData(this);
    const action = e.originalEvent.submitter.value;
    const isBookingAction = action === 'save_and_book';

    // Show loading
    const submitBtn = $(e.originalEvent.submitter);
    const originalText = submitBtn.html();
    submitBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Menyimpan...');

    // Clear previous errors
    $('.form-control').removeClass('is-invalid');
    $('.invalid-feedback').remove();

    $.ajax({
        url: $(this).attr('action'),
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(response) {
            if (response.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil!',
                    text: response.message || 'Data tamu berhasil disimpan',
                    timer: 2000,
                    showConfirmButton: false
                }).then(() => {
                    // Gunakan redirect_url yang dikembalikan dari server
                    if (response.redirect_url) {
                        window.location.href = response.redirect_url;
                    } else {
                        // Fallback jika redirect_url tidak ada
                        if (isBookingAction && response.data && response.data.id) {
                            window.location.href = '/bookings/create?guest_id=' + response.data.id;
                        } else {
                            window.location.href = '/guests';
                        }
                    }
                });
            } else {
                // Handle case where success is false
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: response.message || 'Terjadi kesalahan saat menyimpan data.'
                });
            }
        },
        error: function(xhr) {
            console.log('Error response:', xhr.responseJSON); // Debug log

            if (xhr.status === 422) {
                // Validation errors
                const response = xhr.responseJSON;
                if (response && response.errors) {
                    const errors = response.errors;
                    Object.keys(errors).forEach(function(key) {
                        const field = $(`#${key}, [name="${key}"]`); // Coba dengan ID atau name
                        if (field.length > 0) {
                            field.addClass('is-invalid');
                            // Hapus error feedback yang sudah ada sebelumnya
                            field.siblings('.invalid-feedback').remove();
                            field.after(`<div class="invalid-feedback">${errors[key][0]}</div>`);
                        }
                    });

                    Swal.fire({
                        icon: 'error',
                        title: 'Validasi Error!',
                        text: response.message || 'Silakan periksa form Anda.',
                        timer: 3000
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Validasi Error!',
                        text: 'Format response tidak valid'
                    });
                }
            } else if (xhr.status === 500) {
                const response = xhr.responseJSON;
                Swal.fire({
                    icon: 'error',
                    title: 'Server Error!',
                    text: response?.message || 'Terjadi kesalahan pada server.'
                });
            } else {
                const response = xhr.responseJSON;
                const message = response?.message || 'Terjadi kesalahan saat menyimpan data.';
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: message
                });
            }
        },
        complete: function() {
            submitBtn.prop('disabled', false).html(originalText);
        }
    });
});
});

// Handle success messages from server (if not using AJAX)
@if(session('success'))
    Swal.fire({
        title: 'Berhasil!',
        text: '{{ session("success") }}',
        icon: 'success',
        timer: 3000,
        showConfirmButton: false
    });
@endif

@if(session('error'))
    Swal.fire({
        title: 'Error!',
        text: '{{ session("error") }}',
        icon: 'error'
    });
@endif
</script>
@endpush
