@extends('admin-layouts.master')

@section('title', 'Housekeeping Management')

@section('content')
<style>
/* Custom CSS untuk memastikan button group bekerja dengan baik */
.btn-toolbar .btn-group:not(:last-child) {
    margin-right: 0.5rem;
}

.btn-group-sm > .btn {
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
    line-height: 1.5;
    border-radius: 0.2rem;
}

.btn-group > .btn:not(:last-child):not(.dropdown-toggle) {
    border-top-right-radius: 0;
    border-bottom-right-radius: 0;
}

.btn-group > .btn:not(:first-child) {
    border-top-left-radius: 0;
    border-bottom-left-radius: 0;
    margin-left: -1px;
}

.dropdown-menu {
    min-width: 160px;
    z-index: 1000;
}

.dropdown-item {
    padding: 0.375rem 1rem;
    clear: both;
    font-weight: 400;
    color: #212529;
    text-align: inherit;
    white-space: nowrap;
    background-color: transparent;
    border: 0;
}

.dropdown-item:hover,
.dropdown-item:focus {
    color: #16181b;
    text-decoration: none;
    background-color: #f8f9fa;
}

.dropdown-item.text-danger:hover,
.dropdown-item.text-danger:focus {
    color: #721c24;
    background-color: #f5c6cb;
}

/* Fix untuk tooltip conflict dengan dropdown */
.btn[data-toggle="tooltip"][data-toggle="dropdown"] {
    data-toggle: dropdown;
}
</style>

<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="mb-0">
                    <i class="fas fa-broom text-primary"></i>
                    Housekeeping Management
                </h2>
                <a href="{{ route('housekeeping.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Tambah Task
                </a>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-clock fa-2x mr-3"></i>
                        <div>
                            <h5 class="card-title mb-0">{{ $stats['pending'] }}</h5>
                            <small>Pending Tasks</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-play fa-2x mr-3"></i>
                        <div>
                            <h5 class="card-title mb-0">{{ $stats['in_progress'] }}</h5>
                            <small>In Progress</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-check fa-2x mr-3"></i>
                        <div>
                            <h5 class="card-title mb-0">{{ $stats['completed'] }}</h5>
                            <small>Completed</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-exclamation-triangle fa-2x mr-3"></i>
                        <div>
                            <h5 class="card-title mb-0">{{ $stats['urgent'] }}</h5>
                            <small>Urgent Tasks</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('housekeeping.index') }}" id="filterForm">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-control">
                            <option value="">Semua Status</option>
                            <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>In Progress</option>
                            <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Priority</label>
                        <select name="priority" class="form-control">
                            <option value="">Semua Priority</option>
                            <option value="low" {{ request('priority') == 'low' ? 'selected' : '' }}>Low</option>
                            <option value="normal" {{ request('priority') == 'normal' ? 'selected' : '' }}>Normal</option>
                            <option value="high" {{ request('priority') == 'high' ? 'selected' : '' }}>High</option>
                            <option value="urgent" {{ request('priority') == 'urgent' ? 'selected' : '' }}>Urgent</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Task Type</label>
                        <select name="task_type" class="form-control">
                            <option value="">Semua Type</option>
                            <option value="checkout_cleaning" {{ request('task_type') == 'checkout_cleaning' ? 'selected' : '' }}>Checkout Cleaning</option>
                            <option value="maintenance" {{ request('task_type') == 'maintenance' ? 'selected' : '' }}>Maintenance</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Tanggal</label>
                        <input type="date" name="date" class="form-control" value="{{ request('date') }}">
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search"></i> Filter
                        </button>
                        <a href="{{ route('housekeeping.index') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-times"></i> Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Tasks Table -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Daftar Housekeeping Tasks</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="thead-light">
                        <tr>
                            <th width="8%">Room</th>
                            <th width="12%">Task Type</th>
                            <th width="10%">Priority</th>
                            <th width="10%">Status</th>
                            <th width="15%">Guest/Booking</th>
                            <th width="12%">Assigned To</th>
                            <th width="10%">Due Time</th>
                            <th width="8%">Duration</th>
                            <th width="15%">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($tasks as $task)
                        <tr class="{{ $task->is_overdue ? 'table-danger' : '' }}">
                            <td>
                                <strong>{{ $task->room->room_number ?? '-' }}</strong>
                                @if($task->is_overdue)
                                    <br><small class="text-danger"><i class="fas fa-clock"></i> Overdue</small>
                                @endif
                            </td>
                            <td>
                                <span class="badge badge-light">
                                    {{ $task->task_type_display }}
                                </span>
                            </td>
                            <td>
                                <span class="badge {{ $task->priority_badge }} text-white">
                                    {{ ucfirst($task->priority) }}
                                </span>
                            </td>
                            <td>
                                <span class="badge {{ $task->status_badge }} text-white" id="status-badge-{{ $task->id }}">
                                    {{ ucfirst(str_replace('_', ' ', $task->status)) }}
                                </span>
                            </td>
                            <td>
                                @if($task->booking && $task->booking->guest)
                                    <div>
                                        <strong>{{ $task->booking->guest->name }}</strong>
                                        <br><small class="text-muted">#{{ $task->booking->id }}</small>
                                    </div>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                @if($task->assignedUser)
                                    <div>
                                        <strong>{{ $task->assignedUser->name }}</strong>
                                        <br><small class="text-muted">{{ $task->assigned_at?->format('d/m H:i') }}</small>
                                    </div>
                                @else
                                    <span class="text-muted">Unassigned</span>
                                @endif
                            </td>
                            <td>
                                @if($task->due_time)
                                    <div>
                                        {{ $task->due_time->format('d/m/Y') }}
                                        <br><small>{{ $task->due_time->format('H:i') }}</small>
                                    </div>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                {{ $task->duration_formatted }}
                            </td>
                            <td>
                                {{-- Quick Actions --}}
                                <button class="btn btn-sm btn-info" onclick="updateStatus({{ $task->id }}, 'in_progress')" title="Start Task">
                                    <i class="fas fa-play"></i>
                                </button>

                                <button class="btn btn-sm btn-success" onclick="updateStatus({{ $task->id }}, 'completed')" title="Complete Task">
                                    <i class="fas fa-check"></i>
                                </button>

                                <button class="btn btn-sm btn-secondary" onclick="updateStatus({{ $task->id }}, 'cancelled')" title="Cancel Task">
                                    <i class="fas fa-times"></i>
                                </button>
                            {{-- More Actions as individual buttons --}}
                            <button class="btn btn-sm btn-outline-secondary" onclick="window.location.href='{{ route('housekeeping.show', $task->id) }}'" title="Detail">
                                <i class="fas fa-eye"></i>
                            </button>

                            <button class="btn btn-sm btn-outline-secondary" onclick="window.location.href='{{ route('housekeeping.edit', $task->id) }}'" title="Edit">
                                <i class="fas fa-edit"></i>
                            </button>

                            @if(!$task->assignedUser)
                                <button class="btn btn-sm btn-outline-secondary" onclick="showAssignModal({{ $task->id }})" title="Assign Staff">
                                    <i class="fas fa-user-plus"></i>
                                </button>
                            @endif

                            <button class="btn btn-sm btn-outline-danger" onclick="deleteTask({{ $task->id }})" title="Delete">
                                <i class="fas fa-trash"></i>
                            </button>



                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="9" class="text-center py-4">
                                <div class="text-muted">
                                    <i class="fas fa-broom fa-3x mb-3"></i>
                                    <p>Tidak ada task housekeeping yang ditemukan</p>
                                </div>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($tasks->hasPages())
        <div class="card-footer">
            {{ $tasks->links() }}
        </div>
        @endif
    </div>
</div>

<!-- Assign Staff Modal -->
<div class="modal fade" id="assignModal" tabindex="-1" role="dialog" aria-labelledby="assignModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form id="assignForm">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="assignModalLabel">Assign Staff</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="assigned_to" class="form-label">Pilih Staff</label>
                        <select class="form-control" id="assigned_to" name="assigned_to" required>
                            <option value="">Pilih Staff...</option>
                            @foreach($users as $user)
                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Assign</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Alert Container -->
<div id="alertContainer" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;"></div>

@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
let currentTaskId = null;

// Auto refresh notifications every 30 seconds
setInterval(function() {
    loadNotifications();
}, 30000);

// Load notifications on page load
$(document).ready(function() {
    loadNotifications();
    
    // Initialize tooltips
     $('[data-toggle="tooltip"]').tooltip({
        container: 'body',
        placement: 'top'
    });
    
    // Fix tooltip conflict dengan dropdown
    $('.dropdown-toggle[data-toggle="tooltip"]').on('show.bs.tooltip', function() {
        if ($(this).hasClass('show')) {
            return false;
        }
    });
    
    // Hide tooltip when dropdown is shown
    $('.dropdown-toggle').on('show.bs.dropdown', function() {
        $(this).tooltip('hide');
    });
});

function loadNotifications() {
    $.get('{{ route("housekeeping.getNotifications") }}', function(data) {
        updateNotificationBadge(data.total_urgent + data.total_overdue);
    }).fail(function() {
        console.log('Failed to load notifications');
    });
}

function updateNotificationBadge(count) {
    const badge = document.getElementById('housekeeping-notification-badge');
    if (badge) {
        if (count > 0) {
            badge.textContent = count;
            badge.style.display = 'inline';
        } else {
            badge.style.display = 'none';
        }
    }
}

function updateStatus(taskId, status) {
    Swal.fire({
        title: 'Konfirmasi',
        text: 'Apakah Anda yakin ingin mengubah status task ini?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, Ubah!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: '/housekeeping/' + taskId + '/update-status',
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    status: status
                },
                beforeSend: function() {
                    Swal.fire({
                        title: 'Processing...',
                        allowOutsideClick: false,
                        didOpen: () => {
                            Swal.showLoading()
                        }
                    });
                },
                success: function(response) {
                    if (response.success) {
                        // Update badge status
                        const badge = document.getElementById('status-badge-' + taskId);
                        if (badge) {
                            badge.className = 'badge ' + getStatusBadgeClass(status);
                            badge.textContent = getStatusDisplayText(status);
                        }
                        
                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        });
                        
                        // Refresh page after 2 seconds
                        setTimeout(function() {
                            window.location.reload();
                        }, 2000);
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Gagal!',
                            text: response.message || 'Terjadi kesalahan'
                        });
                    }
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: xhr.responseJSON?.message || 'Terjadi kesalahan saat mengupdate status'
                    });
                }
            });
        }
    });
}

function showAssignModal(taskId) {
    currentTaskId = taskId;
    $('#assignModal').modal('show');
}

$('#assignForm').on('submit', function(e) {
    e.preventDefault();
    
    if (!currentTaskId) {
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: 'Task ID tidak ditemukan'
        });
        return;
    }
    
    const assignedTo = $('#assigned_to').val();
    if (!assignedTo) {
        Swal.fire({
            icon: 'warning',
            title: 'Peringatan!',
            text: 'Pilih staff terlebih dahulu'
        });
        return;
    }
    
    $.ajax({
        url: '/housekeeping/' + currentTaskId + '/assign',
        method: 'POST',
        data: {
            _token: '{{ csrf_token() }}',
            assigned_to: assignedTo
        },
        beforeSend: function() {
            $('#assignModal .btn-primary').prop('disabled', true).text('Processing...');
        },
        success: function(response) {
            if (response.success) {
                $('#assignModal').modal('hide');
                $('#assignForm')[0].reset();
                
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil!',
                    text: response.message,
                    timer: 2000,
                    showConfirmButton: false
                });
                
                setTimeout(function() {
                    window.location.reload();
                }, 2000);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Gagal!',
                    text: response.message || 'Terjadi kesalahan'
                });
            }
        },
        error: function(xhr) {
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: xhr.responseJSON?.message || 'Terjadi kesalahan saat assign task'
            });
        },
        complete: function() {
            $('#assignModal .btn-primary').prop('disabled', false).text('Assign');
        }
    });
});

function deleteTask(taskId) {
    Swal.fire({
        title: 'Hapus Task?',
        text: 'Task yang dihapus tidak dapat dikembalikan!',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Ya, Hapus!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: '/housekeeping/' + taskId,
                method: 'DELETE',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                beforeSend: function() {
                    Swal.fire({
                        title: 'Menghapus...',
                        allowOutsideClick: false,
                        didOpen: () => {
                            Swal.showLoading()
                        }
                    });
                },
                success: function(response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Berhasil!',
                        text: 'Task berhasil dihapus',
                        timer: 2000,
                        showConfirmButton: false
                    });
                    
                    setTimeout(function() {
                        window.location.reload();
                    }, 2000);
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: xhr.responseJSON?.message || 'Terjadi kesalahan saat menghapus task'
                    });
                }
            });
        }
    });
}

function getStatusBadgeClass(status) {
    const badges = {
        'pending': 'badge-warning',
        'in_progress': 'badge-info',
        'completed': 'badge-success',
        'cancelled': 'badge-secondary'
    };
    return badges[status] || 'badge-secondary';
}

function getStatusDisplayText(status) {
    const texts = {
        'pending': 'Pending',
        'in_progress': 'In Progress',
        'completed': 'Completed',
        'cancelled': 'Cancelled'
    };
    return texts[status] || status;
}

// Auto submit form when filter changes
$('#filterForm select, #filterForm input').on('change', function() {
    $('#filterForm').submit();
});

// Hide modal when clicking outside
$('#assignModal').on('hidden.bs.modal', function () {
    $('#assignForm')[0].reset();
    currentTaskId = null;
});
</script>
@endpush