@extends('admin-layouts.master')
@section('title', 'Detail Housekeeping Task')
<style>
/* Minimal Styling */
.card {
    border: none;
    border-radius: 8px;
}

.card-header {
    border-radius: 8px 8px 0 0 !important;
    font-weight: 600;
}

.btn {
    border-radius: 6px;
    font-weight: 500;
}

.badge {
    font-size: 0.75rem;
    padding: 0.35em 0.65em;
}

.alert {
    border-radius: 6px;
}

.shadow-sm {
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075) !important;
}

/* Status indicator */
.status-indicator {
    width: 16px;
    height: 16px;
    border-radius: 50%;
    display: inline-block;
    margin-right: 8px;
}

.status-pending { background-color: #ffc107; }
.status-in_progress { background-color: #17a2b8; }
.status-completed { background-color: #28a745; }
.status-cancelled { background-color: #6c757d; }

/* Priority badges */
.priority-low { background-color: #6c757d; }
.priority-normal { background-color: #17a2b8; }
.priority-high { background-color: #fd7e14; }
.priority-urgent { background-color: #dc3545; }

/* Detail sections */
.detail-item {
    padding: 0.75rem 0;
    border-bottom: 1px solid #e9ecef;
}

.detail-item:last-child {
    border-bottom: none;
}

.detail-label {
    font-weight: 600;
    color: #495057;
    margin-bottom: 0.25rem;
}

.detail-value {
    color: #212529;
}

/* Timeline */
.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline::before {
    content: '';
    position: absolute;
    left: 10px;
    top: 0;
    height: 100%;
    width: 2px;
    background: #dee2e6;
}

.timeline-item {
    position: relative;
    margin-bottom: 1rem;
    background: white;
    padding: 0.75rem;
    border-radius: 6px;
    border-left: 3px solid #dee2e6;
}

.timeline-item.completed {
    border-left-color: #28a745;
}

.timeline-item.current {
    border-left-color: #17a2b8;
    background-color: #f8f9fa;
}

.timeline-icon {
    position: absolute;
    left: -21px;
    top: 0.75rem;
    width: 20px;
    height: 20px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 10px;
    color: white;
}

.timeline-icon.completed { background-color: #28a745; }
.timeline-icon.current { background-color: #17a2b8; }
.timeline-icon.pending { background-color: #dee2e6; color: #6c757d; }

/* Responsive adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 1rem;
    }
    .timeline {
        padding-left: 20px;
    }
    .timeline-icon {
        left: -16px;
        width: 16px;
        height: 16px;
        font-size: 8px;
    }
}
</style>
@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="mb-1">
                <span class="status-indicator status-{{ $task->status }}"></span>
                Housekeeping Task #{{ $task->id }}
            </h4>
            <p class="text-muted mb-0 small">
                Status: 
                <span class="badge badge-{{ $task->status === 'completed' ? 'success' : ($task->status === 'in_progress' ? 'info' : ($task->status === 'cancelled' ? 'secondary' : 'warning')) }}">
                    {{ ucfirst(str_replace('_', ' ', $task->status)) }}
                </span>
                | Priority: 
                <span class="badge priority-{{ $task->priority }} text-white">
                    {{ ucfirst($task->priority) }}
                </span>
                @if($task->is_overdue && $task->status !== 'completed')
                <span class="badge badge-danger ml-1">OVERDUE</span>
                @endif
            </p>
        </div>
        <div>
            @if($task->status !== 'completed' && $task->status !== 'cancelled')
            <div class="btn-group mr-2 mt-3" role="group">
                @if($task->status === 'pending')
                <form action="{{ route('housekeeping.update-status', $task->id) }}" method="POST" class="d-inline">
                    @csrf
                    @method('PATCH')
                    <input type="hidden" name="status" value="in_progress">
                    <button type="submit" class="btn btn-info btn-sm">
                        <i class="fas fa-play"></i> Start Task
                    </button>
                </form>
                @endif
                @if($task->status === 'in_progress')
                <form action="{{ route('housekeeping.update-status', $task->id) }}" method="POST" class="d-inline">
                    @csrf
                    @method('PATCH')
                    <input type="hidden" name="status" value="completed">
                    <button type="submit" class="btn btn-success btn-sm">
                        <i class="fas fa-check"></i> Complete
                    </button>
                </form>
                @endif
            </div>
            @endif
            
            <div class="btn-group" role="group">
                <a href="{{ route('housekeeping.edit', $task->id) }}" class="btn btn-warning btn-sm">
                    <i class="fas fa-edit"></i> Edit
                </a>
                <a href="{{ route('housekeeping.index') }}" class="btn btn-secondary btn-sm">
                    <i class="fas fa-arrow-left"></i> Kembali
                </a>
            </div>
        </div>
    </div>

    <!-- Status Alerts -->
    @if($task->status === 'completed')
    <div class="alert alert-success mb-4">
        <i class="fas fa-check-circle"></i> 
        <strong>Task Completed:</strong> Task ini telah diselesaikan pada {{ $task->completed_at?->format('d/m/Y H:i') }}.
        @if($task->assignedUser)
            Dikerjakan oleh: <strong>{{ $task->assignedUser->name }}</strong>
        @endif
    </div>
    @elseif($task->status === 'cancelled')
    <div class="alert alert-warning mb-4">
        <i class="fas fa-times-circle"></i> 
        <strong>Task Cancelled:</strong> Task ini telah dibatalkan.
        @if($task->notes)
            <br><small>{{ $task->notes }}</small>
        @endif
    </div>
    @elseif($task->is_overdue)
    <div class="alert alert-danger mb-4">
        <i class="fas fa-exclamation-triangle"></i> 
        <strong>Task Overdue:</strong> Task ini melewati batas waktu yang ditentukan!
        Target selesai: {{ $task->due_time?->format('d/m/Y H:i') }}
    </div>
    @elseif($task->status === 'in_progress')
    <div class="alert alert-info mb-4">
        <i class="fas fa-spinner fa-spin"></i> 
        <strong>Task In Progress:</strong> Task sedang dikerjakan
        @if($task->assignedUser)
            oleh <strong>{{ $task->assignedUser->name }}</strong>
        @endif
        @if($task->started_at)
            sejak {{ $task->started_at->format('d/m/Y H:i') }}.
        @endif
    </div>
    @endif

    <div class="row">
        <!-- Main Content -->
        <div class="col-lg-8">
            <!-- Basic Information -->
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-primary text-white">
                    <h6 class="mb-0"><i class="fas fa-info-circle"></i> Informasi Dasar</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="detail-item">
                                <div class="detail-label">Room</div>
                                <div class="detail-value">
                                    <strong>{{ $task->room->room_number }}</strong>
                                    @if($task->room->typeRoom)
                                        - {{ $task->room->typeRoom->name }}
                                    @endif
                                </div>
                            </div>
                            
                            <div class="detail-item">
                                <div class="detail-label">Jenis Task</div>
                                <div class="detail-value">
                                    @switch($task->task_type)
                                        @case('checkout_cleaning')
                                            <i class="fas fa-broom text-info"></i> Pembersihan Checkout
                                            @break
                                        @case('maintenance')
                                            <i class="fas fa-tools text-warning"></i> Maintenance
                                            @break
                                        @case('deep_cleaning')
                                            <i class="fas fa-soap text-primary"></i> Deep Cleaning
                                            @break
                                        @case('inspection')
                                            <i class="fas fa-search text-secondary"></i> Inspeksi
                                            @break
                                        @default
                                            {{ ucfirst(str_replace('_', ' ', $task->task_type)) }}
                                    @endswitch
                                </div>
                            </div>
                            
                            <div class="detail-item">
                                <div class="detail-label">Priority</div>
                                <div class="detail-value">
                                    <span class="badge priority-{{ $task->priority }} text-white">
                                        @if($task->priority === 'urgent')
                                            <i class="fas fa-exclamation-triangle"></i>
                                        @elseif($task->priority === 'high')
                                            <i class="fas fa-arrow-up"></i>
                                        @endif
                                        {{ ucfirst($task->priority) }}
                                    </span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="detail-item">
                                <div class="detail-label">Booking</div>
                                <div class="detail-value">
                                    @if($task->booking_id)
                                        <a href="{{ route('bookings.show', $task->booking_id) }}" class="text-decoration-none">
                                            #{{ $task->booking_id }}
                                            @if($task->booking && $task->booking->guest)
                                                - {{ $task->booking->guest->name }}
                                            @endif
                                        </a>
                                    @else
                                        <span class="text-muted">Tidak terkait booking</span>
                                    @endif
                                </div>
                            </div>
                            
                            <div class="detail-item">
                                <div class="detail-label">Assigned To</div>
                                <div class="detail-value">
                                    @if($task->assignedUser)
                                        <i class="fas fa-user text-info"></i> {{ $task->assignedUser->name }}
                                    @else
                                        <span class="text-muted">Belum di-assign</span>
                                    @endif
                                </div>
                            </div>
                            
                            <div class="detail-item">
                                <div class="detail-label">Estimasi Durasi</div>
                                <div class="detail-value">
                                    @if($task->estimated_duration)
                                        <i class="fas fa-clock text-secondary"></i> {{ $task->estimated_duration }} menit
                                    @else
                                        <span class="text-muted">Tidak ditentukan</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Description & Notes -->
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-success text-white">
                    <h6 class="mb-0"><i class="fas fa-file-text"></i> Deskripsi & Catatan</h6>
                </div>
                <div class="card-body">
                    @if($task->description)
                    <div class="mb-4">
                        <div class="detail-label">Deskripsi Task</div>
                        <div class="detail-value">
                            <div class="p-3 bg-light rounded">
                                {!! nl2br(e($task->description)) !!}
                            </div>
                        </div>
                    </div>
                    @endif
                    
                    @if($task->notes)
                    <div>
                        <div class="detail-label">Catatan</div>
                        <div class="detail-value">
                            <div class="p-3 bg-light rounded border-left border-warning">
                                {!! nl2br(e($task->notes)) !!}
                            </div>
                        </div>
                    </div>
                    @endif
                    
                    @if(!$task->description && !$task->notes)
                    <p class="text-muted mb-0 text-center py-3">
                        <i class="fas fa-info-circle"></i> Tidak ada deskripsi atau catatan untuk task ini.
                    </p>
                    @endif
                </div>
            </div>

            <!-- Task Timeline -->
            <div class="card shadow-sm">
                <div class="card-header bg-secondary text-white">
                    <h6 class="mb-0"><i class="fas fa-history"></i> Timeline Task</h6>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <!-- Created -->
                        <div class="timeline-item completed">
                            <div class="timeline-icon completed">
                                <i class="fas fa-plus"></i>
                            </div>
                            <div>
                                <strong>Task Created</strong>
                                <div class="text-muted small">{{ $task->created_at->format('d/m/Y H:i') }}</div>
                                @if($task->createdBy)
                                <div class="text-muted small">oleh {{ $task->createdBy->name }}</div>
                                @endif
                            </div>
                        </div>

                        <!-- Assigned -->
                        @if($task->assigned_at)
                        <div class="timeline-item {{ $task->status !== 'pending' ? 'completed' : 'current' }}">
                            <div class="timeline-icon {{ $task->status !== 'pending' ? 'completed' : 'current' }}">
                                <i class="fas fa-user"></i>
                            </div>
                            <div>
                                <strong>Task Assigned</strong>
                                <div class="text-muted small">{{ $task->assigned_at->format('d/m/Y H:i') }}</div>
                                @if($task->assignedUser)
                                <div class="text-muted small">kepada {{ $task->assignedUser->name }}</div>
                                @endif
                            </div>
                        </div>
                        @endif

                        <!-- Started -->
                        @if($task->started_at)
                        <div class="timeline-item {{ in_array($task->status, ['completed', 'cancelled']) ? 'completed' : 'current' }}">
                            <div class="timeline-icon {{ in_array($task->status, ['completed', 'cancelled']) ? 'completed' : 'current' }}">
                                <i class="fas fa-play"></i>
                            </div>
                            <div>
                                <strong>Task Started</strong>
                                <div class="text-muted small">{{ $task->started_at->format('d/m/Y H:i') }}</div>
                            </div>
                        </div>
                        @endif

                        <!-- Completed/Cancelled -->
                        @if($task->completed_at)
                        <div class="timeline-item completed">
                            <div class="timeline-icon completed">
                                <i class="fas fa-check"></i>
                            </div>
                            <div>
                                <strong>Task Completed</strong>
                                <div class="text-muted small">{{ $task->completed_at->format('d/m/Y H:i') }}</div>
                                @if($task->assignedUser)
                                <div class="text-muted small">oleh {{ $task->assignedUser->name }}</div>
                                @endif
                            </div>
                        </div>
                        @elseif($task->status === 'cancelled')
                        <div class="timeline-item">
                            <div class="timeline-icon" style="background-color: #6c757d;">
                                <i class="fas fa-times"></i>
                            </div>
                            <div>
                                <strong>Task Cancelled</strong>
                                <div class="text-muted small">{{ $task->updated_at->format('d/m/Y H:i') }}</div>
                            </div>
                        </div>
                        @else
                        <!-- Pending completion -->
                        <div class="timeline-item">
                            <div class="timeline-icon pending">
                                <i class="fas fa-clock"></i>
                            </div>
                            <div>
                                <strong>
                                    @if($task->status === 'in_progress')
                                        Menunggu Completion
                                    @else
                                        Menunggu Start
                                    @endif
                                </strong>
                                @if($task->due_time)
                                <div class="text-muted small">Target: {{ $task->due_time->format('d/m/Y H:i') }}</div>
                                @endif
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Quick Actions -->
            @if($task->status !== 'completed' && $task->status !== 'cancelled')
            <div class="card shadow-sm mb-3">
                <div class="card-header bg-warning text-dark">
                    <h6 class="mb-0"><i class="fas fa-bolt"></i> Quick Actions</h6>
                </div>
                <div class="card-body p-3">
                    <div class="d-grid gap-2">
                        @if($task->status === 'pending')
                        <form action="{{ route('housekeeping.update-status', $task->id) }}" method="POST">
                            @csrf
                            @method('PATCH')
                            <input type="hidden" name="status" value="in_progress">
                            <button type="submit" class="btn btn-info btn-sm w-100">
                                <i class="fas fa-play"></i> Start Task
                            </button>
                        </form>
                        @endif
                        
                        @if($task->status === 'in_progress')
                        <form action="{{ route('housekeeping.update-status', $task->id) }}" method="POST">
                            @csrf
                            @method('PATCH')
                            <input type="hidden" name="status" value="completed">
                            <button type="submit" class="btn btn-success btn-sm w-100">
                                <i class="fas fa-check"></i> Mark Completed
                            </button>
                        </form>
                        @endif
                        
                        <a href="{{ route('housekeeping.edit', $task->id) }}" class="btn btn-outline-warning btn-sm btn-block mb-2">
                            <i class="fas fa-edit"></i> Edit Task
                        </a>
                        
                        @if(in_array($task->status, ['pending', 'in_progress']))
                        <form action="{{ route('housekeeping.update-status', $task->id) }}" method="POST" 
                              onsubmit="return confirm('Yakin ingin membatalkan task ini?')">
                            @csrf
                            @method('PATCH')
                            <input type="hidden" name="status" value="cancelled">
                            <button type="submit" class="btn btn-outline-danger btn-sm w-100">
                                <i class="fas fa-times"></i> Cancel Task
                            </button>
                        </form>
                        @endif
                    </div>
                </div>
            </div>
            @endif

            <!-- Task Statistics -->
            <div class="card shadow-sm mb-3">
                <div class="card-header bg-info text-white">
                    <h6 class="mb-0"><i class="fas fa-chart-pie"></i> Task Statistics</h6>
                </div>
                <div class="card-body p-3">
                    <div class="detail-item">
                        <div class="detail-label">Duration</div>
                        <div class="detail-value">
                            @if($task->completed_at && $task->started_at)
                                @php
                                    $duration = $task->started_at->diffInMinutes($task->completed_at);
                                @endphp
                                <span class="text-success">{{ $duration }} menit (selesai)</span>
                                @if($task->estimated_duration)
                                    <br><small class="text-muted">Est: {{ $task->estimated_duration }} menit</small>
                                @endif
                            @elseif($task->started_at)
                                @php
                                    $duration = $task->started_at->diffInMinutes(now());
                                @endphp
                                <span class="text-info">{{ $duration }} menit (berjalan)</span>
                                @if($task->estimated_duration)
                                    <br><small class="text-muted">Est: {{ $task->estimated_duration }} menit</small>
                                @endif
                            @elseif($task->estimated_duration)
                                <span class="text-muted">Est: {{ $task->estimated_duration }} menit</span>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </div>
                    </div>
                    
                    <div class="detail-item">
                        <div class="detail-label">Time to Due</div>
                        <div class="detail-value">
                            @if($task->due_time)
                                @if($task->status === 'completed')
                                    @if($task->completed_at <= $task->due_time)
                                        <span class="text-success">On Time</span>
                                    @else
                                        <span class="text-danger">Late</span>
                                    @endif
                                @elseif(now() > $task->due_time)
                                    <span class="text-danger">Overdue</span>
                                @else
                                    @php
                                        $timeLeft = now()->diffForHumans($task->due_time, true);
                                    @endphp
                                    <span class="text-warning">{{ $timeLeft }}</span>
                                @endif
                                <br><small class="text-muted">{{ $task->due_time->format('d/m/Y H:i') }}</small>
                            @else
                                <span class="text-muted">Tidak ada deadline</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Related Information -->
            @if($task->booking_id || $task->room)
            <div class="card shadow-sm">
                <div class="card-header bg-secondary text-white">
                    <h6 class="mb-0"><i class="fas fa-link"></i> Related Info</h6>
                </div>
                <div class="card-body p-3">
                    @if($task->room)
                    <div class="detail-item">
                        <div class="detail-label">Room Details</div>
                        <div class="detail-value">
                            <strong>{{ $task->room->room_number }}</strong><br>
                            @if($task->room->typeRoom)
                                <small>{{ $task->room->typeRoom->name }}</small><br>
                            @endif
                            @if($task->room->status)
                                <span class="badge badge-{{ $task->room->status === 'available' ? 'success' : 'warning' }} badge-sm">
                                    {{ ucfirst($task->room->status) }}
                                </span>
                            @endif
                        </div>
                    </div>
                    @endif
                    
                    @if($task->booking_id && $task->booking)
                    <div class="detail-item">
                        <div class="detail-label">Booking Details</div>
                        <div class="detail-value">
                            <a href="{{ route('bookings.show', $task->booking_id) }}" class="text-decoration-none">
                                #{{ $task->booking_id }}
                            </a><br>
                            @if($task->booking->guest)
                                <small>{{ $task->booking->guest->name }}</small><br>
                            @endif
                            @if($task->booking->check_in && $task->booking->check_out)
                                <small class="text-muted">
                                    {{ $task->booking->check_in->format('d/m') }} - {{ $task->booking->check_out->format('d/m') }}
                                </small>
                            @endif
                        </div>
                    </div>
                    @endif
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('scripts')

<script>
$(document).ready(function() {
    // Auto-refresh for in-progress tasks every 30 seconds
    @if($task->status === 'in_progress')
    setInterval(function() {
        updateTaskDuration();
    }, 30000);
    @endif
});

// Update duration display for in-progress tasks
function updateTaskDuration() {
    @if($task->started_at && $task->status === 'in_progress')
    const startTime = new Date('{{ $task->started_at->toISOString() }}');
    const now = new Date();
    const duration = Math.floor((now - startTime) / (1000 * 60)); // in minutes
    
    // Find and update duration display
    const durationElement = $('.detail-value:contains("berjalan")');
    if (durationElement.length) {
        const estimatedText = durationElement.find('small').text();
        durationElement.html(`
            <span class="text-info">${duration} menit (berjalan)</span>
            @if($task->estimated_duration)
            <br><small class="text-muted">${estimatedText}</small>
            @endif
        `);
    }
    @endif
}

// Confirmation for status changes
$('form[action*="update-status"]').on('submit', function(e) {
    const status = $(this).find('input[name="status"]').val();
    let message;
    
    switch(status) {
        case 'in_progress':
            message = 'Mulai mengerjakan task ini?';
            break;
        case 'completed':
            message = 'Tandai task ini sebagai selesai?';
            break;
        case 'cancelled':
            message = 'Batalkan task ini? Task yang dibatalkan tidak dapat diubah kembali.';
            break;
        default:
            message = 'Ubah status task ini?';
    }
    
    if (!confirm(message)) {
        e.preventDefault();
    }
});

// Show loading state for form submissions
$('form[action*="update-status"]').on('submit', function() {
    const button = $(this).find('button[type="submit"]');
    const originalText = button.html();
    
    button.html('<i class="fas fa-spinner fa-spin"></i> Processing...').prop('disabled', true);
    
    // Restore button after 5 seconds if form doesn't submit properly
    setTimeout(() => {
        button.html(originalText).prop('disabled', false);
    }, 5000);
});

// Highlight overdue tasks
@if($task->is_overdue && $task->status !== 'completed')
$(document).ready(function() {
    $('.card').addClass('border-danger');
    $('body').addClass('task-overdue');
});
@endif
</script>


@endpush