@extends('admin-layouts.master')

@section('content')
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Invoice Management</h1>
        <a href="{{ route('invoices.create') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
            <i class="fas fa-plus fa-sm text-white-50"></i> Buat Invoice
        </a>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Invoice
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $stats['total_invoices'] }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-file-invoice fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Invoice Terbayar
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $stats['paid_invoices'] }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Invoice Pending
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $stats['pending_invoices'] }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Total Revenue
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                Rp {{ number_format($stats['total_revenue'], 0, ',', '.') }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter & Pencarian</h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('invoices.index') }}" id="filterForm">
                <div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Status:</label>
                            <select class="form-control" name="status" id="statusFilter">
                                <option value="">Semua Status</option>
                                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="paid" {{ request('status') == 'paid' ? 'selected' : '' }}>Paid</option>
                                <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                <option value="overdue" {{ request('status') == 'overdue' ? 'selected' : '' }}>Overdue</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Metode Bayar:</label>
                            <select class="form-control" name="payment_method" id="paymentMethodFilter">
                                <option value="">Semua Metode</option>
                                @if(isset($paymentMethods))
                                    @foreach($paymentMethods as $method)
                                    <option value="{{ $method->id }}" {{ request('payment_method') == $method->id ? 'selected' : '' }}>
                                        {{ $method->nama }}
                                    </option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Dari Tanggal:</label>
                            <input type="date" class="form-control" name="start_date" value="{{ request('start_date') }}">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Sampai Tanggal:</label>
                            <input type="date" class="form-control" name="end_date" value="{{ request('end_date') }}">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Cari:</label>
                            <div class="input-group">
                                <input type="text" class="form-control" name="search" placeholder="Nomor invoice / Nama tamu..." value="{{ request('search') }}">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-search"></i>
                                    </button>
                                    <a href="{{ route('invoices.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-times"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Invoices Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Data Invoice</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No. Invoice</th>
                            <th>Booking</th>
                            <th>Tamu</th>
                            <th>Tanggal</th>
                            <th>Jatuh Tempo</th>
                            <th>Metode Bayar</th>
                            <th>Total</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>

                    <tbody>
                        @forelse ($invoices as $invoice)
                        <tr class="{{ $invoice->isOverdue() ? 'table-danger' : '' }}">
                            <td>
                                <strong>{{ $invoice->invoice_number }}</strong>
                                @if($invoice->isOverdue())
                                    <br><small class="text-danger"><i class="fas fa-exclamation-triangle"></i> Overdue {{ $invoice->getDaysOverdue() }} hari</small>
                                @endif
                            </td>
                            <td>
                                <strong>#{{ $invoice->booking->id }}</strong><br>
                                <small class="text-muted">{{ $invoice->booking->check_in_date_formatted }}</small>
                            </td>
                            <td>
                                <strong>{{ $invoice->booking->guest->name }}</strong><br>
                                <small class="text-muted">{{ $invoice->booking->guest->phone ?? 'No phone' }}</small>
                            </td>
                            <td>{{ $invoice->invoice_date_formatted }}</td>
                            <td>
                                {{ $invoice->due_date_formatted }}
                                @if($invoice->getDaysUntilDue() !== null)
                                    <br>
                                    @if($invoice->getDaysUntilDue() > 0)
                                        <small class="text-info">{{ $invoice->getDaysUntilDue() }} hari lagi</small>
                                    @elseif($invoice->getDaysUntilDue() == 0)
                                        <small class="text-warning">Hari ini</small>
                                    @else
                                        <small class="text-danger">Terlambat {{ abs($invoice->getDaysUntilDue()) }} hari</small>
                                    @endif
                                @endif
                            </td>
                            <td>
                                @if($invoice->metodePembayaran)
                                    <span class="badge badge-primary" title="{{ $invoice->metodePembayaran->deskripsi }}">
                                        <i class="fas {{ $invoice->metodePembayaran->icon ?? 'fa-credit-card' }} mr-1"></i>
                                        {{ $invoice->metodePembayaran->nama }}
                                    </span>
                                    @if($invoice->metodePembayaran->biaya_admin > 0)
                                        <br><small class="text-warning">
                                            <i class="fas fa-info-circle"></i>
                                            Admin: Rp {{ number_format($invoice->metodePembayaran->biaya_admin, 0, ',', '.') }}
                                        </small>
                                    @endif
                                @else
                                    <span class="badge badge-secondary">
                                        <i class="fas fa-question-circle mr-1"></i>
                                        Belum dipilih
                                    </span>
                                @endif
                            </td>
                            <td>
                                <strong class="text-success">{{ $invoice->formatted_grand_total }}</strong>
                                @if($invoice->services_total > 0)
                                    <br><small class="text-muted">Kamar: {{ $invoice->formatted_room_total }}</small>
                                    <br><small class="text-muted">Layanan: {{ $invoice->formatted_services_total }}</small>
                                @endif
                                @if($invoice->metodePembayaran && $invoice->metodePembayaran->biaya_admin > 0)
                                    <br><small class="text-warning">
                                        + Admin: Rp {{ number_format($invoice->metodePembayaran->biaya_admin, 0, ',', '.') }}
                                    </small>
                                @endif
                            </td>
                            <td>{!! $invoice->status_badge !!}</td>
                            <td>
                                <div class="btn-group" role="group">
                                    <button class="btn btn-info btn-sm" onclick="viewInvoice({{ $invoice->id }})" title="Lihat Detail">
                                        <i class="fas fa-eye"></i>
                                    </button>

                                    <a href="{{ route('invoices.show', $invoice->id) }}" class="btn btn-primary btn-sm" title="Detail Invoice">
                                        <i class="fas fa-file-invoice"></i>
                                    </a>

                                    @if($invoice->canBePaid())
                                        <button class="btn btn-success btn-sm" onclick="markAsPaid({{ $invoice->id }})" title="Tandai Dibayar{{ $invoice->metodePembayaran ? ' via ' . $invoice->metodePembayaran->nama : '' }}">
                                            <i class="fas fa-check"></i>
                                        </button>
                                    @endif

                                    @if($invoice->canBeCancelled())
                                        <button class="btn btn-danger btn-sm" onclick="cancelInvoice({{ $invoice->id }})" title="Batalkan">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    @endif

                                    <a href="{{ route('invoices.download-pdf', $invoice->id) }}" class="btn btn-secondary btn-sm" title="Download PDF">
                                        <i class="fas fa-download"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="9" class="text-center py-4">
                                <i class="fas fa-file-invoice fa-3x text-gray-400 mb-3"></i>
                                <p class="text-gray-500">Tidak ada data invoice ditemukan</p>
                                <a href="{{ route('invoices.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Buat Invoice Baru
                                </a>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            @if($invoices->hasPages())
            <div class="d-flex justify-content-center mt-4">
                {{ $invoices->appends(request()->query())->links() }}
            </div>
            @endif
        </div>
    </div>

</div>

<!-- Modal untuk Detail Invoice -->
<div class="modal fade" id="invoiceDetailModal" tabindex="-1" role="dialog" aria-labelledby="invoiceDetailModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="invoiceDetailModalLabel">Detail Invoice</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="invoiceDetailContent">
                <!-- Content will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ho+j7jyWK8fNQe+A12Hb8AhRq26LrZ/JpcUGGOn+Y7RsweNrtN/tE3MoK7ZeZDyx" crossorigin="anonymous"></script>

<script>
// View invoice details
function viewInvoice(id) {
    $('#invoiceDetailContent').html(`
        <div class="text-center py-4">
            <i class="fas fa-spinner fa-spin fa-2x text-primary"></i>
            <p class="mt-2">Memuat detail invoice...</p>
        </div>
    `);
    $('#invoiceDetailModal').modal('show');

    $.ajax({
        url: `{{ url('invoices') }}/${id}`,
        method: 'GET',
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        },
        success: function(response) {
            if (response.success) {
                const invoice = response.data;
                let roomsHtml = '';
                let servicesHtml = '';

                // Rooms detail
                if (invoice.booking.booking_details && invoice.booking.booking_details.length > 0) {
                    invoice.booking.booking_details.forEach(detail => {
                        roomsHtml += `
                            <tr>
                                <td>Kamar ${detail.room_number}</td>
                                <td>${detail.room_type}</td>
                                <td>${detail.nights} malam</td>
                                <td>Rp ${detail.room_price.toLocaleString('id-ID')}</td>
                                <td>Rp ${detail.total_price.toLocaleString('id-ID')}</td>
                            </tr>
                        `;
                    });
                }

                // Services detail
                if (invoice.booking.booking_services && invoice.booking.booking_services.length > 0) {
                    invoice.booking.booking_services.forEach(service => {
                        servicesHtml += `
                            <tr>
                                <td>${service.service.name}</td>
                                <td>${service.service.category}</td>
                                <td>${service.quantity}</td>
                                <td>Rp ${service.unit_price.toLocaleString('id-ID')}</td>
                                <td>Rp ${service.total_amount.toLocaleString('id-ID')}</td>
                            </tr>
                        `;
                    });
                }

                // Payment method info
                let paymentMethodHtml = '';
                if (invoice.payment_method) {
                    paymentMethodHtml = `
                        <tr><td><strong>Metode Pembayaran:</strong></td><td>
                            <span class="badge badge-primary">
                                <i class="fas ${invoice.payment_method.icon || 'fa-credit-card'} mr-1"></i>
                                ${invoice.payment_method.nama}
                            </span>
                            ${invoice.payment_method.deskripsi ? `<br><small class="text-muted">${invoice.payment_method.deskripsi}</small>` : ''}
                        </td></tr>
                    `;
                }

                const content = `
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h6>Informasi Invoice:</h6>
                            <table class="table table-borderless table-sm">
                                <tr><td><strong>No. Invoice:</strong></td><td>${invoice.invoice_number}</td></tr>
                                <tr><td><strong>Tanggal:</strong></td><td>${invoice.invoice_date}</td></tr>
                                <tr><td><strong>Jatuh Tempo:</strong></td><td>${invoice.due_date}</td></tr>
                                <tr><td><strong>Status:</strong></td><td>${invoice.status_badge}</td></tr>
                                ${paymentMethodHtml}
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h6>Informasi Tamu:</h6>
                            <table class="table table-borderless table-sm">
                                <tr><td><strong>Nama:</strong></td><td>${invoice.booking.guest.name}</td></tr>
                                <tr><td><strong>Telepon:</strong></td><td>${invoice.booking.guest.phone || 'N/A'}</td></tr>
                                <tr><td><strong>Email:</strong></td><td>${invoice.booking.guest.email || 'N/A'}</td></tr>
                                <tr><td><strong>Booking:</strong></td><td>#${invoice.booking.id}</td></tr>
                            </table>
                        </div>
                    </div>

                    ${roomsHtml ? `
                    <h6>Detail Kamar:</h6>
                    <div class="table-responsive mb-4">
                        <table class="table table-bordered table-sm">
                            <thead class="thead-light">
                                <tr>
                                    <th>Kamar</th>
                                    <th>Tipe</th>
                                    <th>Malam</th>
                                    <th>Harga/Malam</th>
                                    <th>Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>${roomsHtml}</tbody>
                        </table>
                    </div>
                    ` : ''}

                    ${servicesHtml ? `
                    <h6>Detail Layanan:</h6>
                    <div class="table-responsive mb-4">
                        <table class="table table-bordered table-sm">
                            <thead class="thead-light">
                                <tr>
                                    <th>Layanan</th>
                                    <th>Kategori</th>
                                    <th>Qty</th>
                                    <th>Harga/Unit</th>
                                    <th>Total</th>
                                </tr>
                            </thead>
                            <tbody>${servicesHtml}</tbody>
                        </table>
                    </div>
                    ` : ''}

                    <div class="row">
                        <div class="col-md-6 offset-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td><strong>Total Kamar:</strong></td>
                                    <td class="text-right">Rp ${invoice.room_total.toLocaleString('id-ID')}</td>
                                </tr>
                                <tr>
                                    <td><strong>Total Layanan:</strong></td>
                                    <td class="text-right">Rp ${invoice.services_total.toLocaleString('id-ID')}</td>
                                </tr>
                                <tr>
                                    <td><strong>Subtotal:</strong></td>
                                    <td class="text-right">Rp ${invoice.subtotal.toLocaleString('id-ID')}</td>
                                </tr>
                                ${invoice.discount_amount > 0 ? `
                                <tr>
                                    <td><strong>Diskon:</strong></td>
                                    <td class="text-right">- Rp ${invoice.discount_amount.toLocaleString('id-ID')}</td>
                                </tr>
                                ` : ''}
                                <tr>
                                    <td><strong>Pajak (${invoice.tax_rate}%):</strong></td>
                                    <td class="text-right">Rp ${invoice.tax_amount.toLocaleString('id-ID')}</td>
                                </tr>
                                ${invoice.payment_method && invoice.payment_method.biaya_admin > 0 ? `
                                <tr>
                                    <td><strong>Biaya Admin:</strong></td>
                                    <td class="text-right">Rp ${invoice.payment_method.biaya_admin.toLocaleString('id-ID')}</td>
                                </tr>
                                ` : ''}
                                <tr class="table-success">
                                    <td><strong>Grand Total:</strong></td>
                                    <td class="text-right"><strong>Rp ${invoice.grand_total.toLocaleString('id-ID')}</strong></td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    ${invoice.notes ? `
                    <hr>
                    <h6>Catatan:</h6>
                    <p class="text-muted">${invoice.notes}</p>
                    ` : ''}
                `;

                $('#invoiceDetailContent').html(content);
            } else {
                $('#invoiceDetailContent').html(`
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i>
                        Data invoice tidak ditemukan
                    </div>
                `);
            }
        },
        error: function(xhr) {
            $('#invoiceDetailContent').html(`
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-triangle"></i>
                    Gagal memuat detail invoice
                </div>
            `);
        }
    });
}

// Mark invoice as paid
function markAsPaid(id) {
    Swal.fire({
        title: 'Konfirmasi Pembayaran',
        text: 'Apakah Anda yakin invoice ini sudah dibayar?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, Sudah Dibayar!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            // Show loading
            Swal.fire({
                title: 'Memproses...',
                text: 'Sedang memperbarui status pembayaran',
                allowOutsideClick: false,
                allowEscapeKey: false,
                showConfirmButton: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            $.ajax({
                url: `{{ url('invoices') }}/${id}/mark-as-paid`,
                method: 'PATCH',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                            location.reload();
                        });
                    }
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Gagal!',
                        text: xhr.responseJSON?.message || 'Gagal mengupdate status invoice'
                    });
                }
            });
        }
    });
}

// Cancel invoice
function cancelInvoice(id) {
    Swal.fire({
        title: 'Konfirmasi Pembatalan',
        text: 'Apakah Anda yakin ingin membatalkan invoice ini?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Ya, Batalkan!',
        cancelButtonText: 'Tidak'
    }).then((result) => {
        if (result.isConfirmed) {
            // Show loading
            Swal.fire({
                title: 'Memproses...',
                text: 'Sedang membatalkan invoice',
                allowOutsideClick: false,
                allowEscapeKey: false,
                showConfirmButton: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            $.ajax({
                url: `{{ url('invoices') }}/${id}/cancel`,
                method: 'PATCH',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                            location.reload();
                        });
                    }
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Gagal!',
                        text: xhr.responseJSON?.message || 'Gagal membatalkan invoice'
                    });
                }
            });
        }
    });
}

// Handle success messages from server
@if(session('success'))
    Swal.fire({
        title: 'Berhasil!',
        text: '{{ session("success") }}',
        icon: 'success',
        timer: 3000,
        showConfirmButton: false
    });
@endif

@if(session('error'))
    Swal.fire({
        title: 'Error!',
        text: '{{ session("error") }}',
        icon: 'error'
    });
@endif

@if(session('info'))
    Swal.fire({
        title: 'Info!',
        text: '{{ session("info") }}',
        icon: 'info'
    });
@endif
</script>

@endpush

@endsection
