@extends('admin-layouts.master')

@section('title', 'Edit Kampung')

@section('content')
<div class="row">
    <div class="col-12">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2 class="h4 mb-1">Edit Kampung</h2>
                <p class="text-muted mb-0">Ubah data kampung</p>
            </div>
            <a href="{{ route('kampung.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

        <!-- Form -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Formulir Kampung</h6>
            </div>
            <div class="card-body">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{ route('kampung.update', $kampung) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="kode_kampung">Kode Kampung *</label>
                                <input type="text" class="form-control" id="kode_kampung" name="kode_kampung" value="{{ old('kode_kampung', $kampung->kode_kampung) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="nama_kampung">Nama Kampung *</label>
                                <input type="text" class="form-control" id="nama_kampung" name="nama_kampung" value="{{ old('nama_kampung', $kampung->nama_kampung) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="kecamatan_id">Kecamatan *</label>
                                <select class="form-control" id="kecamatan_id" name="kecamatan_id" required>
                                    <option value="">Pilih Kecamatan</option>
                                    @foreach ($kecamatans as $kecamatan)
                                        <option value="{{ $kecamatan->id }}" {{ old('kecamatan_id', $kampung->kecamatan_id) == $kecamatan->id ? 'selected' : '' }}>
                                            {{ $kecamatan->nama_kecamatan }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="alamat_kantor_kampung">Alamat Kantor Kampung *</label>
                                <textarea class="form-control" id="alamat_kantor_kampung" name="alamat_kantor_kampung" rows="3" required>{{ old('alamat_kantor_kampung', $kampung->alamat_kantor_kampung) }}</textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="kode_pos">Kode Pos *</label>
                                <input type="number" class="form-control" id="kode_pos" name="kode_pos" value="{{ old('kode_pos', $kampung->kode_pos) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="nama_kepala_kampung">Nama Kepala Kampung *</label>
                                <input type="text" class="form-control" id="nama_kepala_kampung" name="nama_kepala_kampung" value="{{ old('nama_kepala_kampung', $kampung->nama_kepala_kampung) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="nip">NIP</label>
                                <input type="text" class="form-control" id="nip" name="nip" value="{{ old('nip', $kampung->nip) }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="golongan">Golongan</label>
                                <input type="text" class="form-control" id="golongan" name="golongan" value="{{ old('golongan', $kampung->golongan) }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pangkat">Pangkat</label>
                                <input type="text" class="form-control" id="pangkat" name="pangkat" value="{{ old('pangkat', $kampung->pangkat) }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="luas_wilayah">Luas Wilayah (km²) *</label>
                                <input type="number" step="0.01" class="form-control" id="luas_wilayah" name="luas_wilayah" value="{{ old('luas_wilayah', $kampung->luas_wilayah) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="jumlah_rt">Jumlah RT *</label>
                                <input type="number" class="form-control" id="jumlah_rt" name="jumlah_rt" value="{{ old('jumlah_rt', $kampung->jumlah_rt) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="jumlah_rw">Jumlah RW *</label>
                                <input type="number" class="form-control" id="jumlah_rw" name="jumlah_rw" value="{{ old('jumlah_rw', $kampung->jumlah_rw) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="jumlah_penduduk">Jumlah Penduduk *</label>
                                <input type="number" class="form-control" id="jumlah_penduduk" name="jumlah_penduduk" value="{{ old('jumlah_penduduk', $kampung->jumlah_penduduk) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="status">Status *</label>
                                <select class="form-control" id="status" name="status" required>
                                    <option value="Aktif" {{ old('status', $kampung->status) == 'Aktif' ? 'selected' : '' }}>Aktif</option>
                                    <option value="Nonaktif" {{ old('status', $kampung->status) == 'Nonaktif' ? 'selected' : '' }}>Nonaktif</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="warna">Warna *</label>
                                <input type="color" class="form-control" id="warna" name="warna" value="{{ old('warna', $kampung->warna) }}" required>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="geojson">GeoJSON (File) *</label>
                                <input type="file" class="form-control-file" id="geojson" name="geojson" accept=".json">
                                <small class="text-muted">Unggah file GeoJSON baru (maks. 2MB) atau biarkan kosong untuk mempertahankan data lama</small>
                                @if($kampung->geojson_file)
                                    <p class="mt-2"><strong>File GeoJSON Saat Ini:</strong> 
                                        <a href="{{ asset('storage/geojson/' . $kampung->geojson_file) }}" target="_blank">Lihat File</a> 
                                        <a href="#" onclick="confirmRemoveGeojson('{{ $kampung->id }}')">Hapus File</a>
                                    </p>
                                @endif
                                <input type="hidden" name="remove_geojson" id="remove_geojson" value="0">
                            </div>
                        </div>
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Perbarui
                            </button>
                            <a href="{{ route('kampung.index') }}" class="btn btn-secondary ml-2">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmRemoveGeojson(id) {
    Swal.fire({
        title: 'Konfirmasi',
        text: 'Apakah Anda yakin ingin menghapus file GeoJSON?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#e74a3b',
        cancelButtonColor: '#1cc88a',
        confirmButtonText: 'Ya, Hapus',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            $('#remove_geojson').val(id);
            $('#remove_geojson').closest('form').submit();
        }
    });
}

@if(session('success'))
    $(document).ready(function() {
        Swal.fire({
            icon: 'success',
            title: 'Sukses!',
            text: '{{ session('success') }}',
            confirmButtonText: 'OK',
            confirmButtonColor: '#1cc88a',
        });
    });
@endif

@if(session('error'))
    $(document).ready(function() {
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: '{{ session('error') }}',
            confirmButtonText: 'OK',
            confirmButtonColor: '#e74a3b',
        });
    });
@endif
</script>
@endpush