@extends('admin-layouts.master')

@section('content')
<div class="container-fluid">

    <div class="row">
        <div class="col">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h3 class="m-0 font-weight-bold text-primary text-center">Pasien Telah Diperiksa</h3>
                </div>
                <div class="card-body">
                    <div class="text-center">
                        <img class="img-fluid px-3 px-sm-4 mt-3 mb-4" style="width: 30rem;"
                            src="{{ asset('template-admin/img/undraw_Queue_j6ij.png') }}" alt="">
                    </div>
                    <center>
                        <div class="card text-center shadow-md" style="width:22rem;">
                            <div class="card-header py-3">
                                <h4 class="m-0 font-weight-bold text-primary text-center">Nomor Antrian</h4>
                            </div>
                            @if($no_antrian != NULL)
                            <div class="card-body">
                                <h1>{{ $no_antrian->nomor_urut }}</h1>

                            </div>                        
                            @else
                            <div class="card-body">
                                <h3 class="text-danger">Belum Ada Antrian Pasien</h3>
                            </div>
                            @endif
                        </div>
                    </center>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h4 class="m-0 font-weight-bold text-primary text-center">Daftar Nama Pasien Yang Telah Diperiksa Dokter</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>No Rekam Medis</th>
                                    <th>Nama Pasien</th>
                                    <th>Nomor Antrian</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            
                            <tbody>
                                
                                @forelse ($antrian_pasien as $item)
                                <tr>

                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $item->pasien->nomor_rekam_medis }}</td>
                                    <td>{{ $item->pasien->nama_pasien }}</td>
                                    <td>{{ $item->nomor_urut }}</td>
                                    <td>
                                       
                                        <a class="btn btn-success" href="{{ route('pemeriksaan.kasir.create.pasien', ['id'=>$item->pasien->id,'antrian_id'=>$item->id]) }}"><i class="fas fa-user-check"></i> Verifikasi</a>
                                       
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" class="text-center">
                                        <div class="spinner-grow text-primary" role="status">
                                            <span class="sr-only">Loading...</span>
                                          </div>
                                        <h5 class="mt-1">Menunggu Pasien Antrian Sedang Dalam Pemeriksaan</h5>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection