@extends('admin-layouts.master')

@section('title', 'Edit Kecamatan')

@section('content')
<div class="row">
    <div class="col-12">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2 class="h4 mb-1">Edit Kecamatan</h2>
                <p class="text-muted mb-0">Ubah data kecamatan</p>
            </div>
            <a href="{{ route('kecamatan.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

        <!-- Form -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Formulir Kecamatan</h6>
            </div>
            <div class="card-body">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{ route('kecamatan.update', $kecamatan) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="kode_kecamatan">Kode Kecamatan *</label>
                                <input type="text" class="form-control" id="kode_kecamatan" name="kode_kecamatan" value="{{ old('kode_kecamatan', $kecamatan->kode_kecamatan) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="nama_kecamatan">Nama Kecamatan *</label>
                                <input type="text" class="form-control" id="nama_kecamatan" name="nama_kecamatan" value="{{ old('nama_kecamatan', $kecamatan->nama_kecamatan) }}" required>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="alamat_kantor_kecamatan">Alamat Kantor Kecamatan *</label>
                                <textarea class="form-control" id="alamat_kantor_kecamatan" name="alamat_kantor_kecamatan" rows="3" required>{{ old('alamat_kantor_kecamatan', $kecamatan->alamat_kantor_kecamatan) }}</textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="kode_pos">Kode Pos *</label>
                                <input type="number" class="form-control" id="kode_pos" name="kode_pos" value="{{ old('kode_pos', $kecamatan->kode_pos) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="nama_camat">Nama Camat *</label>
                                <input type="text" class="form-control" id="nama_camat" name="nama_camat" value="{{ old('nama_camat', $kecamatan->nama_camat) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="nip">NIP</label>
                                <input type="text" class="form-control" id="nip" name="nip" value="{{ old('nip', $kecamatan->nip) }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="golongan">Golongan</label>
                                <input type="text" class="form-control" id="golongan" name="golongan" value="{{ old('golongan', $kecamatan->golongan) }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pangkat">Pangkat</label>
                                <input type="text" class="form-control" id="pangkat" name="pangkat" value="{{ old('pangkat', $kecamatan->pangkat) }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="luas_wilayah">Luas Wilayah (km²) *</label>
                                <input type="number" step="0.01" class="form-control" id="luas_wilayah" name="luas_wilayah" value="{{ old('luas_wilayah', $kecamatan->luas_wilayah) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="jumlah_desa">Jumlah Desa *</label>
                                <input type="number" class="form-control" id="jumlah_desa" name="jumlah_desa" value="{{ old('jumlah_desa', $kecamatan->jumlah_desa) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="status">Status *</label>
                                <select class="form-control" id="status" name="status" required>
                                    <option value="Aktif" {{ old('status', $kecamatan->status) == 'Aktif' ? 'selected' : '' }}>Aktif</option>
                                    <option value="Nonaktif" {{ old('status', $kecamatan->status) == 'Nonaktif' ? 'selected' : '' }}>Nonaktif</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="warna">Warna *</label>
                                <input type="color" class="form-control" id="warna" name="warna" value="{{ old('warna', $kecamatan->warna) }}" required>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="geojson">GeoJSON (File) *</label>
                                <input type="file" class="form-control-file" id="geojson" name="geojson" accept=".json">
                                <small class="text-muted">Unggah file GeoJSON baru (maks. 2MB) atau biarkan kosong untuk mempertahankan data lama</small>
                                @if($kecamatan->geojson_file)
                                    <p class="mt-2"><strong>File GeoJSON Saat Ini:</strong> 
                                        <a href="{{ asset('storage/geojson/' . $kecamatan->geojson_file) }}" target="_blank">Lihat File</a> 
                                        <a href="#" onclick="confirmRemoveGeojson('{{ $kecamatan->id }}')">Hapus File</a>
                                    </p>
                                @endif
                                <input type="hidden" name="remove_geojson" id="remove_geojson" value="0">
                            </div>
                        </div>
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Perbarui
                            </button>
                            <a href="{{ route('kecamatan.index') }}" class="btn btn-secondary ml-2">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmRemoveGeojson(id) {
    Swal.fire({
        title: 'Konfirmasi',
        text: 'Apakah Anda yakin ingin menghapus file GeoJSON?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#e74a3b',
        cancelButtonColor: '#1cc88a',
        confirmButtonText: 'Ya, Hapus',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            $('#remove_geojson').val(id);
            $('#remove_geojson').closest('form').submit();
        }
    });
}

@if(session('success'))
    $(document).ready(function() {
        Swal.fire({
            icon: 'success',
            title: 'Sukses!',
            text: '{{ session('success') }}',
            confirmButtonText: 'OK',
            confirmButtonColor: '#1cc88a',
        });
    });
@endif

@if(session('error'))
    $(document).ready(function() {
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: '{{ session('error') }}',
            confirmButtonText: 'OK',
            confirmButtonColor: '#e74a3b',
        });
    });
@endif
</script>
@endpush