@extends('admin-layouts.master')

@section('content')
<div class="container-fluid">

    <!-- Page Heading -->
    {{-- <h1 class="h3 mb-2 text-gray-800">{{$title}}</h1>
     --}}

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">{{$title}}</h6>
        </div>
        <div class="card-body">
            <div class="text-right px-3 py-3">
                <button type="button" class="btn btn-outline-primary" data-toggle="modal" data-target="#serviceModal" id="addServiceBtn">
                    <i class="fas fa-plus"></i> Tambah
                </button>
            </div>
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Service</th>
                            <th>Kategori Service</th>
                            <th>Satuan</th>
                            <th>Harga</th>
                            <th>PPN</th>
                            <th>Deskripsi</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    
                    <tbody>
                        @foreach ($ms_services as $s)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{$s->name ?? ''}}</td>
                            <td>{{ $s->serviceCategory->name ?? '' }}</td>
                            <td>{{ $s->satuan }}</td>
                            <td>Rp {{ number_format($s->harga ?? 0, 0, ',', '.') }}</td>
                            <td>{{ $s->ppn }}%</td>
                            <td>{{ Str::limit($s->description ?? '-', 50) }}</td>
                            <td>
                                {{-- <button class="btn btn-info btn-sm" onclick="viewService({{$s->id}})">
                                    <i class="fas fa-eye"></i>
                                </button> --}}
                                <button class="btn btn-warning btn-sm" onclick="editService({{$s->id}}, '{{$s->name}}', {{$s->service_category_id}}, '{{$s->satuan}}', {{$s->harga}}, {{$s->ppn}}, '{{addslashes($s->description ?? '')}}')">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button onclick="deleteService({{$s->id}})" class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

<!-- Modal untuk Tambah/Edit Service -->
<div class="modal fade" id="serviceModal" tabindex="-1" role="dialog" aria-labelledby="serviceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="serviceModalLabel">Tambah Service</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="serviceForm" method="POST" action="{{ route('ms-service.store') }}">
                @csrf
                <div id="methodField"></div>
                <input type="hidden" name="id" id="service_id" value="">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Nama Service <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="name" name="name" required>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="service_category_id">Kategori Service <span class="text-danger">*</span></label>
                                <select class="form-control" id="service_category_id" name="service_category_id" required>
                                    <option value="">Pilih Kategori Service</option>
                                    @foreach($ms_service_categories as $category)
                                        <option value="{{$category->id}}">{{$category->name}}</option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="satuan">Satuan <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="satuan" name="satuan" placeholder="Contoh: pcs, kg, jam" required>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="harga">Harga <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="harga" name="harga" min="0" step="0.01" required>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="ppn">PPN (%) <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="ppn" name="ppn" min="0" max="100" step="0.01" value="11" required>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="description">Deskripsi (Opsional)</label>
                        <textarea class="form-control" id="description" name="description" rows="3" placeholder="Masukkan deskripsi service..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary" id="submitBtn">
                        <i class="fas fa-save"></i> Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Form untuk Delete -->
<form action="" method="post" id="deleteForm">
    @csrf
    @method("DELETE")
    <input type="submit" value="Hapus" style="display:none">
</form>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ho+j7jyWK8fNQe+A12Hb8AhRq26LrZ/JpcUGGOn+Y7RsweNrtN/tE3MoK7ZeZDyx" crossorigin="anonymous"></script>

<script>
// Global variables
let isEdit = false;
let editId = null;

// Event listeners
$(document).ready(function() {
    // Handle form submission
    $('#serviceForm').submit(function(e) {
        e.preventDefault();
        submitForm();
    });

    // Reset modal when closed
    $('#serviceModal').on('hidden.bs.modal', function() {
        resetModal();
    });

    // Format harga input
    $('#harga').on('input', function() {
        let value = $(this).val();
        if (value) {
            // Remove any non-numeric characters except decimal point
            value = value.replace(/[^\d.]/g, '');
            $(this).val(value);
        }
    });
});

// Add new service
$('#addServiceBtn').click(function() {
    resetModal();
    $('#serviceModalLabel').text('Tambah Service Baru');
    $('#submitBtn').html('<i class="fas fa-save"></i> Simpan');
    $('#serviceForm').attr('action', '{{ route("ms-service.store") }}');
    isEdit = false;
});

// Edit service function
function editService(id, name, serviceCategoryId, satuan, harga, ppn, description = '') {
    isEdit = true;
    editId = id;
    
    $('#serviceModalLabel').text('Edit Service');
    $('#submitBtn').html('<i class="fas fa-save"></i> Update');
    $('#methodField').html('@method("PUT")');
    $('#serviceForm').attr('action', `{{ url('ms-service') }}/${id}`);
    
    // Fill form with existing data
    $('#name').val(name);
    $('#service_category_id').val(serviceCategoryId);
    $('#satuan').val(satuan);
    $('#harga').val(harga);
    $('#ppn').val(ppn);
    $('#description').val(description);
    $('#service_id').val(id);
    
    $('#serviceModal').modal('show');
}

// View service function
function viewService(id) {
    // You can implement view functionality here
    // For now, just show an alert
    Swal.fire({
        title: 'Detail Service',
        text: 'Fungsi view akan diimplementasikan sesuai kebutuhan',
        icon: 'info'
    });
}

// Delete service function
function deleteService(id) {
    Swal.fire({
        title: 'Apakah Anda yakin?',
        text: "Data yang sudah dihapus tidak dapat dikembalikan!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, Hapus!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.value) {
            // Set form action and submit
            $('#deleteForm').attr('action', `{{ url('ms-service') }}/${id}`);
            $('#deleteForm').submit();
        }
    });
}

// Submit form function
function submitForm() {
    const formData = new FormData($('#serviceForm')[0]);
    const url = $('#serviceForm').attr('action');
    
    // Show loading
    $('#submitBtn').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Menyimpan...');
    
    // Clear previous errors
    $('.form-control').removeClass('is-invalid');
    $('.invalid-feedback').text('');
    
    $.ajax({
        url: url,
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'application/json': true
        },
        success: function(response) {
            $('#serviceModal').modal('hide');
            Swal.fire({
                title: 'Berhasil!',
                text: response.message || (isEdit ? 'Data service berhasil diupdate!' : 'Data service berhasil disimpan!'),
                icon: 'success',
                timer: 2000,
                showConfirmButton: false
            }).then(() => {
                location.reload();
            });
        },
        error: function(xhr) {
            console.log('Error response:', xhr);
            
            if (xhr.status === 422) {
                // Validation errors
                const errors = xhr.responseJSON.errors;
                if (errors) {
                    Object.keys(errors).forEach(function(key) {
                        const field = $(`#${key}`);
                        field.addClass('is-invalid');
                        field.siblings('.invalid-feedback').text(errors[key][0]);
                    });
                }
                
                Swal.fire({
                    title: 'Validasi Error!',
                    text: 'Silakan periksa form Anda.',
                    icon: 'error'
                });
            } else {
                // Other errors
                const message = xhr.responseJSON?.message || 'Terjadi kesalahan saat menyimpan data.';
                Swal.fire({
                    title: 'Error!',
                    text: message,
                    icon: 'error'
                });
            }
        },
        complete: function() {
            $('#submitBtn').prop('disabled', false).html(isEdit ? '<i class="fas fa-save"></i> Update' : '<i class="fas fa-save"></i> Simpan');
        }
    });
}

// Reset modal function
function resetModal() {
    $('#serviceForm')[0].reset();
    $('#methodField').empty();
    $('.form-control').removeClass('is-invalid');
    $('.invalid-feedback').text('');
    $('#service_id').val('');
    $('#ppn').val('11'); // Set default PPN value
    isEdit = false;
    editId = null;
}

// Handle success messages from server
@if(session('success'))
    Swal.fire({
        title: 'Berhasil!',
        text: '{{ session("success") }}',
        icon: 'success',
        timer: 3000,
        showConfirmButton: false
    });
@endif

@if(session('error'))
    Swal.fire({
        title: 'Error!',
        text: '{{ session("error") }}',
        icon: 'error'
    });
@endif
</script>

@endpush

@endsection