@extends('admin-layouts.master')

@section('content')
@php
        $mytime = Carbon\Carbon::now();
        $jam_sekarang =  date('H:i', strtotime($mytime));

        //ambil tanggal hari ini
        $hari_ini = $mytime->toDateString();
        //Jadwal Pagi
        $pagi_tutup = Carbon\Carbon::createFromFormat('H:i', '15:00');
        $pagi_buka = Carbon\Carbon::createFromFormat('H:i', '06:00');
        $jadwal_pagi_buka = $pagi_buka->format('H:i');
        $jadwal_pagi_tutup = $pagi_tutup->format('H:i');
        //Jadwal Sore
        $sore_tutup = Carbon\Carbon::createFromFormat('H:i', '23:00');
        $sore_buka = Carbon\Carbon::createFromFormat('H:i', '16:00');
        $jadwal_sore_buka = $sore_buka->format('H:i');
        $jadwal_sore_tutup = $sore_tutup->format('H:i');

        //redirect jika belum waktunya
        $batas1 = Carbon\Carbon::createFromFormat('H:i', '23:00');

@endphp
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-2 text-gray-800">Data Pasien</h1>
    

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Data Rekam Medis Pasien</h6>
        </div>
        <div class="card-body">
            <div class="text-right px-3 py-3">

                <a href="{{ route('export.view') }}" class="btn btn-outline-primary">
                    View Export
                </a>

            </div>
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>No Rekam Medis</th>
                            <th>Nama Pasien</th>
                            <th>Usia</th>
                            <th>Tanggal Rekam</th>
                            <th>Alamat Pasien</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    
                    <tbody>
                        @foreach ($pasien as $u)
                        <tr>
                            @php
                            //  if (strtotime($jam_sekarang) <= strtotime($pagi_tutup)) {
                            //     $cek_antrian = App\Models\Antrian::where('pasien_id', $u->id)->whereBetween('jam', [$jadwal_pagi_buka, $jadwal_pagi_tutup])->where('tanggal', $hari_ini)->where('status', 'belum')->orderBy('nomor_urut', 'ASC')->first();
                              
                            // } elseif (strtotime($jam_sekarang) <= strtotime($sore_tutup)) {
                            //     $cek_antrian = App\Models\Antrian::where('pasien_id', $u->id)->whereBetWeen('jam', [$jadwal_sore_buka, $jadwal_sore_tutup])->where('tanggal', $hari_ini)->where('status', 'belum')->orderBy('nomor_urut', 'ASC')->first();
                                
                            // }
                           $cek_antrian = App\Models\Antrian::where('pasien_id', $u->id)->where('tanggal', $hari_ini)->where('status', 'belum')->orderBy('nomor_urut', 'ASC')->first();
                            @endphp
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $u->nomor_rekam_medis }}</td>
                            <td>{{ $u->nama_pasien }}</td>
                            <td>{{ $u->usia }}</td>
                            <td>{{ Carbon\Carbon::parse($u->created_at)->translatedFormat('d F Y') }}</td>
                            <td>{{ $u->alamat }}</td>
                            <td>
                                <a class="btn btn-info" href="{{ route('pasien.show',$u) }}"><i class="fas fa-eye"></i></a>
                                <a class="btn btn-warning" href="{{ route('pasien.edit',$u) }}"><i class="fas fa-edit"></i></a>
                                <button href="{{route('pasien.destroy', $u)}}" id="delete" class="btn btn-danger"><i class="fas fa-trash"></i></button>
                                {{-- @if((strtotime($jam_sekarang) <= strtotime($pagi_buka) || strtotime($jam_sekarang) >= strtotime($pagi_tutup)) && (strtotime($jam_sekarang) <= strtotime($sore_buka) || strtotime($jam_sekarang) >= strtotime($sore_tutup))) 
                                <button href="{{ route('daftarkan.pasien', $u) }}" id="daftar" class="btn btn-success" disabled><i class="fas fa-notes-medical"></i> Daftarkan</button>
                                @else
                                    @if($cek_antrian)
                                    
                                    <button href="{{ route('daftarkan.pasien', $u) }}" id="daftar" class="btn btn-success" disabled><i class="fas fa-notes-medical"></i> Daftarkan</button>
                                    @else
                                    <button href="{{ route('daftarkan.pasien', $u) }}" id="daftar" class="btn btn-success"><i class="fas fa-notes-medical"></i> Daftarkan</button>
                                    @endif
                                @endif --}}
                                @if($cek_antrian)
                                    
                                    <button href="{{ route('daftarkan.pasien', $u) }}" id="daftar" class="btn btn-success" disabled><i class="fas fa-notes-medical"></i> Daftarkan</button>
                                    @else
                                    <button href="{{ route('daftarkan.pasien', $u) }}" id="daftar" class="btn btn-success"><i class="fas fa-notes-medical"></i> Daftarkan</button>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                        
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
<form action="" method="post" id="daftarkanForm">
    @csrf
    @method("POST")
    <input type="submit" value="Daftar" style="display:none">
</form>
<form action="" method="post" id="deleteForm">
    @csrf
    @method("DELETE")
    <input type="submit" value="Hapus" style="display:none">
</form>
    @push('scripts')
    <script>
        $('button#daftar').on('click', function(e){
        e.preventDefault();
        
            var link = $(this).attr('href');
              document.getElementById('daftarkanForm').action = link;
              document.getElementById('daftarkanForm').submit();
        })
    </script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ho+j7jyWK8fNQe+A12Hb8AhRq26LrZ/JpcUGGOn+Y7RsweNrtN/tE3MoK7ZeZDyx" crossorigin="anonymous">
    </script>

    <script>
    $('button#delete').on('click', function(e){
      e.preventDefault();
    
      var href = $(this).attr('href');
    
      Swal.fire({
          title: 'Apakah Kamu yakin akan menghapus data ini?',
          text: "Data yang sudah dihapus tidak dapat dikembalikan!",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Ya, Hapus!'
          }).then((result) => {
          if (result.value) {
              document.getElementById('deleteForm').action = href;
              document.getElementById('deleteForm').submit();
                  Swal.fire(
                  'Berhasi Dihapus!',
                  'Data Kamu Berhasil Dihapus.',
                  'success'
                  )
              }
          })
    
    
    })
   
    </script>
<script src="{{ asset('template-admin/vendor/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('template-admin/vendor/datatables/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('template-admin/js/demo/datatables-demo.js') }}"></script>
@endpush

@endsection