@extends('admin-layouts.master')

@section('content')

<div class="container-fluid">
    <h1 class="h3 mb-2 text-gray-800">Detail Pasien</h1>
    <div class="row  justify-content-center align-items-center">
        <div class="col ">
            <div class="card ">
                <div class="card-body">
                    <form  action="" method="POST" enctype="multipart/form-data">
                       
                        <div class="form-group">
                            <label for=""@error('nomor_rekam_medis') class="text-danger" @enderror >Nomor Rekam Medis</label>
                            <input type="text" name="" class="form-control @error('name') form-control is-invalid @enderror"
                            placeholder="" value="{{$pasien->nomor_rekam_medis}}" readonly>
                            @error('nomor_rekam_medis')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                        <div class="form-row">
                            <div class="col">
                                <div class="form-group">
                                    <label for=""@error('nama_pasien') class="text-danger" @enderror >Nama Pasien</label>
                                    <input type="text" name="nama_pasien" class="form-control @error('name') form-control is-invalid @enderror"
                                    placeholder="" value="{{$pasien->nama_pasien ?? old('nama_pasien') }}" readonly>
                                    @error('nama_pasien')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col">
                                <div class="form-group">
                                    <label for=""@error('telp') class="text-danger" @enderror >No HP</label>
                                    <input type="text" name="telp" class="form-control @error('telp') form-control is-invalid @enderror"
                                    placeholder="" value="{{$pasien->telp ??old('telp') }}" readonly>
                                    @error('telp')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for=""@error('telp') class="text-danger" @enderror >Jenis Kelamin</label>
                                    <input type="text" name="telp" class="form-control @error('telp') form-control is-invalid @enderror"
                                    placeholder="" value="{{$pasien->jenis_kelamin ??old('jenis_kelamin') }}" readonly>
                                    @error('telp')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for=""@error('tanggal_lahir') class="text-danger" @enderror >Tanggal Lahir</label>
                                    <input id="tahun" type="date" name="tanggal_lahir" class="form-control @error('tanggal_lahir') form-control is-invalid @enderror"
                                    placeholder="" value="{{$pasien->tanggal_lahir ?? old('tanggal_lahir') }}" readonly>
                                    @error('tanggal_lahir')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for=""@error('usia') class="text-danger" @enderror >Usia</label>
                                    <input type="text" name="usia" id="usia" class="form-control @error('email') form-control is-invalid @enderror"
                                    placeholder="" value="{{ $pasien->usia }}" readonly>
                                    @error('usia')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div>
                           
                          </div>
                          <div class="form-group">
                            <label for="exampleFormControlTextarea1">Alamat</label>
                            <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="alamat" value="" readonly> {{ $pasien->alamat }}</textarea>
                          </div>
                          <div class="form-group">
                            <label for="exampleFormControlTextarea1">Riwayat Alergi</label>
                            <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="riwayat_alergi" value="" readonly>{{ $pasien->riwayat_alergi }}</textarea>
                          </div>
                          <div class="form-group">
                            <label for="exampleFormControlTextarea1">Riwayat Penyakit</label>
                            <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="riwayat_penyakit" value="" readonly>{{ $pasien->riwayat_penyakit }}</textarea>
                          </div>
                        <div class="form-group">
                            <a href="{{ route('pasien.index') }}" class="btn btn-danger mt-3">Kembali</a>
                            @if($cek >= 1)
                            <a href="{{ route('cek.riwayat.pdf', $pasien->id) }}" class="btn btn-primary mt-3" target="_blank">Cek Riwayat</a>
                            {{-- <input type="submit" value="Update" class="btn btn-primary mt-3"> --}}
                            @endif
                            @if($cek_lab)
                            <a href="{{ route('pemeriksaan-lab.show',$pasien->nomor_rekam_medis) }}" class="btn btn-success mt-3" target="_blank">Cek Riwayat Lab</a>
                            @endif
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>

@endsection