@extends('admin-layouts.master')

@section('content')
<style>
    .copy-text {
	position: relative;
	padding: 10px;
	background: #fff;
	border: 1px solid #ddd;
	border-radius: 10px;
	display: flex;
}
.copy-text input.text {
	padding: 10px;
	font-size: 18px;
	color: #555;
	border: none;
	outline: none;
}

.copy-text button {
	padding: 10px;
	background: #5784f5;
	color: #fff;
	font-size: 18px;
	border: none;
	outline: none;
	border-radius: 10px;
	cursor: pointer;
}

.copy-text button:active {
	background: #809ce2;
}
.copy-text button:before {
	content: "Copied";
	position: absolute;
	top: -45px;
	right: 0px;
	background: #5c81dc;
	padding: 8px 10px;
	border-radius: 20px;
	font-size: 15px;
	display: none;
}
.copy-text button:after {
	content: "";
	position: absolute;
	top: -20px;
	right: 25px;
	width: 10px;
	height: 10px;
	background: #5c81dc;
	transform: rotate(45deg);
	display: none;
}
.copy-text.active button:before,
.copy-text.active button:after {
	display: block;
}
</style>
<div class="container-fluid">
    <h1 class="h3 mb-2 text-gray-800">Formulir Pembayaran Klaim</h1>
    
    <div class="card">
        <div class="card-body">
            <form  action="{{route($route.'.store')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="id" value="{{ $data->id??false }}">
               <div class="form-row">
                <div class="col-lg-12">
                    <div class="form-group ">
                        <label for=""@error('resi') class="text-danger" @enderror >NO RESI</label>
                        <input type="text" name="resi" class="form-control @error('resi') form-control is-invalid @enderror"
                        placeholder="" value="{{ $data->dataNasabah->resi->code??false}}" @if($data->only_view) disabled @endif disabled>
                        @error('resi')
                            <span  class="text-danger"> {{ $message }} </span>
                        @enderror
                    </div>
                </div>
               </div>
                <div class="form-row">
                    <div class="col-lg-6 col-sm-12">
                        <div class="form-group ">
                            <label for=""@error('nama') class="text-danger" @enderror >Nama</label>
                            <input type="text" name="nama" class="form-control @error('nama') form-control is-invalid @enderror"
                            placeholder="" value="{{ $data->dataNasabah->nama??false}}" @if($data->only_view) disabled @endif disabled>
                            @error('nama')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12">
                        <div class="form-group ">
                            <label for=""@error('usia') class="text-danger" @enderror >Usia</label>
                            <input type="number" name="usia" class="form-control @error('usia') form-control is-invalid @enderror"
                            placeholder="" value="{{ $data->dataNasabah->usia??false}}"  @if($data->only_view) disabled @endif disabled>
                            @error('usia')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    
                    <div class="col-lg-6 col-sm-12">
                        <div class="form-group">
                            <label for=""@error('no_hp') class="text-danger" @enderror >No HP</label>
                            <input type="text" name="no_hp" class="form-control @error('no_hp') form-control is-invalid @enderror"
                            placeholder="" value="{{ $data->dataNasabah->no_hp ??false }}" @if($data->only_view) disabled @endif disabled>
                            @error('no_hp')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12">
                        <label for=""@error('jenis_kelamin') class="text-danger" @enderror >Jenis Kelamin</label>
                        <div>
                            @if($data->id)
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="jenis_kelamin" id="inlineRadio1" value="Laki-laki" @if($data->dataNasabah->jenis_kelamin == "Laki-laki") checked  @endif disabled>
                                <label class="form-check-label" for="inlineRadio1">Laki-laki</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="jenis_kelamin" id="inlineRadio2" value="Perempuan"@if($data->dataNasabah->jenis_kelamin == "Perempuan") checked  @endif disabled>
                                <label class="form-check-label" for="inlineRadio2">Perempuan</label>
                            </div>

                            @else
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="jenis_kelamin" id="inlineRadio1" value="Laki-laki"  required>
                                <label class="form-check-label" for="inlineRadio1" for=""@error('jenis_kelamin') class="text-danger" @enderror>Laki-laki</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="jenis_kelamin" id="inlineRadio2" value="Perempuan" required>
                                <label class="form-check-label" for="inlineRadio2" for=""@error('jenis_kelamin') class="text-danger" @enderror>Perempuan</label>
                            </div>
                            @error('jenis_kelamin')
                                    <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                            @endif
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="col-lg-12 col-sm-12">
                        <div class="form-group">
                            <label for=""@error('alamat') class="text-danger" @enderror >Alamat
                            </label>
                            <textarea name="alamat" class="form-control" id="" cols="30" rows="3" disabled>{{$data->dataNasabah->alamat ??false}}</textarea>
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="col-lg-6 col-sm-12">
                        <div class="form-group">
                            <label for=""@error('pekerjaan') class="text-danger" @enderror >Pekerjaan</label>
                            <input type="text" name="pekerjaan" class="form-control @error('pekerjaan') form-control is-invalid @enderror"
                            placeholder="" value="{{ $data->dataNasabah->pekerjaan ?? false }}" disabled>
                            @error('pekerjaan')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12">
                        <label for=""@error('jenis_klaim') class="text-danger" @enderror >Jenis Klaim</label>
                        <div>

                            @if($data->id)
                            
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="jenis_klaim" id="inlineRadio1" value="Jaminan Rumah Sakit" @if($data->dataNasabah->jenis_klaim == "Jaminan Rumah Sakit") checked  @endif disabled>
                                <label class="form-check-label" for="inlineRadio1">Jaminan Rumah Sakit</label>
                              </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="jenis_klaim" id="inlineRadio2" value="Santunan Meninggal Dunia"@if($data->dataNasabah->jenis_klaim == "Santunan Meninggal Dunia") checked  @endif disabled>
                                <label class="form-check-label" for="inlineRadio2">Santunan Meninggal Dunia</label>
                            </div>
    
                            @else
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="jenis_klaim" id="inlineRadio1" value="Jaminan Rumah Sakit"  required>
                                <label class="form-check-label" for="inlineRadio1" for=""@error('jenis_klaim') class="text-danger" @enderror>Jaminan Rumah Sakit</label>
                              </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="jenis_klaim" id="inlineRadio2" value="Santunan Meninggal Dunia" required>
                                <label class="form-check-label" for="inlineRadio2" for=""@error('jenis_klaim') class="text-danger" @enderror>Santunan Meninggal Dunia</label>
                            </div>
                            @error('jenis_klaim')
                                    <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                            @endif
                        </div>
                    </div>
                    
                </div>
                <div class="form-row">
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label for=""@error('lokasi_kecelakaan') class="text-danger" @enderror >Lokasi Kecelakaan
                            </label>
                            <textarea name="lokasi_kecelakaan" class="form-control" id="" cols="30" rows="3" disabled>{{$data->dataNasabah->lokasi_kecelakaan ??false}}</textarea>
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="col-lg-6 col-sm-12">
                        <div class="form-group">
                            <label for=""@error('tanggal') class="text-danger" @enderror >Tanggal</label>
                            <input type="text" name="tanggal" class="form-control @error('tanggal') form-control is-invalid @enderror"
                            placeholder="" value="{{ \Carbon\Carbon::parse($data->dataNasabah->tanggal)->format('d/m/Y') ?? date('Y-m-d') }} " disabled>
                            @error('tanggal')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                           
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12">
                        <div class="form-group">
                            <label for=""@error('rumah_sakit') class="text-danger" @enderror >Rumah Sakit</label>
                            <input type="text" name="rumah_sakit" class="form-control @error('rumah_sakit') form-control is-invalid @enderror"
                            placeholder="" value="{{ $data->dataNasabah->MobileService->rumah_sakit??false }}" disabled>
                            @error('rumah_sakit')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="col-lg-4 col-sm-12">
                        <div class="form-group">
                            <label for=""@error('nomor_rekening') class="text-danger" @enderror >Nomor Rekening</label>
                            <input type="text" name="nomor_rekening" class="form-control @error('nomor_rekening') form-control is-invalid @enderror"
                            placeholder="" value="{{ $data->dataNasabah->KeuanganUmum->nomor_rekening?? '' }} " readonly>
                            @error('nomor_rekening')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                           
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12">
                        <div class="form-group">
                            <label for=""@error('nama_rekening') class="text-danger" @enderror >Nama Rekening</label>
                            <input type="text" name="nama_rekening" class="form-control @error('nama_rekening') form-control is-invalid @enderror"
                            placeholder="" value="{{ $data->dataNasabah->keuanganUmum->nama_rekening?? '' }} " readonly>
                            @error('nama_rekening')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                           
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12">
                        <div class="form-group">
                            <label for=""@error('nominal_pengajuan') class="text-danger" @enderror >Nominal Pengajuan</label>
                            <input type="text" name="nominal_pengajuan" class="form-control @error('nominal_pengajuan') form-control is-invalid @enderror"
                            placeholder="" value="{{ $data->dataNasabah->keuanganUmum->nominal_pengajuan??false }}" readonly>
                            @error('nominal_pengajuan')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                </div>
                

                <div class="form-group">
                    <a href="javascript:history.back()" class="btn btn-danger mt-3"> Kembali</a>
                    <button type="button" class="btn btn-secondary mt-3" data-toggle="modal" data-target="#exampleModal">
                        Transfer
                    </button>
                      
                    <input type="submit" value="Verifikasi Data" class="btn btn-primary mt-3">
                </div>
            </form>
            <section>
                <!-- Modal -->
                <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Transfer</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                        </div>
                        <div class="modal-body">
                            {{-- <div class="text-center">
                                <img src="https://bri.co.id/o/bri-corporate-theme/images/bri-logo.png" class="img-fluid" alt="...">
                                
                                
                            </div> --}}
                            <table class="table mt-3">
                                    
                                <tbody>
                                 
                                    <tr>
                                        <td>Nama Pemilik Rekening</td>
                                        <td>:</td>
                                        <td>{{ $data->dataNasabah->keuanganUmum->nama_rekening?? '' }}</td>
                                    </tr>
                                    <tr>
                                        <td>Nomor Rekening</td>
                                        <td>:</td>
                                        <td>{{ $data->dataNasabah->KeuanganUmum->nomor_rekening?? '' }} </td>
                                    </tr>
                                </tbody>
                              </table>
                        </div>
                        <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                        
                        </div>
                    </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@push('scripts')
<script>
    let copyText = document.querySelector(".copy-text");
copyText.querySelector("button").addEventListener("click", function () {
	let input = copyText.querySelector("input.text");
	input.select();
	document.execCommand("copy");
	copyText.classList.add("active");
	window.getSelection().removeAllRanges();
	setTimeout(function () {
		copyText.classList.remove("active");
	}, 2500);
});

</script>
@endpush
@endsection