@extends('admin-layouts.master')

@section('content')
<div class="container-fluid">

    <div class="row">
        <div class="col">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h3 class="m-0 font-weight-bold text-primary text-center">Antrian Pemeriksaan</h3>
                </div>
                <div class="card-body">
                    <div class="text-center">
                        <img class="img-fluid px-3 px-sm-4 mt-3 mb-4" style="width: 30rem;"
                            src="{{ asset('template-admin/img/undraw_Queue_j6ij.png') }}" alt="">
                    </div>
                    <center>
                        <div class="card text-center shadow-md" style="width:22rem;">
                            <div class="card-header py-3">
                                <h4 class="m-0 font-weight-bold text-primary text-center">Nomor Antrian</h4>
                            </div>
                            @if($no_antrian != NULL)
                            <div class="card-body">
                                <h1>{{ $no_antrian->nomor_urut }}</h1>
                                {{-- @php
                            
                                    $id_antrian = $no_antrian->id;
                                    
                                    $cek_pemeriksaan = App\Models\Pemeriksaan::whereHas('pasien.antrian', function($q) use ($id_antrian){
                                        $q->where('antrians.id', $id_antrian);
                                    })->where('pasien_id', $no_antrian->pasien_id)->latest()->count();
                                    $cek_pemeriksaan = App\Models\Pemeriksaan::where('pasien_id', $no_antrian->pasien_id)->where('antrian_id', $no_antrian->id)->latest()->count();
                                @endphp --}}
                                {{-- @if($cek_pemeriksaan == 0)
                                    <a href="{{ route('pemeriksaan.create.pasien', $no_antrian->pasien->nama_pasien) }}" class="btn btn-primary">Cek Sekarang</a>
                                @else
                                
                                    <button class="btn btn-warning" type="button" disabled>
                                        <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                        Sedang Menunggu Pemeriksaan
                                    </button>
                                    
                                @endif --}}
                                                        
                            @else
                            <div class="card-body">
                                <h3 class="text-danger">Belum Ada Antrian Pasien</h3>
                            </div>
                            @endif
                        </div>
                    </center>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h4 class="m-0 font-weight-bold text-primary text-center">Daftar Nama Pasien Antrian Pemeriksaan</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>No Rekam Medis</th>
                                    <th>Nama Pasien</th>
                                    <th>Nomor Antrian</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            
                            <tbody>
                                @forelse ($data_antrian as $item)
                                <tr>
                                    @php
                                        $cek_pemeriksaan2 = App\Models\Pemeriksaan::where('pasien_id', $item->pasien_id)->where('antrian_id', $item->id)->first();
                                    @endphp
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $item->pasien->nomor_rekam_medis }}</td>
                                    <td>{{ $item->pasien->nama_pasien }}</td>
                                    <td>{{ $item->nomor_urut }}</td>
                                    <td>
                                        @if($cek_pemeriksaan2 == NULL)
                                        <a class="btn btn-success" href="{{ route('pemeriksaan.create.pasien', $item->pasien->id)}}"><i class="fas fa-edit"></i> Periksa Pasien</a>
                                        <button href="{{route('antrian.hapus', $item)}}" id="delete" class="btn btn-danger">Hapus</button>
                                        @else
                                        <button href="{{route('antrian.hapus', $item)}}" id="delete" class="btn btn-danger">Hapus</button>
                                        <button class="btn btn-danger" type="button" disabled>
                                            <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                            Sedang Menunggu Verifikasi
                                        </button>
                                        <a class="btn btn-warning" href="{{ route('pemeriksaan.edit',$cek_pemeriksaan2->id) }}"><i class="fas fa-edit"></i> Edit</a>
                                        
                                        @endif
                                        {{-- @if($cek_riwayat != NULL)
                                        <a class="btn btn-info" href="{{ route('pemeriksaan.dokter.riwayat', $item->pasien->nama_pasien) }}"><i class="fas fa-history"></i> Riwayat Pasien</a>
                                        @endif --}}
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" class="text-center">
                                        <div class="spinner-grow text-primary" role="status">
                                            <span class="sr-only">Loading...</span>
                                          </div>
                                        <h5 class="mt-1">Menunggu Pasien Antrian Sedang Dalam Pemeriksaan</h5>
                                    </td>
                                </tr>
                                @endforelse
                                
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
<form action="" method="post" id="deleteForm">
    @csrf
    @method("DELETE")
    <input type="submit" value="Hapus" style="display:none">
    </form>
    @push('scripts')
    
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ho+j7jyWK8fNQe+A12Hb8AhRq26LrZ/JpcUGGOn+Y7RsweNrtN/tE3MoK7ZeZDyx" crossorigin="anonymous">
    </script>

    <script>
    $('button#delete').on('click', function(e){
      e.preventDefault();
    
      var href = $(this).attr('href');
    
      Swal.fire({
          title: 'Apakah Kamu yakin akan menghapus data ini?',
          text: "Data yang sudah dihapus tidak dapat dikembalikan!",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Ya, Hapus!'
          }).then((result) => {
          if (result.value) {
              document.getElementById('deleteForm').action = href;
              document.getElementById('deleteForm').submit();
                  Swal.fire(
                  'Berhasi Dihapus!',
                  'Data Kamu Berhasil Dihapus.',
                  'success'
                  )
              }
          })
    
    
    })
   
    </script>
@endpush
@endsection